/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineUnknownWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class CmdLineRadioBoxWidget
extends CmdLineWidget
implements Widget,
RadioBoxWidget {
    private List widgets = new ArrayList();
    private String title;
    private String displayTitle;
    private boolean isHorizontal;
    private boolean isVertical;

    public CmdLineRadioBoxWidget(String text) {
        this.title = text;
        this.displayTitle = text;
    }

    public CmdLineRadioBoxWidget(Form form, String text, String reload, Element element, String required, String editable, String scrollable, String orientation, String defaultValue, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String id, String newRow, String fontColor) {
        this.form = form;
        this.title = text;
        this.reload = reload != null && reload.equalsIgnoreCase("yes");
        List widgetElms = element.getChildren();
        Iterator i = widgetElms.iterator();
        while (i.hasNext()) {
            this.addWidget(this.createWidget((Element)i.next()));
        }
        if (required != null && required.equalsIgnoreCase("yes")) {
            this.required = true;
            this.displayTitle = I18N.getString("is.required.lbl") + text;
        } else {
            this.required = false;
            this.displayTitle = text;
        }
        this.editable = editable == null || editable.equalsIgnoreCase("yes");
        this.scrollable = scrollable != null && scrollable.equalsIgnoreCase("yes");
        if (orientation != null && orientation.equalsIgnoreCase("vertical")) {
            this.isHorizontal = false;
            this.isVertical = true;
        } else {
            this.isVertical = false;
            this.isHorizontal = true;
        }
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        this.defaultValue = defaultValue;
        if (defaultValue != null && defaultValue.length() > 0) {
            this.setDefaultValue(defaultValue);
        }
        this.note = note;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize != null ? Integer.parseInt(fontSize) : 0;
        this.id = id;
        this.newRow = newRow == null || !newRow.equalsIgnoreCase("no");
        this.fontColor = fontColor;
    }

    public void setDefaultValue(String defaultValue) {
        Iterator i = this.widgets.iterator();
        while (i.hasNext()) {
            Widget widgetInBox = (Widget)i.next();
            if (!(widgetInBox instanceof SelectWidget) || !((CmdLineSelectWidget)widgetInBox).getText().equalsIgnoreCase(defaultValue)) continue;
            ((CmdLineSelectWidget)widgetInBox).setSelected(true);
            this.defaultValue = defaultValue;
        }
    }

    private Widget createWidget(Element element) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        String name = element.getName();
        result = name.equalsIgnoreCase(WidgetType.SELECT.toString()) ? new CmdLineSelectWidget(this.form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "onclicknext"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), null, null, null, null, null, null, null, null, null, null) : new CmdLineUnknownWidget(CmdLineWizard.getText(element));
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List getWidgets() {
        return this.widgets;
    }

    public void addWidget(Widget widget) {
        if (widget != null) {
            WidgetType type = widget.getType();
            String text = widget.getText();
            boolean exists = false;
            Iterator i = this.widgets.iterator();
            while (i.hasNext()) {
                Widget existingWidget = (Widget)i.next();
                if (widget.getType() != WidgetType.SELECT || text == null || !text.equals(existingWidget.getText()) || type != existingWidget.getType()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.widgets.add(widget);
            }
        }
    }

    public WidgetType getType() {
        return WidgetType.RADIOBOX;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String text) {
        this.title = text;
    }

    public void draw() {
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public boolean isVertical() {
        return this.isVertical;
    }
}

