/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.cli;

import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.cli.CmdLineReflectionWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineSelectWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineUnknownWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWidget;
import com.sun.cns.basicreg.wizard.cli.CmdLineWizard;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class CmdLineComboBoxWidget
extends CmdLineWidget
implements Widget,
ComboBoxWidget {
    private List widgets = new ArrayList();
    private String title;
    private String displayTitle;
    private String load;
    private int size;
    private static String defaultSize = "10";

    public CmdLineComboBoxWidget(String text) {
        this.title = text;
        this.displayTitle = text;
    }

    public CmdLineComboBoxWidget(Form form, String text, String reload, Element element, String required, String editable, String scrollable, String load, String defaultValue, String size, String validPattern, String patternError, String validMatch, String matchError, String note, String fontSize, String fontStyle, String id, String newRow, String fontColor, String s508Name, String s508Desc, String mnemonic) {
        this.form = form;
        this.title = text;
        this.reload = reload != null && reload.equalsIgnoreCase("yes");
        this.defaultValue = defaultValue;
        this.validPattern = validPattern;
        this.patternError = patternError;
        this.validMatch = validMatch;
        this.matchError = matchError;
        this.size = size != null && size.length() > 0 ? Integer.parseInt(size) : Integer.parseInt(defaultSize);
        List widgetElms = element.getChildren();
        if (load != null && load.equalsIgnoreCase("yes")) {
            Iterator i = widgetElms.iterator();
            while (i.hasNext()) {
                Element widgetElm = (Element)i.next();
                String name = widgetElm.getName();
                String className = widgetElm.getChildText("className");
                String methodName = widgetElm.getChildText("methodName");
                if (!name.equalsIgnoreCase(WidgetType.REFLECTION.toString())) continue;
                this.processReflectionWidget(className, methodName);
            }
        } else {
            Iterator i = widgetElms.iterator();
            while (i.hasNext()) {
                this.addWidget(this.createWidget((Element)i.next()));
            }
        }
        if (required != null && required.equalsIgnoreCase("yes")) {
            this.required = true;
            this.displayTitle = I18N.getString("is.required.lbl") + text;
        } else {
            this.required = false;
            this.displayTitle = " " + text;
        }
        this.editable = editable == null || editable.equalsIgnoreCase("yes");
        this.scrollable = scrollable != null && scrollable.equalsIgnoreCase("yes");
        if (defaultValue != null && defaultValue.length() > 0) {
            this.setDefaultValue(defaultValue);
        }
        this.note = note;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize != null ? Integer.parseInt(fontSize) : 0;
        this.id = id;
        this.newRow = newRow == null || !newRow.equalsIgnoreCase("no");
        this.fontColor = fontColor;
        this.s508Name = s508Name;
        this.s508Desc = s508Desc;
        this.mnemonic = mnemonic;
    }

    public void setDefaultValue(String defaultValue) {
        Iterator i = this.widgets.iterator();
        while (i.hasNext()) {
            Widget widgetInBox = (Widget)i.next();
            if (!(widgetInBox instanceof SelectWidget) || !((CmdLineSelectWidget)widgetInBox).getText().equalsIgnoreCase(defaultValue)) continue;
            ((CmdLineSelectWidget)widgetInBox).setSelected(true);
            this.defaultValue = defaultValue;
        }
    }

    private void processReflectionWidget(String className, String methodName) {
        ArrayList newWidgets = new ArrayList();
        Object result = null;
        Object collector = null;
        try {
            Class<?> clazz = Class.forName(className);
            Method getInstance = clazz.getMethod("getInstance", null);
            Object object = getInstance.invoke(null, null);
            Method method = clazz.getMethod(methodName, null);
            result = method.invoke(object, null);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        if (result != null && result instanceof List) {
            List results = (List)result;
            Iterator j = results.iterator();
            while (j.hasNext()) {
                this.addWidget(this.createWidget(WidgetType.SELECT.toString(), j.next().toString()));
            }
        }
    }

    private Widget createWidget(String widgetType, String name) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        if (widgetType.equalsIgnoreCase(WidgetType.SELECT.toString())) {
            result = new CmdLineSelectWidget(name);
        }
        return result;
    }

    private Widget createWidget(Element element) {
        CmdLineWidget result = new CmdLineUnknownWidget("");
        String name = element.getName();
        result = name.equalsIgnoreCase(WidgetType.SELECT.toString()) ? new CmdLineSelectWidget(this.form, CmdLineWizard.getText(element), CmdLineWizard.getAttributeValue(element, "reload"), CmdLineWizard.getAttributeValue(element, "onclicknext"), CmdLineWizard.getAttributeValue(element, "required"), CmdLineWizard.getAttributeValue(element, "editable"), CmdLineWizard.getAttributeValue(element, "pattern"), CmdLineWizard.getAttributeValue(element, "patternError"), CmdLineWizard.getAttributeValue(element, "match"), CmdLineWizard.getAttributeValue(element, "matchError"), CmdLineWizard.getAttributeValue(element, "note"), CmdLineWizard.getAttributeValue(element, "fontsize"), CmdLineWizard.getAttributeValue(element, "fontstyle"), CmdLineWizard.getAttributeValue(element, "newrow"), CmdLineWizard.getAttributeValue(element, "fontcolor"), null, null, null, null, null, null, null, null, null, null) : (name.equalsIgnoreCase(WidgetType.REFLECTION.toString()) ? new CmdLineReflectionWidget(element.getAttributeValue("type"), element.getAttributeValue("className"), element.getAttributeValue("methodName")) : new CmdLineUnknownWidget(CmdLineWizard.getText(element)));
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDisplayTitle() {
        return this.displayTitle;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public List getWidgets() {
        return this.widgets;
    }

    public void addWidget(Widget widget) {
        if (widget != null) {
            WidgetType type = widget.getType();
            String text = widget.getText();
            boolean exists = false;
            Iterator i = this.widgets.iterator();
            while (i.hasNext()) {
                Widget existingWidget = (Widget)i.next();
                if (widget.getType() != WidgetType.SELECT || text == null || !text.equals(existingWidget.getText()) || type != existingWidget.getType()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.widgets.add(widget);
            }
        }
    }

    public WidgetType getType() {
        return WidgetType.COMBOBOX;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String text) {
        this.title = text;
    }

    public void draw() {
    }

    public int getSize() {
        return this.size;
    }
}

