/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.NAUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.UpdateMgrUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class LocalCache {
    static final String NEWANALYSISDIR = "/var/sadm/spool/cache/updatemanager/analysis.results/";
    static final String SMPATCHCMD = "/usr/sbin/smpatch get patchpro.patchset";
    static String fqNewAnalysisFile;
    static String fqSaveAnalysisFile;
    static String homeDirectory;
    static String newAnalysisFile;

    public static void initInfo(boolean debug) {
        homeDirectory = new String(NAUtils.getHomeDirectory(debug));
        if (UMData.getDebug()) {
            System.out.println("initInfo(): homeDir=" + homeDirectory);
        }
        UMData.setEncodedFileName(null);
        NAUtils.readAssetId(debug);
        if (newAnalysisFile != null) {
            fqSaveAnalysisFile = new String(NAUtils.getFullyQualifiedLocalCachePath(debug) + newAnalysisFile);
        }
    }

    public static int saveAnalysisResult(String newAnalysis, boolean debug) {
        newAnalysisFile = new String(UpdateMgrUtil.getInstance().getEncodedFileName(newAnalysis.trim()));
        fqNewAnalysisFile = new String(NEWANALYSISDIR + newAnalysisFile);
        return LocalCache.saveAnalysisResult(debug);
    }

    public static int saveAnalysisResult(String newAnalysis) {
        newAnalysisFile = new String(UpdateMgrUtil.getInstance().getEncodedFileName(newAnalysis.trim()));
        fqNewAnalysisFile = new String(NEWANALYSISDIR + newAnalysisFile);
        return LocalCache.saveAnalysisResult(false);
    }

    public static int saveAnalysisResult() {
        return LocalCache.saveAnalysisResult(false);
    }

    public static int saveAnalysisResult(boolean debug) {
        BufferedReader newAnalysis = null;
        BufferedWriter saveAnalysis = null;
        int rc = 0;
        if (newAnalysisFile == null) {
            LocalCache.refreshFQNewAnalysisFile(debug);
        }
        if (fqSaveAnalysisFile == null) {
            LocalCache.refreshFQSaveAnalysisFile(debug);
        }
        if (UMData.getDebug()) {
            System.out.println("saveAnalysisResult(): new=" + LocalCache.getFullyQualifiedNewAnalysisFile(debug) + "|");
        }
        if (UMData.getDebug()) {
            System.out.println("saveAnalysisResult(): sav=" + LocalCache.getFullyQualifiedSaveAnalysisFile(debug) + "|");
        }
        LocalCache.testAndCreateSaveDir(debug);
        try {
            newAnalysis = new BufferedReader(new FileReader(LocalCache.getFullyQualifiedNewAnalysisFile(debug)));
            if (UMData.getDebug()) {
                System.out.println("saveAnalysisResult(): success open newAnalysis file=" + LocalCache.getFullyQualifiedNewAnalysisFile(debug) + "| for reading");
            }
        }
        catch (FileNotFoundException err) {
            if (debug) {
                System.out.println("saveAnalysisResult(): new analysis file does not exist.");
            }
        }
        catch (IOException err) {
            System.out.println("saveAnalysisResult(): cannot open new analysis file.");
            err.printStackTrace();
            rc = 1;
        }
        try {
            saveAnalysis = new BufferedWriter(new FileWriter(LocalCache.getFullyQualifiedSaveAnalysisFile(debug)));
            if (UMData.getDebug()) {
                System.out.println("saveAnalysisResult(): success open saveAnalysis file=" + LocalCache.getFullyQualifiedSaveAnalysisFile(debug) + "| for backing up");
            }
        }
        catch (IOException err) {
            System.out.println("saveAnalysisResult(): cannot open save analysis file.");
            err.printStackTrace();
            rc = 1;
        }
        if (newAnalysis != null & saveAnalysis != null) {
            try {
                String line;
                while ((line = newAnalysis.readLine()) != null) {
                    saveAnalysis.write(line, 0, line.length());
                    saveAnalysis.write("\n");
                }
            }
            catch (IOException err) {
                System.out.println("saveAnalysisResult(): IO Exception occurs while read/write.");
                err.printStackTrace();
                rc = 1;
            }
        }
        try {
            if (newAnalysis != null) {
                newAnalysis.close();
            }
            if (saveAnalysis != null) {
                saveAnalysis.flush();
                saveAnalysis.close();
            }
            if (UMData.getDebug()) {
                System.out.println("saveAnalysisResult(): success copy analysis file to backup.");
            }
        }
        catch (Exception err) {
            System.out.println("saveAnalysisResult(): IO Exception occurs while read/write.");
            err.printStackTrace();
            rc = 1;
        }
        return rc;
    }

    public static boolean testAndCreateSaveDir(boolean debug) {
        File tempDir;
        String swupDir = new String(NAUtils.getFullyQualifiedLocalCachePath(debug));
        try {
            tempDir = new File(swupDir);
        }
        catch (Exception er) {
            System.out.println("testAndCreateSaveDir(): cannot open " + swupDir);
            er.printStackTrace();
            return false;
        }
        try {
            tempDir.mkdirs();
        }
        catch (Exception err) {
            System.out.println("testAndCreateSaveDir(): cannot create directory " + swupDir);
            err.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean testAndCreateDir(String dir, boolean debug) {
        File tempDir;
        try {
            tempDir = new File(dir);
        }
        catch (Exception er) {
            System.out.println("testAndCreateDir(): cannot open " + dir);
            er.printStackTrace();
            return false;
        }
        try {
            tempDir.mkdirs();
        }
        catch (Exception err) {
            System.out.println("testAndCreateDir(): cannot create directory " + dir);
            err.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean refreshFQSaveAnalysisFile(boolean debug) {
        if (homeDirectory != null) {
            fqSaveAnalysisFile = new String(NAUtils.getFullyQualifiedLocalCachePath(debug) + newAnalysisFile);
            return true;
        }
        fqSaveAnalysisFile = null;
        return false;
    }

    public static String getFullyQualifiedSaveAnalysisFile(boolean debug) {
        return fqSaveAnalysisFile;
    }

    public static String getFullyQualifiedNewAnalysisFile(boolean debug) {
        return fqNewAnalysisFile;
    }

    public static boolean refreshFQNewAnalysisFile(boolean debug) {
        String file = LocalCache.executeSmPatchCmd(debug);
        if (UMData.getDebug()) {
            System.out.println("refreshFQNewAnalysisFile(): file=" + file);
        }
        if (file != null) {
            file = file.trim();
            newAnalysisFile = UpdateMgrUtil.getInstance().getEncodedFileName(file);
            File storedDataFile = UpdateMgrUtil.getInstance().getStoredDataFile(file);
            if (storedDataFile != null) {
                try {
                    fqNewAnalysisFile = storedDataFile.getCanonicalPath();
                }
                catch (IOException ie) {
                    fqNewAnalysisFile = null;
                    return false;
                }
            }
            return true;
        }
        newAnalysisFile = null;
        fqNewAnalysisFile = null;
        return false;
    }

    private static String executeSmPatchCmd(boolean debug) {
        if (UMData.getDebug()) {
            System.out.println("executeSmPatchCmd()");
        }
        ExecuteCommand ec = new ExecuteCommand(SMPATCHCMD);
        ec.setCollectOutput(true);
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return null;
        }
        String cmdOutput = ec.getAllOutput();
        char[] file = cmdOutput.toCharArray();
        file[cmdOutput.length() - 1] = '\u0000';
        String filename = new String(file);
        if (UMData.getDebug()) {
            System.out.println("executeSmPatchCmd(): smpatch returns filename=" + filename + "|");
        }
        if (filename != null) {
            return filename;
        }
        return null;
    }
}

