/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NHelper {
    private static String DEFAULT_IDENTIFIER = "strings";
    private ResourceBundle bundle = null;

    public I18NHelper(Class inParentClass) {
        this(inParentClass, DEFAULT_IDENTIFIER);
    }

    public I18NHelper(Class inParentClass, String inIdentifier) {
        try {
            if (inParentClass != null && inIdentifier != null) {
                this.bundle = ResourceBundle.getBundle(inIdentifier, Locale.getDefault(), inParentClass.getClassLoader());
            }
        }
        catch (MissingResourceException e) {
            System.err.println("can't find IT");
            System.err.println(e.getLocalizedMessage());
        }
    }

    public String getString(String inKey) {
        String result;
        try {
            result = this.bundle.getString(inKey);
        }
        catch (Exception e) {
            result = "[MISSING RESOURCE: " + inKey + "]";
        }
        return result;
    }

    public String format(String inKey, Object[] inArgs) {
        MessageFormat formatter = new MessageFormat(this.getString(inKey));
        String result = formatter.format(inArgs);
        return result;
    }
}

