/*
 * Decompiled with CFR 0.152.
 */
package com.sun.srs.im;

import com.sun.srs.im.CallbackParams;
import com.sun.srs.im.MessageData;
import com.sun.srs.im.ProxyConnection;
import com.sun.srs.im.ProxyException;
import com.sun.srs.im.ProxyIOException;
import com.sun.srs.im.RegistrationException;
import com.sun.srs.im.SRSMockProxy;
import com.sun.srs.im.SRSProxyListener;
import com.sun.srs.im.StatusData;
import com.sun.srs.im.SupportInstanceData;
import java.util.Collections;
import java.util.List;

public class SRSProxy {
    public static final String MGMTID_IM = "SRS_IM_TARGET";
    public static final String MGMTID_SMS = "SRS_SYSMGMT_TARGET";
    private boolean registered;
    private SRSMockProxy moxy;
    private SRSProxyListener clientListener;
    private ProxyConnection conn;

    public SRSProxy() {
        this(null);
    }

    public static void setRetries(int cnt, int interval) {
        ProxyConnection.setRetries(cnt, interval);
    }

    public SRSProxy(SRSMockProxy moxy) {
        this.moxy = moxy;
        this.registered = false;
        this.conn = null;
    }

    public synchronized void registerIM(String name, String version, CallbackParams params) throws ProxyException, ProxyIOException {
        if (name == null) {
            throw new IllegalArgumentException("no name specified");
        }
        if (version == null) {
            throw new IllegalArgumentException("no version specified");
        }
        if (params == null) {
            throw new IllegalArgumentException("no callback params specified");
        }
        if (this.registered) {
            throw new RegistrationException("an IM is already registered with this SRSProxy instance");
        }
        this.clientListener = params.getListener();
        this.conn = new ProxyConnection(name, version, params, this.moxy);
        this.registered = true;
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = null;
        this.registered = false;
    }

    public void send(String mgmtId, MessageData data) throws ProxyException, ProxyIOException {
        if (mgmtId == null) {
            throw new IllegalArgumentException("null mgmtid");
        }
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        if (!this.registered) {
            throw new RegistrationException("IM is not registered");
        }
        this.conn.sendData(mgmtId, data);
    }

    public void sendStatus(List componentStatuses) throws ProxyException, ProxyIOException {
        if (componentStatuses == null) {
            throw new IllegalArgumentException("null componentStatuses");
        }
        if (componentStatuses.size() <= 0) {
            throw new IllegalArgumentException("empty componentStatuses");
        }
        for (int i = 0; i < componentStatuses.size(); ++i) {
            Object o = componentStatuses.get(i);
            if (o instanceof StatusData) continue;
            throw new IllegalArgumentException("list element " + i + " is not a StatusData");
        }
        if (!this.registered) {
            throw new RegistrationException("IM is not registered");
        }
        this.conn.sendStatus(componentStatuses);
    }

    public void registerSupportInstance(SupportInstanceData sid) throws ProxyException, ProxyIOException {
        if (sid == null) {
            throw new IllegalArgumentException("null supportInstance");
        }
        this.registerSupportInstances(Collections.singletonList(sid));
    }

    public void registerSupportInstances(List supportInstances) throws ProxyException, ProxyIOException {
        if (supportInstances == null) {
            throw new IllegalArgumentException("null supportInstances");
        }
        if (supportInstances.size() <= 0) {
            throw new IllegalArgumentException("empty supportInstances");
        }
        for (int i = 0; i < supportInstances.size(); ++i) {
            Object o = supportInstances.get(i);
            if (o instanceof SupportInstanceData) continue;
            throw new IllegalArgumentException("list element " + i + " is not a SupportInstanceData");
        }
        if (!this.registered) {
            throw new RegistrationException("IM is not registered");
        }
        this.conn.registerSI(supportInstances);
    }

    public void deregisterSupportInstance(String mgmtId) throws ProxyException, ProxyIOException {
        if (mgmtId == null || mgmtId.length() == 0) {
            throw new IllegalArgumentException("null/empty mgmtId");
        }
        if (!this.registered) {
            throw new RegistrationException("IM is not registered");
        }
        this.conn.deregisterSI(mgmtId);
    }

    protected void finalize() {
        this.close();
    }
}

