/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cc.platform.clientsignature;

import com.sun.cc.platform.clientsignature.CNSSignException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;

public class CNSClientSignature {
    private int cnsSigCtx;
    private byte[] errorBuffer = new byte[4096];

    native int cnsClientSignInit(byte[] var1);

    native void cnsClientSignUpdate(int var1, byte[] var2);

    native byte[] cnsClientSignFinal(int var1, byte[] var2);

    native void cnsClientFreeCtx(int var1);

    public CNSClientSignature() throws CNSSignException {
        this.cnsSigCtx = this.cnsClientSignInit(this.errorBuffer);
        if (this.cnsSigCtx == 0) {
            this.throwError();
        }
    }

    public void update(byte[] byArray) throws CNSSignException {
        this.assertActiveState();
        this.cnsClientSignUpdate(this.cnsSigCtx, byArray);
    }

    public static String genSigString(byte[] byArray) throws CNSSignException {
        CNSClientSignature cNSClientSignature = new CNSClientSignature();
        cNSClientSignature.update(byArray);
        return cNSClientSignature.genSigStringFromUpdate();
    }

    public static byte[] genSigBytes(byte[] byArray) throws CNSSignException {
        CNSClientSignature cNSClientSignature = new CNSClientSignature();
        cNSClientSignature.update(byArray);
        return cNSClientSignature.genSigBytesFromUpdate();
    }

    private byte[] genSigBytesFromUpdate() throws CNSSignException {
        this.assertActiveState();
        byte[] byArray = this.cnsClientSignFinal(this.cnsSigCtx, this.errorBuffer);
        this.cnsSigCtx = 0;
        if (byArray == null) {
            this.throwError();
        }
        return byArray;
    }

    private String genSigStringFromUpdate() throws CNSSignException {
        try {
            return new String(this.genSigBytesFromUpdate(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CNSSignException("CNSClientSignature.generateSignatureString: Logic error:\n" + unsupportedEncodingException.getMessage());
        }
    }

    private void assertActiveState() throws CNSSignException {
        if (this.cnsSigCtx == 0) {
            throw new CNSSignException("CNSClientSignature.update: Invalid State.  Object can not be reused after calling final");
        }
    }

    private void throwError() throws CNSSignException {
        try {
            String string = new String(this.errorBuffer, "ISO-8859-1");
            throw new CNSSignException(string.trim());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CNSSignException("CNSClientSignature.throwError: Logic error:\n" + unsupportedEncodingException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage:");
            System.err.println("   java -cp {CLASSPATH} com.sun.cc.platform.clientsignature.CNSClientSignature {DATAFILE_IN} {SIGNFILE_OUT}");
            System.exit(1);
        }
        try {
            CNSClientSignature.generateSignature(stringArray[0], stringArray[1]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void generateSignature(String string, String string2) throws Exception {
        Object object;
        byte[] byArray = new byte[2048];
        CNSClientSignature cNSClientSignature = new CNSClientSignature();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        int n = 0;
        while ((n = fileInputStream.read(byArray)) >= 0) {
            object = new byte[n];
            System.arraycopy(byArray, 0, object, 0, n);
            cNSClientSignature.update((byte[])object);
        }
        fileInputStream.close();
        object = new FileOutputStream(new File(string2));
        ((FileOutputStream)object).write(cNSClientSignature.genSigBytesFromUpdate());
        ((FileOutputStream)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.cnsSigCtx != 0) {
                // empty if block
            }
            this.cnsClientFreeCtx(this.cnsSigCtx);
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("sign");
    }
}

