<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" />
<xsl:template match="/" >
<html>
    <head><title>Limited Asset Information</title></head>
<body>
<table border="0">

     <xsl:for-each select='computer.system/system.information/host.id'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/operating.system'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/memory.size'> 
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
                <td valign="top">
                    <xsl:if test="string(.)">
                        <xsl:value-of select='.'/>
                        <xsl:text> </xsl:text>
                        <xsl:value-of select='//memory.size/@units'/>                        
                    </xsl:if>
            
                    <xsl:if test="not(string(.))">
                    N/A
                    </xsl:if>
                </td>
            </tr>            
    </xsl:for-each>
    <xsl:for-each select='computer.system/system.information/cpu.list'> 
            <tr>
                <td valign="top"><b>number.cpus</b></td>
                <td valign="top">
                    <xsl:value-of select='//cpu.list/@populated'/>                        
                </td>
            </tr>            
    </xsl:for-each>
     <xsl:for-each select='computer.system/system.information/cpu.list'>
            <tr>
                <td valign="top"><b><xsl:value-of select='name()'/></b></td>
        
                <td valign="top">
                    <table padding="2">
                         <xsl:for-each select='cpu'> 
                         <xsl:sort select='@id'/>                                                  
                            <th align="left" colspan="2">cpu<xsl:value-of select='@id'/></th>                                                                                            
                            <tr>
                                <td align="right">architecture</td>
                                <td align="right">
                                <xsl:if test="string(cpu.architecture)">
                                <xsl:value-of select='cpu.architecture'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.architecture))">
                                    N/A
                                </xsl:if>
                                </td>
                           </tr>
                          
                           <tr>
                                <td align="right">device.id</td>
                                <td align="right">
                                <xsl:if test="string(cpu.device.id)">
                                <xsl:value-of select='cpu.device.id'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.device.id))">
                                    N/A
                                </xsl:if>
                                </td> 
                            </tr>  
                                                 
                            <tr>                               
                                <td align="right">model</td>
                                <td align="right">
                                <xsl:if test="string(cpu.model)">
                                <xsl:value-of select='cpu.model'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.model))">
                                    N/A
                                </xsl:if>                                
                                </td>
                            </tr>  
                                                     
                            <tr>                               
                                <td align="right">speed</td>
                                <td align="right">
                                <xsl:if test="string(cpu.speed)">
                                <xsl:value-of select='cpu.speed'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.speed))">
                                    N/A
                                </xsl:if>
                                <xsl:text> </xsl:text><xsl:value-of select='//cpu.speed/@units'/></td>
                            </tr>                          
                            <tr>                               
                                <td align="right">memory</td>
                                <td align="right">
                                <xsl:if test="string(cpu.memory)">
                                <xsl:value-of select='cpu.memory'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.memory))">
                                    N/A
                                </xsl:if>
                                </td>
                             </tr>
                             <tr>                               
                                <td align="right">status</td>
                                <td align="right">
                                <xsl:if test="string(cpu.status)">
                                <xsl:value-of select='cpu.status'/>
                                </xsl:if>
                                <xsl:if test="not(string(cpu.status))">
                                    N/A
                                </xsl:if>
                                </td>                                                                                               
                             </tr>                                                                          
                         </xsl:for-each> 
                    </table>
                </td>               
                
            </tr>       
    </xsl:for-each>
</table>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
