/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.Envelope;
import com.sun.xml.messaging.saaj.soap.SOAPPartImpl;
import com.sun.xml.messaging.saaj.soap.SOAPVersionMismatchException;
import com.sun.xml.messaging.saaj.util.ParserPool;
import com.sun.xml.messaging.saaj.util.RejectDoctypeSaxFilter;
import com.sun.xml.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class EnvelopeFactory {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    private static ParserPool parserPool = new ParserPool(5);

    public static Envelope createEnvelope(Source src, SOAPPartImpl soapPart) throws SOAPException {
        SAXParser saxParser = null;
        if (src instanceof StreamSource) {
            RejectDoctypeSaxFilter rejectFilter;
            try {
                saxParser = parserPool.get();
            }
            catch (Exception e) {
                log.severe("SAAJ0601.util.newSAXParser.exception");
                throw new SOAPExceptionImpl("Couldn't get a SAX parser while constructing a envelope", e);
            }
            InputSource is = SAXSource.sourceToInputSource(src);
            try {
                rejectFilter = new RejectDoctypeSaxFilter(saxParser);
            }
            catch (Exception ex) {
                log.severe("SAAJ0510.soap.cannot.create.envelope");
                throw new SOAPExceptionImpl("Unable to create envelope from given source: ", ex);
            }
            src = new SAXSource(rejectFilter, is);
        }
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            DOMResult result = new DOMResult((Node)((Object)soapPart));
            transformer.transform(src, result);
            Envelope env = (Envelope)soapPart.getEnvelope();
            if (saxParser != null) {
                parserPool.put(saxParser);
            }
            return env;
        }
        catch (Exception ex) {
            if (ex instanceof SOAPVersionMismatchException) {
                throw (SOAPVersionMismatchException)((Object)ex);
            }
            log.severe("SAAJ0511.soap.cannot.create.envelope");
            throw new SOAPExceptionImpl("Unable to create envelope from given source: ", ex);
        }
    }
}

