/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.wizard.ComboBoxWidget;
import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.JumpWidget;
import com.sun.cns.basicreg.wizard.LinkWidget;
import com.sun.cns.basicreg.wizard.RadioBoxWidget;
import com.sun.cns.basicreg.wizard.ResponseWidget;
import com.sun.cns.basicreg.wizard.SelectWidget;
import com.sun.cns.basicreg.wizard.TextAreaWidget;
import com.sun.cns.basicreg.wizard.TextIconLabelWidget;
import com.sun.cns.basicreg.wizard.TextWidget;
import com.sun.cns.basicreg.wizard.Widget;
import com.sun.cns.basicreg.wizard.WidgetType;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.swing.Field;
import com.sun.cns.basicreg.wizard.swing.FormPanel;
import com.sun.cns.basicreg.wizard.swing.GatherDialog;
import com.sun.cns.basicreg.wizard.swing.JumpButton;
import com.sun.cns.basicreg.wizard.swing.LinkButton;
import com.sun.cns.basicreg.wizard.swing.NavigationListener;
import com.sun.cns.basicreg.wizard.swing.NavigationProvider;
import com.sun.cns.basicreg.wizard.swing.SwingWorker;
import com.sun.cns.basicreg.wizard.swing.Utils;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.ResponseError;
import com.sun.cns.basicreg.wizard.util.Validation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WizardPanel
extends JPanel
implements NavigationListener {
    private JDialog parentDialog;
    private Wizard wizard;
    private NavigationProvider navigationProvider;
    private Form form;
    private int formIndex;
    private FormPanel formPanel;
    private Field[] fields;
    private ResponseError outputResult;
    private int informationWidgetIndex = -1;
    private static final String IS_REQUIRED_ERR_MSG = I18N.getString("is.required.err");
    private static final String IS_ACCEPT_TOU_ERR_MSG = I18N.getString("accept.tou.err");
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 14);
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$swing$WizardPanel == null ? (class$com$sun$cns$basicreg$wizard$swing$WizardPanel = WizardPanel.class$("com.sun.cns.basicreg.wizard.swing.WizardPanel")) : class$com$sun$cns$basicreg$wizard$swing$WizardPanel).getName());
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$swing$WizardPanel;

    public WizardPanel() {
    }

    public WizardPanel(JDialog parentDialog, Wizard wizard, Form form, int formIndex, NavigationProvider navigationProvider) {
        this.parentDialog = parentDialog;
        this.wizard = wizard;
        this.form = form;
        this.formIndex = formIndex;
        this.navigationProvider = navigationProvider;
        this.getAccessibleContext().setAccessibleName(form.getTitle());
        this.getAccessibleContext().setAccessibleDescription(form.getTitle());
        this.buildMe();
    }

    private void buildMe() {
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 1));
        titlePanel.add(Box.createVerticalStrut(4));
        String formTitle = this.form.getTitle();
        JLabel titleLabel = new JLabel(formTitle);
        titleLabel.setFont(TITLE_FONT);
        titleLabel.setAlignmentX(0.0f);
        titlePanel.add(titleLabel);
        titlePanel.add(Box.createVerticalStrut(4));
        titleLabel.getAccessibleContext().setAccessibleName(formTitle);
        titleLabel.getAccessibleContext().setAccessibleDescription(formTitle);
        JSeparator separator = new JSeparator();
        separator.setAlignmentX(0.0f);
        titlePanel.add(Box.createVerticalStrut(4));
        titlePanel.add(separator);
        titlePanel.add(Box.createVerticalStrut(4));
        this.add((Component)titlePanel, "North");
        List widgetList = this.form.getWidgets();
        int numberWidgets = widgetList == null ? 0 : widgetList.size();
        this.fields = new Field[numberWidgets];
        JComponent[] customFields = new JComponent[numberWidgets];
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                this.fields[i] = new Field();
                Widget widget = (Widget)widgetList.get(i);
                this.fields[i].setId(widget.getId());
                this.fields[i].setSubnote(widget.getNote());
                this.fields[i].setPrenote(null);
                this.fields[i].setLabel(widget.getText());
                this.fields[i].setIsRequired(widget.isRequired());
                this.fields[i].setValidPattern(widget.getValidPattern());
                this.fields[i].setIsScrollable(widget.isScrollable());
                this.fields[i].setIsContinueCheck(false);
                this.fields[i].setIsVertical(false);
                this.fields[i].setFontFamily(null);
                this.fields[i].setFontStyle(widget.getFontStyle());
                this.fields[i].setFontSize(widget.getFontSize());
                this.fields[i].setLabelIconFilename(null);
                this.fields[i].setLabelIconDescription(null);
                this.fields[i].setSlaveId(null);
                this.fields[i].setSlaveValue(null);
                this.fields[i].setNextFormIdIfSelected(null);
                this.fields[i].setIsNewRow(widget.isNewRow());
                this.fields[i].setPopulation(null);
                this.fields[i].setInitialValue(widget.getDefaultValue());
                this.fields[i].setIsEditable(widget.isEditable());
                this.fields[i].sets508Name(widget.gets508Name());
                this.fields[i].sets508Desc(widget.gets508Desc());
                this.fields[i].setMnemonic(widget.getMnemonic());
                customFields[i] = null;
                WidgetType widgetType = widget.getType();
                if (widgetType == WidgetType.FIELD) {
                    this.fields[i].setType(1);
                    this.fields[i].setLength(((TextWidget)widget).getSize());
                    continue;
                }
                if (widgetType == WidgetType.PASSWORD) {
                    this.fields[i].setType(4);
                    this.fields[i].setLength(((TextWidget)widget).getSize());
                    continue;
                }
                if (widgetType == WidgetType.TEXTICONLABEL) {
                    this.fields[i].setType(7);
                    this.fields[i].setLabel(null);
                    this.fields[i].setLabelIconFilename(((TextIconLabelWidget)((Object)widget)).getLabelIconFilename());
                    this.fields[i].setLabelIconDescription(((TextIconLabelWidget)((Object)widget)).getLabelIconDescription());
                    this.fields[i].setInitialValue(widget.getText());
                    continue;
                }
                if (widgetType == WidgetType.MESSAGE) {
                    String confirmSystemMessage;
                    this.fields[i].setType(6);
                    this.fields[i].setLabel(null);
                    this.fields[i].setNumberColumns(((TextAreaWidget)widget).getColumns());
                    this.fields[i].setNumberRows(((TextAreaWidget)widget).getRows());
                    this.fields[i].setInitialValue(widget.getText());
                    String fieldId = this.fields[i].getId();
                    if (fieldId == null || !fieldId.equals("SWUPConfirmSystem") && !fieldId.equals("UMConfirmSystem") || (confirmSystemMessage = this.getConfirmSystemMessage(fieldId.equals("SWUPConfirmSystem"))) == null) continue;
                    this.fields[i].setInitialValue(confirmSystemMessage);
                    continue;
                }
                if (widgetType == WidgetType.INFORMATION) {
                    this.informationWidgetIndex = i;
                    this.fields[i].setType(6);
                    this.fields[i].setLabel(null);
                    this.fields[i].setNumberColumns(((TextAreaWidget)widget).getColumns());
                    this.fields[i].setNumberRows(((TextAreaWidget)widget).getRows());
                    this.fields[i].setInitialValue("");
                    continue;
                }
                if (widgetType == WidgetType.HTML) {
                    this.fields[i].setType(8);
                    this.fields[i].setLabel(null);
                    this.fields[i].setInitialValue(widget.getText());
                    continue;
                }
                if (widgetType == WidgetType.RADIOBOX) {
                    this.fields[i].setType(5);
                    RadioBoxWidget radioBoxWidget = (RadioBoxWidget)widgetList.get(i);
                    this.fields[i].setIsVertical(radioBoxWidget.isVertical());
                    List radioBoxWidgetList = radioBoxWidget.getWidgets();
                    this.fields[i].setPopulation(this.getListWidgetPopulation(radioBoxWidgetList).toArray(new String[0]));
                    continue;
                }
                if (widgetType == WidgetType.COMBOBOX) {
                    this.fields[i].setType(2);
                    ComboBoxWidget comboBoxWidget = (ComboBoxWidget)widgetList.get(i);
                    List comboBoxWidgetList = comboBoxWidget.getWidgets();
                    this.fields[i].setPopulation(this.getListWidgetPopulation(comboBoxWidgetList).toArray());
                    continue;
                }
                if (widgetType == WidgetType.JUMP) {
                    this.fields[i].setType(0);
                    JumpWidget jumpWidget = (JumpWidget)((Object)widget);
                    String jumpToIdString = jumpWidget.getJumpToFormIdentifier();
                    customFields[i] = new JumpButton(jumpWidget.getTitle(), this.navigationProvider, this.parentDialog, this.wizard.getFormIndex(jumpToIdString), jumpWidget.getShowButton(), widget.isEditable(), widget.getMnemonic());
                    this.fields[i].setLabel(null);
                    String prenote = widget.getText();
                    if (prenote == null || prenote.trim() == "") continue;
                    this.fields[i].setPrenote(prenote);
                    continue;
                }
                if (widgetType == WidgetType.LINK) {
                    this.fields[i].setType(0);
                    LinkWidget linkWidget = (LinkWidget)((Object)widget);
                    String urlString = linkWidget.getURL();
                    customFields[i] = new LinkButton(linkWidget.getTitle(), this.navigationProvider, urlString, linkWidget.getShowButton(), linkWidget.getEndsWizard(), widget.isEditable(), widget.getMnemonic());
                    this.fields[i].setLabel(null);
                    String prenote = widget.getText();
                    if (prenote == null || prenote.trim() == "") continue;
                    this.fields[i].setPrenote(prenote);
                    continue;
                }
                if (widgetType == WidgetType.SELECT) {
                    this.fields[i].setType(3);
                    SelectWidget selectWidget = (SelectWidget)widget;
                    String selectType = selectWidget.getSelectType();
                    this.fields[i].setIsSelectRadio(selectType.equalsIgnoreCase("radio"));
                    this.fields[i].setButtonGroupId(selectWidget.getGroupId());
                    boolean isSelected = selectWidget.isSelected();
                    this.fields[i].setInitialValue(isSelected ? "true" : "false");
                    this.fields[i].setSlaveId(selectWidget.getSlaveId());
                    this.fields[i].setSlaveValue(selectWidget.getSlaveValue());
                    this.fields[i].setNextFormIdIfSelected(selectWidget.getNextFormIdIfSelected());
                    this.fields[i].setIsContinueCheck(selectWidget.isContinueCheck());
                    continue;
                }
                if (widgetType == WidgetType.HIDDEN) {
                    this.fields[i].setType(9);
                    this.fields[i].setLabel(null);
                    continue;
                }
                this.fields[i].setType(10);
                this.fields[i].setLabel(null);
                LOG.info("IGNORED TYPE: " + widgetType.toString());
            }
            this.formPanel = new FormPanel(this, this.fields, customFields);
            this.add((Component)this.formPanel, "Center");
        }
    }

    public void reloadWidgets() {
        LOG.info(" $ $ $ $ RELOAD WIDGETS");
        List widgetList = this.form.getWidgets();
        for (int index = 0; index < widgetList.size(); ++index) {
            String confirmSystemMessage;
            String widgetId;
            Widget widget = (Widget)widgetList.get(index);
            WidgetType widgetType = widget.getType();
            if (widgetType == WidgetType.REFLECTION || widgetType == WidgetType.UNKNOWN) continue;
            if (widget.isReload()) {
                LOG.finest(" $$$$ RELOAD VALUE: " + widget.getText());
                if (widgetType != WidgetType.HIDDEN) {
                    this.formPanel.setFieldValue(index, widget.getText());
                }
            }
            if ((widgetId = widget.getId()) != null && widgetId.equals("system")) {
                String slaveValue = this.getWidgetSlaveValue("systemselect");
                LOG.info(" >> SET system FIELD VALUE: " + slaveValue);
                this.formPanel.setFieldValue(index, slaveValue);
            }
            if (widgetId == null || !widgetId.equals("SWUPConfirmSystem") && !widgetId.equals("UMConfirmSystem") || (confirmSystemMessage = this.getConfirmSystemMessage(widgetId.equals("SWUPConfirmSystem"))) == null) continue;
            this.fields[index].setInitialValue(confirmSystemMessage);
            this.formPanel.setFieldValue(index, confirmSystemMessage);
        }
    }

    public String getWidgetSlaveValue(String widgetId) {
        if (widgetId == null) {
            return null;
        }
        Widget widget = this.form.getWidgetById(widgetId);
        if (widget == null) {
            LOG.severe("ERROR - no widget with id: " + widgetId);
            return null;
        }
        if (!(widget instanceof SelectWidget)) {
            LOG.severe("ERROR - not a SelectWidget: " + widgetId);
            return null;
        }
        return ((SelectWidget)widget).getSlaveValue();
    }

    public JDialog getParentDialog() {
        return this.parentDialog;
    }

    public Form getForm() {
        return this.form;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    public void setInitialFocus() {
        JComponent firstFocusableComponent = this.formPanel.getFirstFocusableField();
        if (firstFocusableComponent != null) {
            firstFocusableComponent.requestFocusInWindow();
        }
    }

    public void refreshMe() {
        this.validate();
        this.repaint();
    }

    public boolean validateResponses() {
        return this.validateResponses(false);
    }

    private boolean validateResponses(boolean ignoreIsRequiredErrors) {
        int numberWidgets;
        boolean errorsFound = false;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                Widget widget = (Widget)widgetList.get(i);
                WidgetType widgetType = widget.getType();
                String widgetId = widget.getId();
                if (widgetType == WidgetType.HIDDEN || widgetType == WidgetType.REFLECTION) continue;
                if (!this.formPanel.isFieldEditable(i)) {
                    LOG.info("DO NOT VALIDATE AT INDEX: " + i);
                    continue;
                }
                String validationPatternError = Validation.validateValue(this.formPanel.getFieldValue(i), widget);
                String validationMatchError = null;
                String matchValue = null;
                String matchString = widget.getValidMatch();
                String matchError = widget.getMatchError();
                if (matchString != null) {
                    String matchWidgetId = Validation.getMatchWidgetId(matchString);
                    matchValue = matchWidgetId == null ? matchString : this.formPanel.getFieldValue(matchWidgetId);
                    validationMatchError = Validation.validateValueMatch(this.formPanel.getFieldValue(i), matchValue, widget);
                }
                String validationUserPassError = null;
                if (widgetId != null && widgetId.equals("password2")) {
                    Widget usernameWidget = this.form.getWidgetById("username");
                    if (usernameWidget != null) {
                        String usernameId = usernameWidget.getId();
                        if (usernameId != null) {
                            String usernameValue = this.formPanel.getFieldValue(usernameId);
                            String password2Value = this.formPanel.getFieldValue(i);
                            validationUserPassError = Validation.validateUserPass(usernameValue, password2Value);
                        } else {
                            LOG.severe("ERROR - username field has null id");
                        }
                    } else {
                        LOG.severe("ERROR - expected username field not found");
                    }
                }
                if (validationPatternError != null) {
                    if (ignoreIsRequiredErrors && (validationPatternError.equals(IS_REQUIRED_ERR_MSG) || validationPatternError.equals(IS_ACCEPT_TOU_ERR_MSG))) {
                        this.fields[i].setError(null);
                        continue;
                    }
                    this.fields[i].setError(validationPatternError);
                    errorsFound = true;
                    continue;
                }
                if (validationMatchError != null) {
                    this.fields[i].setError(validationMatchError);
                    errorsFound = true;
                    continue;
                }
                if (validationUserPassError != null) {
                    this.fields[i].setError(validationUserPassError);
                    errorsFound = true;
                    continue;
                }
                this.fields[i].setError(null);
            }
        }
        return !errorsFound;
    }

    public void setResponses() {
        int numberWidgets;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            for (int i = 0; i < numberWidgets; ++i) {
                Widget widget = (Widget)widgetList.get(i);
                WidgetType widgetType = widget.getType();
                if (widgetType == WidgetType.FIELD) {
                    if (widget instanceof ResponseWidget) {
                        ((ResponseWidget)((Object)widget)).setResponse(this.formPanel.getFieldValue(i));
                        continue;
                    }
                    LOG.severe("ERROR - FIELD not ResponseWidget");
                    continue;
                }
                if (widgetType == WidgetType.PASSWORD) {
                    if (widget instanceof ResponseWidget) {
                        ((ResponseWidget)((Object)widget)).setResponse(this.formPanel.getFieldValue(i));
                        continue;
                    }
                    LOG.severe("ERROR - PASSWORD not ResponseWidget");
                    continue;
                }
                if (widgetType == WidgetType.RADIOBOX) {
                    String radioBoxValue = this.formPanel.getFieldValue(i);
                    RadioBoxWidget radioBoxWidget = (RadioBoxWidget)((Object)widget);
                    List radioBoxWidgetList = radioBoxWidget.getWidgets();
                    this.setListWidgetValue(radioBoxWidgetList, radioBoxValue);
                    continue;
                }
                if (widgetType == WidgetType.COMBOBOX) {
                    String comboBoxValue = this.formPanel.getFieldValue(i);
                    ComboBoxWidget comboBoxWidget = (ComboBoxWidget)((Object)widget);
                    List comboBoxWidgetList = comboBoxWidget.getWidgets();
                    this.setListWidgetValue(comboBoxWidgetList, comboBoxValue);
                    continue;
                }
                if (widgetType == WidgetType.SELECT) {
                    if (widget instanceof SelectWidget) {
                        ((SelectWidget)widget).setSelected(this.formPanel.getFieldValue(i).equals("true"));
                        continue;
                    }
                    LOG.severe("ERROR - FIELD not SelectWidget");
                    continue;
                }
                if (widgetType == WidgetType.MESSAGE || widgetType == WidgetType.INFORMATION || widgetType == WidgetType.JUMP || widgetType == WidgetType.LINK || widgetType == WidgetType.TEXTICONLABEL || widgetType == WidgetType.HIDDEN || widgetType == WidgetType.HTML) continue;
                LOG.info("TODO(?) setResponse(): " + widgetType.toString());
            }
        }
    }

    private void debugResponses() {
        int numberWidgets;
        List widgetList = this.form.getWidgets();
        int n = numberWidgets = widgetList == null ? 0 : widgetList.size();
        if (widgetList != null && numberWidgets > 0) {
            LOG.finest("\n****************\nWidget - response\n");
            for (int i = 0; i < numberWidgets; ++i) {
                String theValue;
                Widget widget = (Widget)widgetList.get(i);
                if (widget instanceof ResponseWidget) {
                    String response = ((ResponseWidget)((Object)widget)).getResponse();
                    LOG.finest(widget.getText() + " - " + response);
                    continue;
                }
                if (widget instanceof RadioBoxWidget) {
                    List radioBoxWidgetList = ((RadioBoxWidget)widgetList.get(i)).getWidgets();
                    theValue = this.getListWidgetValue(radioBoxWidgetList);
                    LOG.finest(widget.getText() + " - " + theValue);
                    continue;
                }
                if (widget instanceof ComboBoxWidget) {
                    List comboBoxWidgetList = ((ComboBoxWidget)widgetList.get(i)).getWidgets();
                    theValue = this.getListWidgetValue(comboBoxWidgetList);
                    LOG.finest(widget.getText() + " - " + theValue);
                    continue;
                }
                if (widget instanceof SelectWidget) {
                    LOG.finest(widget.getText() + " - " + ((SelectWidget)widget).isSelected());
                    continue;
                }
                LOG.finest("Non-valued widget");
            }
            LOG.finest("****************\n");
        }
    }

    private ArrayList getListWidgetPopulation(List widgetList) {
        ArrayList<String> populationArrayList = new ArrayList<String>();
        if (widgetList != null) {
            Iterator widgetIterator = widgetList.iterator();
            while (widgetIterator.hasNext()) {
                Widget widget = (Widget)widgetIterator.next();
                populationArrayList.add(widget.getText());
            }
        } else {
            LOG.severe("ERROR - get population for null widget list ?");
        }
        return populationArrayList;
    }

    private void setListWidgetValue(List widgetList, String aValue) {
        if (widgetList != null) {
            Iterator widgetIterator = widgetList.iterator();
            while (widgetIterator.hasNext()) {
                SelectWidget selectWidget = (SelectWidget)widgetIterator.next();
                selectWidget.setSelected(selectWidget.getText().equals(aValue));
            }
        } else {
            LOG.severe("ERROR - set value for null widget list ?");
        }
    }

    private String getListWidgetValue(List widgetList) {
        if (widgetList != null) {
            Iterator widgetIterator = widgetList.iterator();
            while (widgetIterator.hasNext()) {
                SelectWidget selectWidget = (SelectWidget)widgetIterator.next();
                if (!selectWidget.isSelected()) continue;
                return selectWidget.getText();
            }
        } else {
            LOG.severe("ERROR - get value for null widget list ?");
        }
        return null;
    }

    public boolean isNavigationAllowed(int whichWay) {
        LOG.info("isNavigationAllowed: " + whichWay);
        if (whichWay == 2) {
            return WizardPanel.exitConfirmation(this);
        }
        if (whichWay == 0 || whichWay == 1 || whichWay == 3) {
            boolean validResponses = this.validateResponses(whichWay == 0);
            this.formPanel.layoutLabelsAndComponents();
            if (!validResponses && whichWay != 0) {
                this.getToolkit().beep();
                this.refreshMe();
                return false;
            }
            if (validResponses && whichWay != 0) {
                int continueCheckIndex = this.formPanel.getContinueCheckIndex();
                if (continueCheckIndex != -1 && !this.formPanel.getFieldValue(continueCheckIndex).equals("true") && this.remoteConfirmation()) {
                    JCheckBox remoteCheckBox = (JCheckBox)this.formPanel.getField(continueCheckIndex);
                    remoteCheckBox.doClick();
                }
                this.setResponses();
            }
        }
        this.debugResponses();
        if (whichWay == 3) {
            final GatherDialog progressDialog = new GatherDialog(this.parentDialog, null, 1, true, false);
            SwingWorker worker = new SwingWorker(){
                boolean workerDone = false;

                public Object construct() {
                    StoreTask storeTask = new StoreTask();
                    this.workerDone = true;
                    progressDialog.stop();
                    return storeTask;
                }

                public boolean isDone() {
                    return this.workerDone;
                }
            };
            worker.start();
            if (!worker.isDone()) {
                progressDialog.start();
            }
            if (this.outputResult == null || this.outputResult.getCode().equals("0")) {
                return true;
            }
            if (this.outputResult.isProxyConnectionError()) {
                int networkFormIndex = this.wizard.getFormIndex("network");
                if (networkFormIndex != -1) {
                    this.navigationProvider.navigateToIndex(networkFormIndex);
                    return false;
                }
                LOG.severe("ERROR - missing network form");
            }
            LOG.info("Form id is: " + this.form.getFormIdentifier());
            String loginFailedNextFormId = "sunAccountOne";
            if (this.form.getFormIdentifier().equalsIgnoreCase("solarisSunAccountThree")) {
                loginFailedNextFormId = "solarisSunAccountOne";
                LOG.info("loginFailedNextFormId --" + loginFailedNextFormId);
            }
            if (this.form.getFormIdentifier().equalsIgnoreCase("subscription2")) {
                loginFailedNextFormId = "subscription1";
                LOG.info("loginFailedNextFormId --" + loginFailedNextFormId);
            }
            if (this.outputResult.isAuthenticationFailedError()) {
                int nextFormIndex = this.wizard.getFormIndex(loginFailedNextFormId);
                if (nextFormIndex != -1) {
                    this.navigationProvider.navigateToIndex(nextFormIndex);
                    JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".err"), I18N.getString("error.dialog.title"), 0);
                    this.refreshMe();
                    return false;
                }
                LOG.severe("ERROR - missing form id " + loginFailedNextFormId);
            }
            if (this.outputResult.isAccountCreationFailedError()) {
                int createFormIndex;
                String createFailedNextFormId = "createAccountOne";
                if (this.form.getFormIdentifier().equalsIgnoreCase("solarisCreateAccountFour")) {
                    createFailedNextFormId = "solarisCreateAccountOne";
                    LOG.info("createFailedNextFormId --" + createFailedNextFormId);
                }
                if ((createFormIndex = this.wizard.getFormIndex(createFailedNextFormId)) != -1) {
                    this.navigationProvider.navigateToIndex(createFormIndex);
                    JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".err"), I18N.getString("error.dialog.title"), 0);
                    this.refreshMe();
                    return false;
                }
                LOG.severe("ERROR - missing form id: " + createFailedNextFormId);
            }
            if (this.outputResult.getSeverity().equalsIgnoreCase("W")) {
                JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".msg"), I18N.getString("warning.dialog.title"), 2);
            } else if (this.outputResult.getSeverity().equalsIgnoreCase("F")) {
                LOG.info("Error code is -->" + this.outputResult.getCode());
                JOptionPane.showMessageDialog(this, I18N.getString(this.outputResult.getCode() + ".err"), I18N.getString("error.dialog.title"), 0);
            }
            this.refreshMe();
            return false;
        }
        if (whichWay == 1) {
            if (this.isFormWithId("sunAccountTwo")) {
                String sendFieldValue = this.formPanel.getFieldValue("yesSubKey");
                if (sendFieldValue.equals("true")) {
                    LOG.info(" >> Setting nextid: login account three A");
                    this.form.setNextIdentifier("sunAccountThreeA");
                } else {
                    LOG.info(" >> Setting nextid: login account three B");
                    this.form.setNextIdentifier("sunAccountThreeB");
                }
            } else if (this.isFormWithId("createAccountThree")) {
                String sendFieldValue = this.formPanel.getFieldValue("yesSubKey");
                if (sendFieldValue.equals("true")) {
                    LOG.info(" >> Setting nextid: create account four A");
                    this.form.setNextIdentifier("createAccountFourA");
                } else {
                    LOG.info(" >> Setting nextid: create account four B");
                    this.form.setNextIdentifier("createAccountFourB");
                }
            }
        }
        return true;
    }

    public int getSWUPConfirmFormIndex() {
        return this.wizard.getFormIndex("SWUPConfirm");
    }

    public boolean isRemoteLocalChoiceForm() {
        return this.isFormWithId("sunAccountThreeA") || this.isFormWithId("createAccountFourA");
    }

    public boolean isRemoteLocalChoiceRemote() {
        if (!this.isRemoteLocalChoiceForm()) {
            LOG.severe("ERROR - not remote/local form");
            return false;
        }
        String selectValue = this.formPanel.getFieldValue("systemselect");
        return selectValue.equals("true");
    }

    public boolean isLocalRegistrationForm() {
        return this.isFormWithId("sunAccountThreeB") || this.isFormWithId("createAccountFourB");
    }

    public boolean isSolarisOnlyRegistrationForm() {
        return this.isFormWithId("solarisSunAccountThree") || this.isFormWithId("solarisCreateAccountFour");
    }

    public int getUMConfirmFormIndex() {
        return this.wizard.getFormIndex("UMConfirm");
    }

    private boolean isFormWithId(String formId) {
        String formIdentifier = this.form.getFormIdentifier();
        return formIdentifier.equals(formId);
    }

    private String getConfirmSystemMessage(boolean isSWUP) {
        String hostname = this.getJXTAHostname();
        if (hostname != null) {
            Object[] argObjects = new Object[]{hostname};
            return I18N.getFormattedString(isSWUP ? "swup.confirm.system.message" : "um.confirm.system.message", argObjects);
        }
        return null;
    }

    private String getJXTAHostname() {
        Widget widget = this.form.getWidgetById("jxtaHostname");
        if (widget == null) {
            LOG.warning("WARNING - no jxta hostname widget in form");
            return null;
        }
        String hostname = widget.getText();
        if (hostname == null) {
            LOG.warning("WARNING - jxta hostname widget value is null");
        }
        LOG.info(" !! JXTA Hostname: " + hostname);
        return hostname;
    }

    public static boolean exitConfirmation(Component parentComponent) {
        int confirmOption = 0;
        if (!CmdLineGlobalObject.assetRegistered) {
            String dialogTitle = I18N.getString("confirm.exit.dialog.title");
            String dialogMessage = I18N.getString("confirm.exit.dialog.message");
            String discardOption = I18N.getString("confirm.exit.dialog.discard");
            String continueOption = I18N.getString("confirm.exit.dialog.continue");
            Object[] options = new String[]{discardOption, continueOption};
            confirmOption = JOptionPane.showOptionDialog(parentComponent, Utils.makeMultiLineLabel(dialogMessage), dialogTitle, 0, 2, null, options, continueOption);
        }
        return confirmOption == 0;
    }

    private boolean remoteConfirmation() {
        String dialogTitle = I18N.getString("confirm.no.remote.dialog.title");
        String dialogMessage = I18N.getString("confirm.no.remote.dialog.message");
        String noOption = I18N.getString("confirm.no.remote.dialog.no");
        String yesOption = I18N.getString("confirm.no.remote.dialog.yes");
        Object[] options = new String[]{noOption, yesOption};
        int confirmOption = JOptionPane.showOptionDialog(this, Utils.makeMultiLineLabel(dialogMessage), dialogTitle, 0, 2, null, options, yesOption);
        return confirmOption == 1;
    }

    private void loadInformationWidget() {
        List widgetList = this.form.getWidgets();
        Widget informationWidget = (Widget)widgetList.get(this.informationWidgetIndex);
        String informationWidgetValue = informationWidget.getText();
        this.formPanel.setFieldValue(this.informationWidgetIndex, informationWidgetValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StoreTask {
        StoreTask() {
            LOG.info("StoreTask ENTER");
            LOG.info(">>>> About to output");
            WizardPanel.this.outputResult = WizardPanel.this.wizard.output(WizardPanel.this.form);
            LOG.info(">>>> output result: " + WizardPanel.this.outputResult.getText());
            LOG.info("StoreTask LEAVE");
        }
    }
}

