/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard.swing;

import com.sun.cns.basicreg.wizard.Form;
import com.sun.cns.basicreg.wizard.Wizard;
import com.sun.cns.basicreg.wizard.swing.NavigationListener;
import com.sun.cns.basicreg.wizard.swing.NavigationProvider;
import com.sun.cns.basicreg.wizard.swing.WizardFrame;
import com.sun.cns.basicreg.wizard.swing.WizardPanel;
import com.sun.cns.basicreg.wizard.util.I18N;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class WizardDialog
extends JDialog
implements NavigationProvider {
    private static final String PREVIOUS_BTN_LBL = I18N.getString("previous.btn");
    private static final String NEXT_BTN_LBL = I18N.getString("next.btn");
    private static final String EXIT_BTN_LBL = I18N.getString("exit.btn");
    private static final String DONE_BTN_LBL = I18N.getString("close.btn");
    private static final String FINISH_BTN_LBL = I18N.getString("finish.btn");
    private Wizard wizard;
    private WizardFrame ownerWizardFrame;
    private WizardPanel[] wizardPanels;
    private int currentlyShowingIndex;
    private NavigationListener navigationListener;
    private JButton previousButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton doneButton;
    private JButton exitButton;
    JPanel cardPanel;
    CardLayout cardLayout;
    private static final String WP = "wp";
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$wizard$swing$WizardDialog == null ? (class$com$sun$cns$basicreg$wizard$swing$WizardDialog = WizardDialog.class$("com.sun.cns.basicreg.wizard.swing.WizardDialog")) : class$com$sun$cns$basicreg$wizard$swing$WizardDialog).getName());
    static /* synthetic */ Class class$com$sun$cns$basicreg$wizard$swing$WizardDialog;

    public WizardDialog(Frame parentFrame, boolean isModal, WizardFrame ownerWizardFrame, Wizard wizard) {
        super((Frame)null, wizard.getTitle(), isModal);
        this.wizard = wizard;
        this.ownerWizardFrame = ownerWizardFrame;
        this.getAccessibleContext().setAccessibleDescription(wizard.getTitle());
    }

    public void buildMe(WizardPanel[] wizardPanels) {
        this.wizardPanels = wizardPanels;
        this.getContentPane().setLayout(new BorderLayout(5, 0));
        Icon brandingIcon = I18N.getIcon("update.branding.gif");
        if (this.ownerWizardFrame.isRunModeSolarisRegistration()) {
            brandingIcon = I18N.getIcon("solaris.branding.gif");
        } else if (this.ownerWizardFrame.isRunModeSolarisU1Registration()) {
            brandingIcon = I18N.getIcon("solaris.branding.gif");
        }
        ImageCanvas imageCanvas = new ImageCanvas((ImageIcon)brandingIcon);
        imageCanvas.getAccessibleContext().setAccessibleName("Brand Icon");
        imageCanvas.getAccessibleContext().setAccessibleDescription("Brand Icon");
        this.getContentPane().add((Component)imageCanvas, "West");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        for (int i = 0; i < wizardPanels.length; ++i) {
            this.cardPanel.add((Component)wizardPanels[i], WP + i);
        }
        rightPanel.add((Component)this.cardPanel, "Center");
        this.getContentPane().add((Component)rightPanel, "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(brandingIcon != null ? brandingIcon.getIconWidth() : 100), "South");
        this.pack();
        Dimension screenDimension = this.getToolkit().getScreenSize();
        if (this.ownerWizardFrame.isRunModeSolarisRegistration()) {
            this.setSize(screenDimension);
        } else {
            Rectangle boundsRectangle = this.getBounds();
            this.setLocation((screenDimension.width - boundsRectangle.width) / 2, (screenDimension.height - boundsRectangle.height) / 2);
        }
    }

    public void showPanel(int index) {
        this.redoButtonPanel(this.wizardPanels[index].getForm());
        this.navigationListener = this.wizardPanels[index];
        this.cardLayout.show(this.cardPanel, WP + index);
        this.wizardPanels[index].setInitialFocus();
        this.currentlyShowingIndex = index;
    }

    private JPanel buildButtonPanel(int leftSpacing) {
        JPanel returnPanel = new JPanel();
        returnPanel.setLayout(new BoxLayout(returnPanel, 1));
        JSeparator separator = new JSeparator();
        separator.setAlignmentX(0.0f);
        returnPanel.add(separator);
        returnPanel.add(Box.createVerticalStrut(12));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalStrut(leftSpacing));
        this.previousButton = new JButton(PREVIOUS_BTN_LBL);
        this.previousButton.addActionListener(new PreviousButtonActionListener());
        this.previousButton.setAlignmentY(0.5f);
        this.previousButton.getAccessibleContext().setAccessibleName(PREVIOUS_BTN_LBL);
        this.previousButton.getAccessibleContext().setAccessibleDescription("Click this button to the previous page");
        this.previousButton.setMnemonic(80);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        this.nextButton = new JButton(NEXT_BTN_LBL);
        this.nextButton.addActionListener(new NextButtonActionListener());
        this.nextButton.setAlignmentY(0.5f);
        this.nextButton.getAccessibleContext().setAccessibleName(NEXT_BTN_LBL);
        this.nextButton.getAccessibleContext().setAccessibleDescription("Click this button to the next page");
        this.nextButton.setMnemonic(78);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.finishButton = new JButton(FINISH_BTN_LBL);
        this.finishButton.addActionListener(new FinishButtonActionListener());
        this.finishButton.setAlignmentY(0.5f);
        this.finishButton.getAccessibleContext().setAccessibleName(FINISH_BTN_LBL);
        this.finishButton.getAccessibleContext().setAccessibleDescription("Click this button to finish");
        this.finishButton.setMnemonic(70);
        buttonPanel.add(this.finishButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.doneButton = new JButton(DONE_BTN_LBL);
        this.doneButton.addActionListener(new DoneButtonActionListener());
        this.doneButton.setAlignmentY(0.5f);
        this.doneButton.getAccessibleContext().setAccessibleName(DONE_BTN_LBL);
        this.doneButton.getAccessibleContext().setAccessibleDescription(DONE_BTN_LBL);
        this.doneButton.setMnemonic(67);
        buttonPanel.add(this.doneButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.exitButton = new JButton(EXIT_BTN_LBL);
        this.exitButton.addActionListener(new ExitButtonActionListener());
        this.exitButton.setAlignmentY(0.5f);
        this.exitButton.getAccessibleContext().setAccessibleName(EXIT_BTN_LBL);
        this.exitButton.getAccessibleContext().setAccessibleDescription(EXIT_BTN_LBL);
        this.exitButton.setMnemonic(69);
        buttonPanel.add(this.exitButton);
        buttonPanel.add(Box.createHorizontalStrut(12));
        buttonPanel.add(Box.createVerticalStrut(this.exitButton.getPreferredSize().height));
        buttonPanel.setAlignmentX(0.0f);
        returnPanel.add(buttonPanel);
        returnPanel.add(Box.createVerticalStrut(12));
        return returnPanel;
    }

    private void redoButtonPanel(Form form) {
        if (!form.isNavigator()) {
            this.previousButton.setVisible(false);
            this.nextButton.setVisible(false);
            this.finishButton.setVisible(false);
            this.exitButton.setVisible(false);
            this.doneButton.setVisible(form.isConfirm());
            return;
        }
        this.previousButton.setVisible(!form.isStart());
        this.nextButton.setVisible(!form.isFinish());
        this.finishButton.setVisible(form.isFinish());
        this.exitButton.setVisible(true);
        this.doneButton.setVisible(false);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            if (WizardPanel.exitConfirmation(this)) {
                this.closeWizard();
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public void refreshMe() {
        this.validate();
        this.repaint();
    }

    private boolean okByNavigationListener(int whichWay) {
        if (this.navigationListener == null) {
            LOG.severe("ERROR - no navigation listener");
            return false;
        }
        return this.navigationListener.isNavigationAllowed(whichWay);
    }

    public void navigateToIndex(int index) {
        LOG.info("navigate to dialog at index: " + index);
        this.ownerWizardFrame.showIndexedWizardDialog(index);
    }

    public void setNavigationListener(NavigationListener navigationListener) {
        LOG.finest("set navigation listener");
        this.navigationListener = navigationListener;
    }

    public void closeWizard() {
        LOG.info("  ^^^^  CLOSING WIZARD");
        this.ownerWizardFrame.wizardCompleted();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ImageCanvas
    extends Canvas {
        private Image image;

        ImageCanvas(ImageIcon imageIcon) {
            this.image = imageIcon.getImage();
            this.setBounds(0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight());
        }

        public void paint(Graphics graphics) {
            LOG.finest("ImageCanvas size: " + this.getSize().width + ", " + this.getSize().height);
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this.getSize().width, this.getSize().height, this);
            } else {
                graphics.drawString("        ", 0, 0);
            }
        }
    }

    class FinishButtonActionListener
    implements ActionListener {
        FinishButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  FINISH BUTTON");
            if (WizardDialog.this.okByNavigationListener(3)) {
                WizardPanel wizardPanel = WizardDialog.this.wizardPanels[WizardDialog.this.currentlyShowingIndex];
                if (wizardPanel.isLocalRegistrationForm()) {
                    WizardDialog.this.navigateToIndex(wizardPanel.getUMConfirmFormIndex());
                    return;
                }
                if (wizardPanel.isSolarisOnlyRegistrationForm()) {
                    WizardDialog.this.navigateToIndex(wizardPanel.getUMConfirmFormIndex());
                    return;
                }
                if (wizardPanel.isRemoteLocalChoiceForm()) {
                    if (wizardPanel.isRemoteLocalChoiceRemote()) {
                        WizardDialog.this.navigateToIndex(wizardPanel.getSWUPConfirmFormIndex());
                    } else {
                        WizardDialog.this.navigateToIndex(wizardPanel.getUMConfirmFormIndex());
                    }
                    return;
                }
                WizardDialog.this.closeWizard();
            }
        }
    }

    class DoneButtonActionListener
    implements ActionListener {
        DoneButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  DONE BUTTON on confirm dialog");
            WizardDialog.this.closeWizard();
        }
    }

    class ExitButtonActionListener
    implements ActionListener {
        ExitButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("  ++++  CANCEL BUTTON");
            if (WizardDialog.this.okByNavigationListener(2)) {
                WizardDialog.this.closeWizard();
            }
        }
    }

    class NextButtonActionListener
    implements ActionListener {
        NextButtonActionListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("go to next dialog");
            if (!WizardDialog.this.okByNavigationListener(1)) return;
            Form form = WizardDialog.this.wizardPanels[WizardDialog.this.currentlyShowingIndex].getForm();
            String nextId = form.getNextIdentifier();
            if (nextId != null && nextId.equals("$FID:DO_EXIT")) {
                if (!WizardPanel.exitConfirmation(WizardDialog.this)) return;
                WizardDialog.this.closeWizard();
                return;
            } else {
                int nextIndex = nextId != null ? WizardDialog.this.wizard.getFormIndex(nextId) : WizardDialog.this.currentlyShowingIndex + 1;
                WizardDialog.this.navigateToIndex(nextIndex);
            }
        }
    }

    class PreviousButtonActionListener
    implements ActionListener {
        PreviousButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info("go to previous dialog");
            if (WizardDialog.this.okByNavigationListener(0)) {
                Form form = WizardDialog.this.wizardPanels[WizardDialog.this.currentlyShowingIndex].getForm();
                String backId = form.getBackIdentifier();
                int backIndex = backId != null ? WizardDialog.this.wizard.getFormIndex(backId) : WizardDialog.this.currentlyShowingIndex - 1;
                WizardDialog.this.navigateToIndex(backIndex);
            }
        }
    }
}

