/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.wizard;

import com.sun.cns.basicreg.wizard.util.Country;
import com.sun.cns.basicreg.wizard.util.I18N;
import com.sun.cns.basicreg.wizard.util.Language;
import com.sun.cns.basicreg.wizard.util.Message;
import com.sun.cns.basicreg.wizard.util.State;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Collector {
    private static final String I18N_LANGUAGE_ORDER_KEY = "_i18n.language.order";
    private static final String I18N_COUNTRY_ORDER_KEY = "_i18n.country.order";
    private static Collector instance = null;
    ArrayList countries = new ArrayList();
    ArrayList states = new ArrayList();
    ArrayList languages = new ArrayList();
    ArrayList messages = new ArrayList();
    private String identifier;
    private String languageOrder = null;
    private String countryOrder = null;

    public static Collector getInstance() {
        if (instance == null) {
            instance = new Collector();
        }
        return instance;
    }

    public Collector() {
    }

    public Collector(String identifier) {
        this.identifier = identifier;
    }

    public List getCountries() {
        this.identifier = "wizards/country.xml";
        this.countryOrder = I18N.getCountryValueString(I18N_COUNTRY_ORDER_KEY, null);
        this.countries.clear();
        return this.getElements(this.identifier, "country");
    }

    public List getStates() {
        this.identifier = "wizards/state.xml";
        this.states.clear();
        return this.getElements(this.identifier, "state");
    }

    public List getLanguages() {
        this.identifier = "wizards/language.xml";
        this.languageOrder = I18N.getLanguageValueString(I18N_LANGUAGE_ORDER_KEY, null);
        this.languages.clear();
        return this.getElements(this.identifier, "language");
    }

    public List getMessages() {
        this.identifier = "wizards/message.xml";
        return this.getElements(this.identifier, "message");
    }

    private List getElements(String identifier, String type) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(identifier);
        SAXBuilder builder = new SAXBuilder();
        Document document = null;
        try {
            document = builder.build(inputStream);
        }
        catch (JDOMException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        if (document != null) {
            Element rootElm = document.getRootElement();
            List elms = rootElm.getChildren(type);
            Iterator i = elms.iterator();
            while (i.hasNext()) {
                if (type.equalsIgnoreCase("message")) {
                    this.messages.add(this.createMessage((Element)i.next()));
                    continue;
                }
                if (type.equalsIgnoreCase("state")) {
                    this.states.add(this.createState((Element)i.next()));
                    continue;
                }
                if (type.equalsIgnoreCase("country")) {
                    this.countries.add(this.createCountry((Element)i.next()));
                    continue;
                }
                if (!type.equalsIgnoreCase("language")) continue;
                this.languages.add(this.createLanguage((Element)i.next()));
            }
        }
        if (type.equalsIgnoreCase("message")) {
            return this.messages;
        }
        if (type.equalsIgnoreCase("state")) {
            return this.states;
        }
        if (type.equalsIgnoreCase("country")) {
            if (this.countries != null && this.countryOrder != null) {
                Country[] countryArray = this.countries.toArray(new Country[0]);
                Arrays.sort(countryArray, new CountryComparator());
                return new ArrayList<Country>(Arrays.asList(countryArray));
            }
            return this.countries;
        }
        if (type.equalsIgnoreCase("language")) {
            if (this.languages != null && this.languageOrder != null) {
                Language[] languageArray = this.languages.toArray(new Language[0]);
                Arrays.sort(languageArray, new LanguageComparator());
                return new ArrayList<Language>(Arrays.asList(languageArray));
            }
            return this.languages;
        }
        return null;
    }

    public List getStates(String country) {
        Iterator i = this.countries.iterator();
        while (i.hasNext()) {
            if (!((Country)i.next()).getName().equalsIgnoreCase(country)) continue;
            return ((Country)i.next()).getStates();
        }
        return null;
    }

    private Country createCountry(Element element) {
        Country result = new Country(I18N.getCountryValueString(element.getAttributeValue("name").replaceAll(" ", "."), element.getAttributeValue("name")), element.getAttributeValue("code"));
        List stateElms = element.getChildren("state");
        Iterator i = stateElms.iterator();
        while (i.hasNext()) {
            result.addState(this.createState((Element)i.next()));
        }
        return result;
    }

    private State createState(Element element) {
        State result = new State(element.getText(), element.getAttributeValue("code"));
        return result;
    }

    private Language createLanguage(Element element) {
        Language result = new Language(I18N.getLanguageValueString(element.getText().replaceAll(" ", "."), element.getText()), element.getAttributeValue("code"));
        return result;
    }

    private Message createMessage(Element element) {
        Message result = new Message(element.getText(), element.getAttributeValue("code"));
        return result;
    }

    class CountryComparator
    implements Comparator {
        CountryComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (Collector.this.countryOrder == null || obj1 == null || obj2 == null) {
                return 0;
            }
            String lowerCountryOrder = Collector.this.countryOrder.toLowerCase();
            String lowerCountryCode1 = ((Country)obj1).getCode().toLowerCase();
            String lowerCountryCode2 = ((Country)obj2).getCode().toLowerCase();
            int countryCode1Index = lowerCountryOrder.indexOf(lowerCountryCode1);
            int countryCode2Index = lowerCountryOrder.indexOf(lowerCountryCode2);
            return countryCode1Index - countryCode2Index;
        }
    }

    class LanguageComparator
    implements Comparator {
        LanguageComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (Collector.this.languageOrder == null || obj1 == null || obj2 == null) {
                return 0;
            }
            String lowerLanguageOrder = Collector.this.languageOrder.toLowerCase();
            String lowerLangCode1 = ((Language)obj1).getCode().toLowerCase();
            String lowerLangCode2 = ((Language)obj2).getCode().toLowerCase();
            int langCode1Index = lowerLanguageOrder.indexOf(lowerLangCode1);
            int langCode2Index = lowerLanguageOrder.indexOf(lowerLangCode2);
            return langCode1Index - langCode2Index;
        }
    }
}

