/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InstallationParameters;
import com.sun.patchpro.util.NumberOutOfRangeException;
import com.sun.patchpro.util.Schedule;
import com.sun.patchpro.util.ScheduleService;
import com.sun.patchpro.util.SunOSSchedule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SunOSScheduleService
implements ScheduleService {
    protected static String GETSCHEDULESCMD = "/usr/bin/crontab -l";
    private static final String CANNOTCLEARJOB = "Cannot clear scheduled job.";
    private static final String COMMANDFILEPREFIX = "pprosched";
    private static final String COMMANDFILESUFFIX = "";
    private File commandDirFile;
    private InstallationParameters instParms = null;
    protected static boolean inTest = false;
    private PatchProProperties properties = PatchProProperties.getInstance();
    private PatchProLog log = PatchProLog.getInstance();
    private String command = "";
    private String scheduleCommandPath;
    private String schedScript;

    public SunOSScheduleService() {
        this.instParms = InstallationParameters.getInstance();
        inTest = this.properties.getProperty("patchpro.debug").compareTo("true") == 0;
        this.schedScript = this.properties.getProperty("patchpro.command.schedule.script");
        String string = this.instParms.getLibraryDirectoryPath();
        this.scheduleCommandPath = string + File.separator + this.schedScript;
        this.commandDirFile = new File(string);
        if (inTest) {
            System.out.println("SunOSScheduleService: installDirectory = " + this.instParms.getLibraryDirectoryPath());
            System.out.println("SunOSScheduleService: schedScript = " + this.schedScript);
        }
    }

    public Enumeration getSchedules() throws IOException {
        String string;
        Process process = Runtime.getRuntime().exec(GETSCHEDULESCMD);
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Vector<SunOSSchedule> vector = new Vector<SunOSSchedule>();
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            try {
                SunOSSchedule sunOSSchedule = new SunOSSchedule(string);
                if (!sunOSSchedule.isComplete()) continue;
                vector.add(sunOSSchedule);
            }
            catch (NumberOutOfRangeException numberOutOfRangeException) {
                this.log.println(this, 4, "Crontab line " + n + " contains an out-of-range number");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println(this, 4, "Crontab line " + n + " is corrupt");
            }
        }
        inputStream.close();
        inputStream2.close();
        return vector.elements();
    }

    public Enumeration getSchedules(String string) throws IOException {
        String string2;
        Process process = Runtime.getRuntime().exec(GETSCHEDULESCMD);
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Vector<SunOSSchedule> vector = new Vector<SunOSSchedule>();
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            ++n;
            try {
                SunOSSchedule sunOSSchedule = new SunOSSchedule(string2);
                if (!sunOSSchedule.isComplete() || sunOSSchedule.getCommand().indexOf(string) < 0) continue;
                vector.add(sunOSSchedule);
            }
            catch (NumberOutOfRangeException numberOutOfRangeException) {
                this.log.println(this, 4, "Crontab line " + n + " contains an out-of-range number");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println(this, 4, "Crontab line " + n + " is corrupt");
            }
        }
        inputStream.close();
        inputStream2.close();
        return vector.elements();
    }

    public void add(Schedule schedule) throws IOException, IllegalArgumentException {
        this.execute((SunOSSchedule)schedule);
    }

    public void daily(String string, String string2) {
        SunOSSchedule sunOSSchedule = new SunOSSchedule();
        this.command = string;
        sunOSSchedule.setCommand(string);
        try {
            sunOSSchedule.setFrequency(2);
            this.setTime(string2, sunOSSchedule);
            this.add(sunOSSchedule);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void weekly(String string, String string2, String string3) {
        SunOSSchedule sunOSSchedule = new SunOSSchedule();
        this.command = string;
        sunOSSchedule.setCommand(string);
        try {
            sunOSSchedule.setFrequency(3);
            sunOSSchedule.setDayOfWeek(Integer.parseInt(string3));
            this.setTime(string2, sunOSSchedule);
            this.add(sunOSSchedule);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void monthly(String string, String string2, String string3) {
        SunOSSchedule sunOSSchedule = new SunOSSchedule();
        this.command = string;
        sunOSSchedule.setCommand(string);
        try {
            sunOSSchedule.setFrequency(4);
            sunOSSchedule.setDayOfMonth(Integer.parseInt(string3));
            this.setTime(string2, sunOSSchedule);
            this.add(sunOSSchedule);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void begin(String string, String string2) {
        SunOSSchedule sunOSSchedule = new SunOSSchedule();
        this.command = string;
        sunOSSchedule.setCommand(string);
        try {
            sunOSSchedule.setFrequency(1);
            this.setTime(string2, sunOSSchedule);
            this.add(sunOSSchedule);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public void clear(Schedule schedule) throws IOException {
        this.command = schedule.getCommand();
        try {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            String[] stringArray = new String[]{this.scheduleCommandPath, " -r ", "\"" + this.command + "\""};
            if (inTest) {
                System.out.println("executing " + stringArray[0] + stringArray[1] + stringArray[2]);
            } else {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(stringArray);
                inputStream = process.getInputStream();
                inputStream2 = process.getErrorStream();
                process.waitFor();
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Could not clear job containing \"" + this.command + "\"");
            throw new IOException(CANNOTCLEARJOB);
        }
    }

    public void clear(String string) throws IOException {
        this.command = string;
        try {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            String string2 = this.scheduleCommandPath + " -r " + string;
            if (inTest) {
                System.out.println("executing " + string2);
            } else {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(string2);
                inputStream = process.getInputStream();
                inputStream2 = process.getErrorStream();
                process.waitFor();
                if (inputStream != null) {
                    inputStream.close();
                }
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Could not clear job containing \"" + string + "\"");
            throw new IOException(CANNOTCLEARJOB);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(SunOSSchedule sunOSSchedule) throws IOException, IllegalArgumentException {
        Object object;
        Object object2;
        String string = sunOSSchedule.getCrontabEntry();
        String string2 = COMMANDFILESUFFIX;
        File file = File.createTempFile(COMMANDFILEPREFIX, COMMANDFILESUFFIX, this.commandDirFile);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println(string);
        file.deleteOnExit();
        if (sunOSSchedule.getFrequency() == 1) {
            object2 = sunOSSchedule.cloneSunOSSchedule();
            object = sunOSSchedule.getCommand();
            ((Schedule)object2).setCommand(this.scheduleCommandPath + " -r " + (String)object);
            string2 = ((SunOSSchedule)object2).getCrontabEntry();
            printStream.println(string2);
        }
        printStream.close();
        object2 = this.scheduleCommandPath + " " + file.getPath();
        if (inTest) {
            System.out.println("stored    " + string);
            System.out.println("   and    " + string2);
            System.out.println("executing " + (String)object2);
        } else {
            object = Runtime.getRuntime().exec((String)object2);
            try {
                ((Process)object).waitFor();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("Crontab edit was interrupted.");
            }
            if (((Process)object).exitValue() != 0) {
                throw new IOException("Failed to process crontab");
            }
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            this.log.println(this, 7, "Exception thrown trying to delete \"" + file.getPath() + "\"");
        }
        finally {
            if (file.exists()) {
                Process process = Runtime.getRuntime().exec("/usr/bin/rm " + file.getPath());
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    this.log.println(this, 7, "Could not rm \"" + file.getPath() + "\"");
                }
            }
        }
    }

    protected void setTime(String string, Schedule schedule) throws Exception {
        if (string.indexOf(":") == -1 || string.indexOf(":") != string.lastIndexOf(":")) {
            throw new Exception("Start time format is incorrect");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        schedule.setHour(Integer.parseInt(stringTokenizer.nextToken()));
        schedule.setMinute(Integer.parseInt(stringTokenizer.nextToken()));
    }
}

