/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.database.PatchDB;
import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.interpreter.HostSpecificInterpreter;
import com.sun.patchpro.interpreter.ParseError;
import com.sun.patchpro.log.ApplicationLog;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.manipulators.CannotDeferException;
import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installable;
import com.sun.patchpro.manipulators.InstallerEvent;
import com.sun.patchpro.manipulators.Manipulable;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.ManipulatorEvent;
import com.sun.patchpro.manipulators.ManipulatorListener;
import com.sun.patchpro.manipulators.NoManipulatorException;
import com.sun.patchpro.manipulators.NoSuchImageException;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.RemoverEvent;
import com.sun.patchpro.manipulators.VerifierEvent;
import com.sun.patchpro.model.BackoutDirectoryAccessException;
import com.sun.patchpro.model.CancelManager;
import com.sun.patchpro.model.DuplicatePatchException;
import com.sun.patchpro.model.InstallPatchEvent;
import com.sun.patchpro.model.InstallPatchListener;
import com.sun.patchpro.model.InsufficientFileSystemSpaceException;
import com.sun.patchpro.model.InvalidPatchSourceDirectoryException;
import com.sun.patchpro.model.InvalidPatchTypeException;
import com.sun.patchpro.model.NonRootUserException;
import com.sun.patchpro.model.PatchBundlesExtractionException;
import com.sun.patchpro.model.PatchDependenciesException;
import com.sun.patchpro.model.PatchInstallException;
import com.sun.patchpro.model.PatchIsRiskyException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.SequesterDirectoryAccessException;
import com.sun.patchpro.model.SunOSPkgaddAccessException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.MissingPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.util.CannotReservePatchException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.SunOSTarFileHandler;
import com.sun.patchpro.util.TarFileHandlerFailedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class PatchBundleInstaller
implements ManipulatorListener {
    static final String SEQUESTER_DIR_NOT_WRITABLE = "Sequester directory is not writable.";
    static final String BACKOUT_DIR_NOT_WRITABLE = "Backout directory is not writable.";
    static final String EMPTY_PATCH_LIST = "Empty patch list.";
    static final String EMPTY_PATCH_BUNDLE = "Empty patch bundle was detected.";
    public static final String FAIL_TO_INSTALL = "Failed to install a patch.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s) for:";
    static final String INTERNAL_SYSTEM_DATA_NOT_VALID = "Internal system data is not valid.";
    static final String INVALID_ARGUMENT_LIST = "Invalid argument list.";
    static final String INVALID_HOST = "Invalid host.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Specified filename for the patch bundle is invalid.";
    static final String INVALID_PATCH_TYPE = "Cannot determine patch type.";
    static final String NO_INSTALL_ALLOWED = "Policy does not allow installation of patches.";
    public static final String NON_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String DEFERRED_INSTALLABLE_PATCH_TYPE = "Patch type not installable in this case.";
    public static final String PATCH_REQT_NOT_MET = "Patch requirement for this patch is not met. ";
    static final String PATCH_NOT_SELECTED = "The patch is not selected.";
    static final String PATCH_SOURCE_DIR_NOT_VALID = "Invalid patch source directory.";
    static final String REQUIRED_PATCH_REVOKED = "Required patch has been revoked. ";
    static final String PROBLEM_EXTRACTING_PATCHES = "Problem extracting patches from patch bundles.";
    static final String RISKY_PATCH = "Recognized a discontinued, obsolete or point patch.";
    public static final String PATCHADD_PATCH_ALREADY_APPLIED = "Patch is already present.";
    public static final String PATCHADD_NON_ROOT_UID = "Not allowed to apply patches as non-root user.";
    public static final String PATCHADD_PKGADD_NOT_FOUND = "Not able to access /usr/sbin/pkgadd.";
    public static final String PATCHADD_NOT_ENOUGH_SPACE = "Not enough file system space for patch installation.";
    public static final String PROBLEM_INSTALLING_PATCH = "Problem installing patch.";
    public static final String NO_SEQUESTER_SPECIFIED = "No sequester directory has been specified.";
    public static final String DISALLOWED_PATCHES_FILE = "disallowed_patch_list";
    private Vector disallowedPatches;
    private Vector oblist;
    private PatchDB patchdb;
    private PatchPro model;
    boolean thisPatchInstallDone = false;
    boolean thisPatchInstallFailed = false;
    boolean internalStatus = false;
    boolean debug = false;
    boolean installAuthenticate = true;
    int numberOfPatchesToInstall = 0;
    int numberOfPatchesProcessed = 0;
    boolean bundleFailed = false;
    File sourceDirectory;
    File backoutDirectory;
    File sequesterDirectory;
    LocalizedMessages msgcat;
    PatchListImpl installedList;
    PatchListImpl sequesteredList;
    PatchListImpl deferredList;
    PatchListImpl failedInstallList;
    PatchListImpl unexpectedPropertyList;
    PatchListImpl uninstalledList = new PatchListImpl();
    PatchProLog log;
    PatchProProperties properties = PatchProProperties.getInstance();
    SignatureValidationUtil validationUtility = null;
    Vector listeners;
    Collection exceptionRepository;
    SessionData sessionData;
    private boolean warnedNoInstall = false;

    public PatchBundleInstaller() throws Exception {
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        this.log = PatchProLog.getInstance();
        try {
            this.log.setLogger(ApplicationLog.getInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").compareTo("true") == 0;
        this.installAuthenticate = this.properties.getProperty("patchpro.patch.install.authenticate", "true").equals("true");
        this.listeners = new Vector();
        if (this.properties.installAuthenticationRequired()) {
            try {
                this.validationUtility = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtility);
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noKeystorePresentException.getMessage(), "patchpro.security.kslocation is not defined or file does not exist.")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noKeystorePresentException.getMessage()));
            }
            catch (NoSigningCertException noSigningCertException) {
                this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage(noSigningCertException.getMessage(), "Failed to create the signature validation utility")));
                this.log.println(this, 3, PatchProLog.createMessage(3, noSigningCertException.getMessage() + ":" + noSigningCertException.getSigningCertAlias()));
            }
        }
    }

    protected void initialize(Host host) {
        this.sessionData = host.getSessionData();
        this.exceptionRepository = this.sessionData.getPatchProExceptions();
        this.patchdb = this.sessionData.getPatchDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(installPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InstallPatchListener installPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(installPatchListener);
        }
    }

    public PatchList install(Host host, PatchList patchList, File file, File file2, PatchPro patchPro) {
        return this.install(host, null, patchList, file, file2, patchPro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchList install(Host host, Host host2, PatchList patchList, File file, File file2, PatchPro patchPro) {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        this.model = patchPro;
        Enumeration enumeration = null;
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent();
            this.log.println(this, 4, EMPTY_PATCH_LIST);
            return patchList;
        }
        if (file == null || !file.exists()) {
            this.handleProblem(true, new InvalidPatchSourceDirectoryException("InvalidPatchSourceDirectoryException", "InvalidPatchSourceDirectoryException.MESSAGE", "InvalidPatchSourceDirectoryException.REMEDY", 2), "PatchBundleInstaller.PATCH_SOURCE_DIR_NOT_VALID", PATCH_SOURCE_DIR_NOT_VALID);
            return patchList;
        }
        this.sourceDirectory = file;
        if (host == null) {
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("PatchBundleInstaller.INVALID_HOST", INVALID_HOST)));
            this.log.println(this, 3, INVALID_HOST);
            return patchList;
        }
        this.backoutDirectory = file2;
        if (file2 != null) {
            if (!file2.exists()) {
                file2.mkdirs();
            } else if (!file2.isDirectory() || !file2.canWrite()) {
                this.handleProblem(true, new BackoutDirectoryAccessException("BackoutDirectoryAccessException", "BackoutDirectoryAccessException.MESSAGE", "BackoutDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.BACKOUT_DIR_NOT_WRITABLE", BACKOUT_DIR_NOT_WRITABLE);
                return patchList;
            }
        }
        File file3 = this.sequesterDirectory = this.sequesterDirectory == null ? new File(this.properties.getProperty("patchpro.patch.sequester.directory")) : this.sequesterDirectory;
        if (this.sequesterDirectory == null) {
            this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.NO_SEQUESTER_SPECIFIED", NO_SEQUESTER_SPECIFIED);
            return patchList;
        }
        if (!this.sequesterDirectory.exists()) {
            this.sequesterDirectory.mkdirs();
        } else if (!this.sequesterDirectory.isDirectory() || !this.sequesterDirectory.canWrite()) {
            this.handleProblem(true, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.SEQUESTER_DIR_NOT_WRITABLE", SEQUESTER_DIR_NOT_WRITABLE);
            return patchList;
        }
        HostSpecificInterpreter hostSpecificInterpreter = this.sessionData.getInterpreter();
        if (!this.properties.installIsAllowed(patchPro.isInteractive())) {
            object7 = "PatchBundleInstaller.NO_INSTALL_ALLOWED";
            String string3 = "InvalidPatchTypeException.MESSAGE";
            boolean bl = true;
            if (patchPro.isInteractive()) {
                object6 = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
            } else {
                object6 = "InvalidPatchTypeException.REMEDY";
                bl = false;
            }
            this.handleProblem(bl, new InvalidPatchTypeException("InvalidPatchTypeException", string3, (String)object6, 4), (String)object7, NO_INSTALL_ALLOWED);
            this.warnedNoInstall = true;
        }
        object7 = patchList;
        this.numberOfPatchesToInstall = object7.size();
        if (this.numberOfPatchesToInstall <= 0) {
            this.handleProblem(true, new PatchBundlesExtractionException("PatchBundlesExtractionException", "PatchBundlesExtractionException.MESSAGE", "PatchBundlesExtractionException.REMEDY", 2), "PatchBundleInstaller.EMPTY_PATH_LIST", "numberOfPatchesToInstall (" + this.numberOfPatchesToInstall + ") <= 0");
            return patchList;
        }
        this.log.println(this, 7, "Number of patches to install: " + this.numberOfPatchesToInstall);
        object6 = null;
        Object var13_13 = null;
        PatchInfo patchInfo = null;
        PatchProperties patchProperties = null;
        Enumeration enumeration2 = null;
        Enumeration enumeration3 = null;
        Realization realization = null;
        this.disallowedPatches = new Vector();
        CancelManager cancelManager = CancelManager.getInstance();
        PatchList patchList2 = null;
        for (int i = 0; i < this.numberOfPatchesToInstall; ++i) {
            boolean bl;
            try {
                Vector<HardwareComponent> vector = null;
                vector = new Vector<HardwareComponent>();
                object6 = object7.getPatchAt(i);
                enumeration2 = object7.getIPatchAt(i).getRealizations();
                while (enumeration2.hasMoreElements()) {
                    realization = (Realization)enumeration2.nextElement();
                    enumeration3 = realization.getHardwareComponents();
                    while (enumeration3.hasMoreElements()) {
                        vector.addElement((HardwareComponent)enumeration3.nextElement());
                    }
                }
                enumeration = vector.size() == 0 ? null : vector.elements();
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
                continue;
            }
            this.log.println(this, 7, "Dealing with patch: " + object6.getPatchID().getPatchID());
            if (this.debug) {
                System.out.println("Check patch requirements for patch " + object6.getPatchID().getPatchID());
            }
            try {
                bl = this.checkPatchDependencies(hostSpecificInterpreter, (Patch)object6);
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 3, exception);
                if (this.internalStatus) {
                    System.out.println("STATUS INSTALL BEGIN " + object6.getPatchID().getPatchID());
                    System.out.println("STATUS INSTALL END " + object6.getPatchID().getPatchID() + " " + "INSTALL.255" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_GENERIC_ERROR", "Utility used to install the update failed with exit code {0}. {1}") + "\" \"" + 999 + "\" \"" + this.msgcat.getMessage("PatchBundleInstaller.PATCH_CHECK_DEPENDENCY_ERROR", "Problems detected checking install requirements for update. Please refer to log file for additional information.") + "\"");
                }
                System.err.println("Problem detected checking dependencies for patch \"" + object6.getPatchID().getPatchID() + "\". Refer to log file for additional information.");
                System.err.println("Error: " + exception.getMessage());
                ++this.numberOfPatchesProcessed;
                continue;
            }
            if (!bl) {
                this.uninstalledList.addIPatch((IPatch)object6);
                object5 = null;
                try {
                    object5 = new Manipulator((Patch)object6, host, null, this.validationUtility);
                    ((Manipulator)object5).sequester();
                    this.sessionData.addToPatchList(10, (Patch)object6, this.msgcat.getMessage("PatchBundleInstaller.PATCH_REQT_NOT_MET", new String[]{object6.getPatchID().getPatchID()}, "The patch " + object6.getPatchID().getPatchID() + " requires a patch that could not be installed" + " or was deferred for later installation."));
                }
                catch (NoSuchImageException noSuchImageException) {
                    this.log.println(this, 3, "Image for patch " + object6.getPatchID().getPatchID() + " could not be found.");
                    this.log.printStackTrace(this, 2, noSuchImageException);
                    continue;
                }
                catch (IOException iOException) {
                    this.log.println(this, 3, "Error detected transferring patch " + object6.getPatchID().getPatchID() + " to the sequestered directory.");
                    this.log.printStackTrace(this, 2, iOException);
                    continue;
                }
                this.disallowedPatches.addElement(object6.getPatchID().getPatchID());
                if (this.internalStatus) {
                    System.out.println("STATUS INSTALL BEGIN " + object6.getPatchID().getPatchID());
                    System.out.println("STATUS INSTALL END " + object6.getPatchID().getPatchID() + " " + "INSTALL.254" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_PENDING", "Update {0} will be installed at next system shutdown.") + "\" \"" + object6.getPatchID().getPatchID() + "\"");
                }
                this.handleProblem((Manipulable)object5, false, 10, new PatchDependenciesException("PatchDependenciesException", "PatchDependenciesException.MESSAGE", "PatchDependenciesException.REMEDY", 5), "PatchBundleInstaller.PATCH_REQT_NOT_MET", "Patch requirement for this patch is not met.  " + object6.getPatchID().getPatchID());
                ++this.numberOfPatchesProcessed;
            } else {
                patchInfo = object6.getPatchInfo();
                patchProperties = patchInfo.getProperties();
                object4 = object6.getPatchContents();
                try {
                    object5 = ((PatchContents)object4).getManipulator(this.sourceDirectory, host, host2, enumeration, this.validationUtility);
                    switch (object5.getStrategy(patchPro.isInteractive())) {
                        case 1: {
                            try {
                                if (!object6.lock()) {
                                    throw new CannotReservePatchException("Unable to reserve patch " + object6.getPatchID().getPatchID() + "for the install process.");
                                }
                                this.installPatch((Manipulable)object5);
                                break;
                            }
                            catch (InstallFailedException installFailedException) {
                                this.uninstalledList.addIPatch((IPatch)object6);
                                this.handleProblem((Manipulable)object5, true, 8, new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 4), "PatchBundleInstaller.FAIL_TO_INSTALL", object6.getPatchID().getPatchID() + ": " + PROBLEM_INSTALLING_PATCH);
                                break;
                            }
                            catch (CannotReservePatchException cannotReservePatchException) {
                                this.log.println(this, 3, "Unable to reserve patch " + object6.getPatchID().getPatchID() + "for the install process.");
                                this.uninstalledList.addIPatch((IPatch)object6);
                                this.handleProblem((Manipulable)object5, true, 8, new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 4), "PatchBundleInstaller.FAIL_TO_INSTALL", object6.getPatchID().getPatchID() + ": " + PROBLEM_INSTALLING_PATCH);
                                break;
                            }
                            finally {
                                object6.unlock();
                            }
                        }
                        case 3: {
                            try {
                                this.uninstalledList.addIPatch((IPatch)object6);
                                object5.sequester();
                                this.sessionData.addToPatchList(10, (Patch)object6, this.msgcat.getMessage("Patch type not installable in this case.", "Patch type not installable in this case."));
                                this.log.println(this, 6, object6.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                            }
                            catch (IOException iOException) {
                                this.handleProblem((Manipulable)object5, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                            }
                            break;
                        }
                        case 2: {
                            try {
                                this.uninstalledList.addIPatch((IPatch)object6);
                                object5.defer();
                                this.sessionData.addToPatchList(11, (Patch)object6, this.msgcat.getMessage("Patch type not installable in this case.", "Patch will be installed at the next scheduled reboot."));
                                this.log.println(this, 6, object6.getPatchID().getPatchID() + ": " + "Patch type not installable in this case.");
                            }
                            catch (CannotDeferException cannotDeferException) {
                                this.handleProblem((Manipulable)object5, true, 10, new SequesterDirectoryAccessException("SequesterDirectoryAccessException", "SequesterDirectoryAccessException.MESSAGE", "SequesterDirectoryAccessException.REMEDY", 2), "PatchBundleInstaller.FAIL_TO_INSTALL", SEQUESTER_DIR_NOT_WRITABLE);
                            }
                            break;
                        }
                        case 4: {
                            this.uninstalledList.addIPatch((IPatch)object6);
                            if (!patchPro.isInteractive()) {
                                string2 = "PatchBundleInstaller.PATCH_IS_RISKY";
                                string = "PatchIsRiskyException.MESSAGE";
                                object3 = "PatchIsRiskyException.REMEDY";
                                this.handleProblem((Manipulable)object5, true, 7, new PatchIsRiskyException("PatchIsRiskyException", string, (String)object3, 2), string2, "Recognized a discontinued, obsolete or point patch. " + object6.getPatchID().getPatchID());
                                break;
                            }
                            if (patchProperties.isDiscontinued() || patchProperties.isNonstandard() || patchProperties.isPointpatch() || patchProperties.isObsolete()) {
                                string2 = "PatchBundleInstaller.PATCH_RISKY_INTERACTIVE";
                                string = "PatchIsRiskyException.INTERACTIVE_MESSAGE";
                                object3 = "PatchIsRiskyException.INTERACTIVE_REMEDY";
                                object2 = new PatchIsRiskyException("PatchIsRiskyException", string, (String)object3, 2);
                                this.handleProblem((Manipulable)object5, true, 7, (PatchProException)object2, string2, "Policy does not allow installation of patches. " + object6.getPatchID().getPatchID());
                                break;
                            }
                            if (patchProperties.isInteractive()) {
                                if (this.internalStatus) {
                                    System.out.println("STATUS INSTALL BEGIN " + object6.getPatchID().getPatchID());
                                    System.out.println("STATUS INSTALL END " + object6.getPatchID().getPatchID() + " " + "INSTALL.252" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_MANUAL", "Update {0} must be manually inspected to determine suitability for installation.") + "\" \"" + object6.getPatchID().getPatchID() + "\"");
                                }
                                string2 = "PatchBundleInstaller.PATCH_INTERACTIVE";
                            } else {
                                if (this.internalStatus) {
                                    System.out.println("STATUS INSTALL BEGIN " + object6.getPatchID().getPatchID());
                                    System.out.println("STATUS INSTALL END " + object6.getPatchID().getPatchID() + " " + "INSTALL.254" + " \"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_PENDING", "Update {0} will be installed at next system shutdown.") + "\" \"" + object6.getPatchID().getPatchID() + "\"");
                                }
                                this.disallowedPatches.addElement(object6.getPatchID().getPatchID());
                                string2 = "PatchBundleInstaller.PATCH_INSTALL_PENDING";
                            }
                            string = "InvalidPatchTypeException.INTERACTIVE_MESSAGE";
                            object3 = "InvalidPatchTypeException.INTERACTIVE_REMEDY";
                            object2 = new InvalidPatchTypeException("InvalidPatchTypeException", string, (String)object3, 5);
                            this.handleProblem((Manipulable)object5, true, 0, (PatchProException)object2, string2, "Policy does not allow installation of patches. " + object6.getPatchID().getPatchID());
                            break;
                        }
                        default: {
                            this.uninstalledList.addIPatch((IPatch)object6);
                            this.handleProblem((Manipulable)object5, true, 7, new PatchIsRiskyException("PatchIsRiskyException", "PatchIsRiskyException.MESSAGE", "PatchIsRiskyException.REMEDY", 4), "PatchBundleInstaller.RISKY_PATCH_TYPE", "Recognized a discontinued, obsolete or point patch. " + object6.getPatchID().getPatchID());
                        }
                    }
                }
                catch (NoManipulatorException noManipulatorException) {
                    this.handleProblem(new Manipulator(), true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", "Patch type not installable in this case. " + object6.getPatchID().getPatchID());
                }
                catch (NoSuchImageException noSuchImageException) {
                    this.handleProblem(new Manipulator(), true, 0, new PatchNotFoundException("PatchNotFoundException", "PatchNotFoundException.MESSAGE", "PatchNotFoundException.REMEDY", 4), "Installer.NO_PATCH_IMAGE", "The installer cannot find the patch. " + object6.getPatchID().getPatchID());
                }
                ++this.numberOfPatchesProcessed;
            }
            if (this.debug) {
                System.out.println("Checking cancellation during patch installation.");
            }
            if (!cancelManager.isCancelRequested()) continue;
            patchList2 = this.getCancelledPatches((PatchList)object7, this.numberOfPatchesProcessed);
            cancelManager.doExitIfCancelRequested("STATUS INSTALL END", patchList2, "INSTALL.253", "\"" + this.msgcat.getMessage("tagstatusmsg.INSTALL_CODE_CANCELLED", "Installation of update {0} was cancelled.") + "\"", null);
            this.dispatchProgressEvent();
        }
        this.log.println(this, 7, "PatchBundleInstaller: Done with all patches.");
        this.dispatchProgressEvent();
        File file4 = null;
        object5 = null;
        object4 = this.sourceDirectory.listFiles();
        string2 = null;
        string = null;
        if (object4 == null) {
            this.log.println(this, 4, "No download summary file to be sequestered.");
        } else {
            object3 = null;
            object2 = null;
            object = new byte[16384];
            for (int i = 0; i < ((File[])object4).length; ++i) {
                string2 = object4[i].getName();
                string = object4[i].getPath();
                if (string2.indexOf("patchpro_dnld_") == -1 || !(file4 = new File(string)).exists()) continue;
                try {
                    object3 = null;
                    object2 = null;
                    object5 = new File(this.sequesterDirectory.getPath() + File.separator + string2);
                    if (!((File)object5).exists()) {
                        ((File)object5).createNewFile();
                    }
                    object3 = new FileInputStream(file4.getPath());
                    object2 = new FileOutputStream(((File)object5).getPath());
                    int n = 0;
                    while ((n = ((FileInputStream)object3).read((byte[])object, 0, ((Object)object).length)) != -1) {
                        ((FileOutputStream)object2).write((byte[])object, 0, n);
                    }
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 2, iOException);
                }
                catch (Exception exception) {
                    this.log.printStackTrace(this, 2, exception);
                }
                finally {
                    try {
                        if (object3 != null) {
                            ((FileInputStream)object3).close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (object2 != null) {
                            ((FileOutputStream)object2).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (file4.delete()) {
                    System.out.println(file4.getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.moved", "has been moved to") + " " + ((File)object5).getPath());
                    continue;
                }
                System.out.println(file4.getPath() + " " + this.msgcat.getMessage("PatchBundleInstaller.copied", "has been copied to") + " " + ((File)object5).getPath());
            }
        }
        if (this.disallowedPatches.size() > 0) {
            object3 = new File(this.sourceDirectory, DISALLOWED_PATCHES_FILE);
            object2 = new Vector();
            try {
                if (((File)object3).exists()) {
                    object = null;
                    String string4 = null;
                    object = new BufferedReader(new FileReader(((File)object3).getPath()));
                    while ((string4 = ((BufferedReader)object).readLine()) != null) {
                        if (string4.length() == 0 || this.disallowedPatches.contains(string4)) continue;
                        this.disallowedPatches.addElement(string4);
                    }
                    ((BufferedReader)object).close();
                }
            }
            catch (Exception exception) {
                System.err.println("Failed when reading from file " + ((File)object3).getPath() + ":" + exception.getMessage());
            }
            try {
                object = new FileOutputStream((File)object3);
                PrintStream printStream = new PrintStream((OutputStream)object);
                if (((Vector)object2).size() > 0) {
                    Iterator iterator = ((Vector)object2).iterator();
                    while (iterator.hasNext()) {
                        printStream.println(iterator.next());
                    }
                }
                Iterator iterator = this.disallowedPatches.iterator();
                while (iterator.hasNext()) {
                    printStream.println(iterator.next());
                }
                printStream.close();
                ((FileOutputStream)object).close();
                System.out.println(" \n" + this.msgcat.getMessage("PatchBundleInstaller.disallowedFile", "ID's of the updates that are disallowed by the installation policy have been \nwritten to file") + "\n\t" + ((File)object3).getPath());
                System.out.println(" \n" + this.msgcat.getMessage("PatchBundleInstaller.systemshutdownInstruction", "One or more updates that you installed requires a system shutdown to activate it.  To initiate the system shutdown, you must use one of the following commands:\n\no Power down the system - init 0 or shutdown -i 0\no Drop to the firmware prompt - init 5 or shutdown -i 5\no Restart the system - init 6 or shutdown -i 6"));
            }
            catch (IOException iOException) {
                System.err.println("Failed when writing to file " + ((File)object3).getPath() + ":" + iOException.getMessage());
            }
        }
        this.dispatchDoneEvent();
        try {
            object3 = this.sessionData.getPatchesNotInstalled();
        }
        catch (Exception exception) {
            object3 = new PatchListImpl();
        }
        return object3;
    }

    private PatchList getCancelledPatches(PatchList patchList, int n) {
        PatchListImpl patchListImpl = new PatchListImpl();
        Patch patch = null;
        if (n == this.numberOfPatchesToInstall) {
            System.out.println(this.msgcat.getMessage("cancel_after_install", "Cancel request received after installation of updates."));
        }
        for (int i = n; i < this.numberOfPatchesToInstall; ++i) {
            try {
                patch = patchList.getPatchAt(i);
                patchListImpl.addIPatch((IPatch)patch);
                continue;
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
        }
        return patchListImpl;
    }

    public Collection getPatchProExceptions() {
        return this.exceptionRepository;
    }

    public Percentage installProgress() {
        Percentage percentage;
        float f = 100.0f;
        if (this.numberOfPatchesToInstall != 0) {
            f = (float)this.numberOfPatchesProcessed / (float)this.numberOfPatchesToInstall * 100.0f;
        }
        try {
            percentage = new Percentage((int)f);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "PatchBundleInstaller.getPatchInstallProgress(): Unable to create a Percentage from " + f + ".");
            f = 100.0f;
            percentage = new Percentage((int)f);
        }
        return percentage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProgressEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchProgress(new InstallPatchEvent(this, this.msgcat.getMessage("progress.message.installing", "Installing updates")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchDoneEvent() {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchDone(new InstallPatchEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFailedEvent(String string) {
        InstallPatchListener installPatchListener = null;
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                installPatchListener = (InstallPatchListener)this.listeners.elementAt(i);
                installPatchListener.installPatchFailed(new InstallPatchEvent(this, string));
            }
        }
    }

    private void addToPatchList(int n, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
    }

    private void addToPatchList(int n, int n2, Patch patch, String string) {
        this.sessionData.addToPatchList(n, patch, string);
        this.sessionData.addToPatchList(n2, patch, string);
    }

    private void extractBundle(File file) {
        SunOSTarFileHandler sunOSTarFileHandler = new SunOSTarFileHandler();
        try {
            sunOSTarFileHandler.extract(file.getPath(), file.getPath(), "patchesBundle.tar", false);
        }
        catch (TarFileHandlerFailedException tarFileHandlerFailedException) {
            // empty catch block
        }
    }

    private boolean checkPatchDependencies(HostSpecificInterpreter hostSpecificInterpreter, Patch patch) throws MissingPatchException, NoSuchPatchException, MalformedPatchException {
        String[] stringArray;
        this.log.println(this, 7, "Checking patch dependencies for: " + patch.getPatchID().getPatchID());
        PatchInfo patchInfo = patch.getPatchInfo();
        if (patchInfo == null) {
            this.log.println(this, 3, patch.getPatchID().getPatchID() + ": " + INTERNAL_SYSTEM_DATA_NOT_VALID + ": patchInfo is null");
            return false;
        }
        String string = patchInfo.getRequires();
        if (string.indexOf("(") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
        } else {
            try {
                stringArray = hostSpecificInterpreter.getPatchList(string);
            }
            catch (ParseError parseError) {
                this.log.printStackTrace(this, 3, parseError);
                return false;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.debug) {
                System.out.println("... Calling getObsolescingPatch (GOP) to check required patch  " + stringArray[i]);
            }
            String string2 = this.getObsolescingPatch(stringArray[i]);
            if (this.debug) {
                System.out.println("... Returning from getObsolescingPatch (GOP). Patch " + string2 + " is the actual required patch to check for dependencies.");
            }
            this.clearCircularObsolescence();
            if (this.uninstalledList.getIPatchByIDString(string2) == null) continue;
            this.log.println(this, 4, patch.getPatchID().getPatchID() + ": " + REQUIRED_PATCH_REVOKED + " " + stringArray[i]);
            return false;
        }
        return true;
    }

    private String getObsolescingPatch(String string) throws MalformedPatchException, MissingPatchException, NoSuchPatchException {
        PatchID patchID;
        PatchID patchID2 = new PatchID(string);
        PatchImpl patchImpl = this.patchdb.getLatestPatch(patchID2);
        IPatch iPatch = new IPatch(patchImpl);
        if (this.debug) {
            System.out.println("PBI.GOP ... ... the latest patch is : " + iPatch.getPatchID().getPatchID());
        }
        if (!iPatch.getPatchInfo().getProperties().isObsolete()) {
            PatchID patchID3;
            try {
                patchID3 = iPatch.getPatchInfo().getObsolescedBy();
            }
            catch (NoSuchPatchException noSuchPatchException) {
                if (this.debug) {
                    System.out.println("PBI.GOP ... ... Patch " + iPatch.getPatchID().getPatchID() + "\" is not obsolete. Returning : " + iPatch.getPatchID().getPatchID());
                }
                return iPatch.getPatchID().getPatchID();
            }
            if (this.debug) {
                System.out.println("Error: Patch \"" + iPatch.getPatchID().getPatchID() + "\" is not obsolete but it is defined to be " + "obsoleted by patch \"" + patchID3.getPatchID() + "\"");
            }
            throw new NoSuchPatchException("Patch \"" + iPatch.getPatchID().getPatchID() + "\" is not obsolete but it is defined to be " + "obsoleted by patch \"" + patchID3.getPatchID() + "\"");
        }
        this.log.println(this, 7, "PatchBundleInstaller.getObsolescingPatch(): The patch " + iPatch.getPatchID().getPatchID() + " is obsolete.");
        if (this.debug) {
            System.out.println("PBI.GOP ... ... Patch " + iPatch.getPatchID().getPatchID() + " is obsolete. Trying to find the obsolescing patch.");
        }
        try {
            patchID = iPatch.getPatchInfo().getObsolescedBy();
        }
        catch (NoSuchPatchException noSuchPatchException) {
            if (this.debug) {
                System.out.println("PBI.GOP ... ... The patch that was suppose to obsolete" + iPatch.getPatchID().getPatchID() + " could not be found in the PatchDB.");
            }
            throw new NoSuchPatchException("Patch \"" + iPatch.getPatchID().getPatchID() + "\" is obsolete but the patch that obsoletes it " + "could not be found in the patch database.");
        }
        this.log.println(this, 7, "PatchBundleInstaller.getObsolescingPatch(): The patch " + iPatch.getPatchID().getPatchID() + " is obsolesced by " + patchID.getPatchID());
        if (this.debug) {
            System.out.println("PBI.GOP ... ... The patch " + iPatch.getPatchID().getPatchID() + " is obsolesced by " + patchID.getPatchID());
        }
        IPatch iPatch2 = null;
        try {
            iPatch2 = this.getIPatchFromDB(patchID);
        }
        catch (NoSuchPatchException noSuchPatchException) {
            throw new MissingPatchException("The obsolescing patch \"" + patchID.getPatchID() + "\"" + " could not be found in the patch database.\n" + "Exception message: " + noSuchPatchException.getMessage());
        }
        if (this.checkForCircularObsolescence(iPatch2)) {
            if (this.debug) {
                System.out.println("PBI.GOP ... ... Circular dependency issue detected for patch \"" + iPatch2.getPatchID().getPatchID() + "\".");
            }
            throw new NoSuchPatchException("Circular dependency issue detected for patch \"" + iPatch2.getPatchID().getPatchID() + "\".");
        }
        if (this.debug) {
            System.out.println("PBI.GOP ... ... Recursively call GOP for the patch that makes " + iPatch2.getPatchID().getPatchID() + " obsolete.");
        }
        return this.getObsolescingPatch(iPatch2.getPatchID().getPatchID());
    }

    private void clearCircularObsolescence() {
        this.oblist = null;
    }

    private boolean checkForCircularObsolescence(IPatch iPatch) {
        if (this.oblist == null) {
            this.oblist = new Vector();
            this.oblist.addElement(iPatch);
            return false;
        }
        Enumeration enumeration = this.oblist.elements();
        String string = iPatch.getPatchID().getPatchID();
        while (enumeration.hasMoreElements()) {
            IPatch iPatch2 = (IPatch)enumeration.nextElement();
            if (!string.equals(iPatch2.getPatchID().getPatchID())) continue;
            return true;
        }
        this.oblist.addElement(iPatch);
        return false;
    }

    private IPatch getIPatchFromDB(PatchID patchID) throws NoSuchPatchException {
        if (patchID == null) {
            return null;
        }
        PatchImpl patchImpl = this.patchdb.getLatestPatch(patchID);
        if (patchImpl == null) {
            this.log.println(this, 4, "PatchBundleInstaller: Database returned null patch and no exception");
            throw new NoSuchPatchException("got null patch from database");
        }
        return new IPatch(patchImpl);
    }

    private boolean allPatchTypesAreAllowed(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPatch(Manipulable manipulable) throws InstallFailedException {
        Installable installable = null;
        Patch patch = manipulable.getPatch();
        this.thisPatchInstallDone = false;
        this.thisPatchInstallFailed = false;
        try {
            installable = manipulable.getInstaller();
            Thread thread = new Thread(installable);
            installable.addListener(this);
            thread.start();
            while (!this.thisPatchInstallDone) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            installable.removeListener(this);
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.thisPatchInstallFailed) {
                throw new PatchInstallFailedException(installable.getFailure().getMessage());
            }
            System.out.println(patch.getPatchID().getPatchID() + " " + this.msgcat.getMessage("PatchBundleInstaller.applied", "has been applied."));
            this.log.println(this, 7, "Just invoked installPatch for: " + patch.getPatchID().getPatchID());
            this.sessionData.addToPatchList(9, patch, "");
        }
        catch (InstallFailedException installFailedException) {
            this.recordInstallFailedException(installFailedException, patch);
            if (installFailedException instanceof PatchInstallFailedException) {
                this.log.println(this, 1, this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", new String[]{patch.getPatchID().getPatchID()}, "Failed to install patch {0}.") + "\n\npatchadd utility failed. " + "Reason code :" + ((PatchInstallFailedException)installFailedException).getReasonCode() + "\n" + ((PatchInstallFailedException)installFailedException).getMessage());
                System.err.println(this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", new String[]{patch.getPatchID().getPatchID()}, "Failed to install patch {0}.") + "\n\npatchadd utility failed. " + "Reason code :" + ((PatchInstallFailedException)installFailedException).getReasonCode() + "\n" + ((PatchInstallFailedException)installFailedException).getMessage());
            } else {
                this.log.println(this, 1, "Failed to install a patch. " + patch.getPatchID().getPatchID());
                System.err.println(this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", new String[]{patch.getPatchID().getPatchID()}, "Failed to install patch {0}."));
            }
            this.dispatchFailedEvent(PatchProLog.createMessage(1, this.msgcat.getMessage("PatchBundleInstaller.FAIL_TO_INSTALL", new String[]{patch.getPatchID().getPatchID()}, "Fail to install patch {0}.")));
            this.log.printStackTrace(this, 7, installFailedException);
        }
        finally {
            if (installable != null) {
                installable.removeListener(this);
            }
        }
    }

    private void handleProblem(Manipulable manipulable) {
        this.handleProblem(manipulable, true, 10, new InvalidPatchTypeException("InvalidPatchTypeException", "InvalidPatchTypeException.MESSAGE", "InvalidPatchTypeException.REMEDY", 4), "PatchBundleInstaller.INVALID_PATCH_TYPE", INVALID_PATCH_TYPE);
    }

    private void handleProblem(boolean bl, PatchProException patchProException, String string, String string2) {
        this.handleProblem(null, bl, -1, patchProException, string, string2);
    }

    private void handleProblem(Manipulable manipulable, boolean bl, int n, PatchProException patchProException, String string, String string2) {
        Patch patch;
        String string3 = "";
        this.bundleFailed = true;
        Object[] objectArray = null;
        if (manipulable != null && (patch = manipulable.getPatch()) != null) {
            string3 = new String("" + patch.getPatchID().getPatchID());
            objectArray = new Object[]{string3};
            if (!this.model.isInteractive()) {
                if (n == 10) {
                    this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
                } else {
                    this.addToPatchList(n, 10, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
                }
                try {
                    manipulable.sequester();
                }
                catch (IOException iOException) {}
            } else {
                this.sessionData.addToPatchList(n, patch, this.msgcat.getMessage(string, objectArray, "Patch has failed for an unknown reason."));
            }
        }
        if (!this.warnedNoInstall) {
            this.updateExceptionRepository(patchProException);
            this.log.println(this, patchProException.getSeverity(), string2);
            if (bl) {
                if (objectArray != null) {
                    this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, objectArray, "Patch install has failed for an unknown reason.")));
                } else {
                    this.dispatchFailedEvent(PatchProLog.createMessage(patchProException.getSeverity(), this.msgcat.getMessage(string, "Patch install has failed for an unknown reason.")));
                }
            }
        }
    }

    private void recordInstallFailedException(InstallFailedException installFailedException, Patch patch) {
        if (installFailedException instanceof PatchInstallFailedException) {
            int n = ((PatchInstallFailedException)installFailedException).getReasonCode();
            switch (n) {
                case 2: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PATCH_ALREADY_APPLIED);
                    DuplicatePatchException duplicatePatchException = new DuplicatePatchException("DuplicatePatchException", "DuplicatePatchException.MESSAGE", "DuplicatePatchException.REMEDY", 3);
                    this.updateExceptionRepository(duplicatePatchException);
                    break;
                }
                case 3: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_NON_ROOT_UID);
                    NonRootUserException nonRootUserException = new NonRootUserException("NonRootUserException", "NonRootUserException.MESSAGE", "NonRootUserException.REMEDY", 3);
                    this.updateExceptionRepository(nonRootUserException);
                    break;
                }
                case 9: {
                    this.sessionData.addToPatchList(8, patch, PATCHADD_PKGADD_NOT_FOUND);
                    SunOSPkgaddAccessException sunOSPkgaddAccessException = new SunOSPkgaddAccessException("SunOSPkgaddAccessException", "SunOSPkgaddAccessException.MESSAGE", "SunOSPkgaddAccessException.REMEDY", 3);
                    this.updateExceptionRepository(sunOSPkgaddAccessException);
                    break;
                }
                case 18: {
                    this.addToPatchList(8, patch, PATCHADD_NOT_ENOUGH_SPACE);
                    InsufficientFileSystemSpaceException insufficientFileSystemSpaceException = new InsufficientFileSystemSpaceException("InsufficientFileSystemSpaceException", "InsufficientFileSystemSpaceException.MESSAGE", "InsufficientFileSystemSpaceException.REMEDY", 3);
                    this.updateExceptionRepository(insufficientFileSystemSpaceException);
                    break;
                }
                default: {
                    this.sessionData.addToPatchList(7, patch, FAIL_TO_INSTALL);
                    PatchInstallException patchInstallException = new PatchInstallException("PatchInstallException", "PatchInstallException.MESSAGE", "PatchInstallException.REMEDY", 3);
                    this.updateExceptionRepository(patchInstallException);
                }
            }
        }
    }

    private void updateExceptionRepository(PatchProException patchProException) {
        if (!this.exceptionRepository.contains(patchProException)) {
            this.exceptionRepository.add(patchProException);
        }
    }

    public void manipulatorProgress(ManipulatorEvent manipulatorEvent) {
        this.dispatchProgressEvent();
    }

    public void manipulatorDone(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
    }

    public void manipulatorFailed(InstallerEvent installerEvent) {
        Exception exception = ((Installable)installerEvent.getSource()).getFailure();
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent(exception.getMessage());
    }

    public void manipulatorFailed(RemoverEvent removerEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Remover event.");
    }

    public void manipulatorFailed(VerifierEvent verifierEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Verifier event.");
    }

    public void manipulatorFailed(ManipulatorEvent manipulatorEvent) {
        this.thisPatchInstallDone = true;
        this.thisPatchInstallFailed = true;
        this.dispatchFailedEvent("Received a Manipulable event.");
    }
}

