/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.cc.platform.clientsignature.CNSClientSignature;
import com.sun.cc.platform.clientsignature.CNSSignException;
import com.sun.net.ssl.HttpsURLConnection;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.security.SSLTunnelSocketFactory;
import com.sun.patchpro.util.Base64;
import com.sun.patchpro.util.CCRCmdLine;
import com.sun.patchpro.util.CCRIOException;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.InvalidParameterException;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.LockException;
import com.sun.patchpro.util.Percentage;
import com.sun.patchpro.util.PrivilegedAccessDeniedException;
import com.sun.patchpro.util.PropertyNotDefinedException;
import com.sun.patchpro.util.PropertyNotSpecifiedException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Encoder;

public class Downloader
extends InputStream {
    private static final int MAXBUFFERSIZE = 0x100000;
    private static final double PERCENT = 0.05;
    protected URL sourceURL = null;
    private String postHeaderString = null;
    private String protocol = "";
    private int contentLength = 0;
    private URLConnection connection = null;
    private boolean protocolIsFile = false;
    private boolean fileIsAccessible = false;
    private LocalizedMessages msgcat;
    protected int onePercent;
    protected int totalbytes;
    private int numBytesRead;
    protected boolean cancelEnabled;
    protected boolean contract;
    protected String user = null;
    protected String password = null;
    private Vector listeners;
    protected BufferedInputStream in;
    protected PatchProLog log;
    private PatchProProperties properties;
    private CCRCmdLine ccrCmdLine;
    boolean isPatchServer = false;
    private boolean debug = false;
    boolean internalStatus = false;
    protected static final int ONE_MINUTE = 60000;

    public Downloader(URL uRL, String string, boolean bl, String string2, String string3) {
        this.sourceURL = uRL;
        this.protocol = this.sourceURL.getProtocol();
        this.postHeaderString = string;
        this.contract = bl;
        this.user = string2;
        this.password = string3;
        this.totalbytes = 0;
        this.cancelEnabled = false;
        this.log = PatchProLog.getInstance();
        this.ccrCmdLine = CCRCmdLine.getInstance();
        String string4 = this.sourceURL.getFile();
        if (!string4.endsWith("/") && this.protocol.equalsIgnoreCase("https")) {
            try {
                this.sourceURL = new URL(this.protocol, this.sourceURL.getHost(), this.sourceURL.getPort(), string4 + "/");
                this.log.println(this, 4, "appended missing slash to specified source URL");
            }
            catch (MalformedURLException malformedURLException) {
                this.sourceURL = uRL;
            }
        }
        this.properties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
        this.internalStatus = this.properties.getProperty("patchpro.internal.statustags", "false").equals("true");
        if (this.protocol.compareTo("file") == 0) {
            this.protocolIsFile = true;
            File file = new File(this.sourceURL.getFile());
            if (file.exists() && file.canRead()) {
                this.fileIsAccessible = true;
            }
        }
        this.listeners = new Vector();
    }

    public Downloader(URL uRL) {
        this(uRL, "", false, "", "");
    }

    public void connectToURL() throws IOException {
        String string;
        String string2;
        this.connection = this.sourceURL.openConnection();
        if (this.connection instanceof HttpsURLConnection) {
            string2 = System.getProperty("https.proxyHost");
            string = System.getProperty("https.proxyPort");
            if (string2 != null && string != null && string2.length() > 0 && string.length() > 0) {
                ((HttpsURLConnection)this.connection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory(string2, string));
            }
        }
        this.connection.setAllowUserInteraction(true);
        if (this.contract) {
            this.setAuthentication(this.user, this.password);
        }
        string2 = "";
        try {
            string2 = this.ccrCmdLine.get("cns.assetid");
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
            if (exception instanceof PropertyNotDefinedException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.6", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_PROPERTY_NOT_DEFINED", "Error occured while retrieving the system assetid. The assetid property is not defined in declarations. Client configuration registry returned error code 1.") + "\"", null);
            } else if (exception instanceof PropertyNotSpecifiedException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.7", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_PROPERTY_NOT_SPECIFIED", "Error occured while retrieving the system assetid. The assetid property is declared but not overridden. Client configuration registry returned error code: 2.") + "\"", null);
            } else if (exception instanceof LockException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.8", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_ERROR_LOCKED_RC3", "Error occured while retrieving the system assetid. The system cannot access the client configuration registry. Retry. CCR returned error code: 3.") + "\"", null);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.log.printStackTrace(this, 3, interruptedException);
                }
            } else if (exception instanceof InvalidParameterException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.9", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_ERROR_INVALID_PARAMETER", "Error occured while retrieving the system assetid. The SUNWcnsPltfmCCR installed on the system is incompatible with this version of smpatch. CCR returned error code: 4.") + "\"", null);
            } else if (exception instanceof CCRIOException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.10", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_ERROR_IO", "Error occured while retrieving the system assetid. Verify if the system is registered. CCR returned error code: 5.") + "\"", null);
            } else if (exception instanceof PrivilegedAccessDeniedException) {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.11", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_ERROR_PRIVILEGED_ACCESS_DENIED", "Error occured while retrieving the system assetid. Verify the permissions to access the assetid. CCR returned error code: 6.") + "\"", null);
            } else {
                this.printTaggedMessage("STATUS ANALYZE END", "ANALYZE.8", "\"" + this.msgcat.getMessage("tagstatusmsg.ANALYZE_CODE_CCR_ERROR_LOCKED_RC7", "Error occured while retrieving the system assetid. CCR returned error code: 7.") + "\"", null);
            }
            System.exit(1);
        }
        if (string2 == null || string2.equals(" ")) {
            string2 = "";
        }
        string = "";
        byte[] byArray = null;
        if (!string2.equals("")) {
            byArray = string2.getBytes();
            try {
                string = CNSClientSignature.genSigString((byte[])byArray);
            }
            catch (CNSSignException cNSSignException) {
                this.log.printStackTrace(this, 3, cNSSignException);
            }
        }
        this.setSignatureHeader(string2, string);
        if (this.postHeaderString.compareTo("") != 0) {
            this.connection.setDoOutput(true);
            PrintWriter printWriter = new PrintWriter(this.connection.getOutputStream());
            printWriter.print(this.postHeaderString);
            printWriter.flush();
            if (printWriter.checkError()) {
                this.log.println(this, 4, "PrinterWriter error!");
            }
            printWriter.close();
        }
        this.connection.getInputStream();
        this.resetProgress();
        try {
            this.in = new BufferedInputStream(this.connection.getInputStream());
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            this.log.println(this, 4, "URLConnection.getInputStream threw an exception which is not of type IOException as described in the Java API specification.");
            throw new IOException(exception.toString());
        }
    }

    private void printTaggedMessage(String string, String string2, String string3, String string4) {
        String string5 = "";
        if (this.debug) {
            System.out.println("Entered printTaggedMessage()");
        }
        if (this.internalStatus) {
            if (string2 == null) {
                string5 = string;
            } else if (string3 == null) {
                string5 = string + " " + string2;
            } else if (string4 == null) {
                string5 = string + " " + string2 + " " + string3;
            } else {
                string5 = string + " " + string2 + " " + string3 + " " + string4;
                if (this.debug) {
                    System.out.println("printTaggedMessage(): msg: " + string5);
                }
            }
            System.out.println(string5.trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadListener);
        }
    }

    public String getContentType() {
        return this.connection.getContentType();
    }

    public int getContentLength() {
        int n;
        try {
            n = this.connection.getContentLength();
            if (n == -1) {
                n = 0x100000;
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "URLConnection.getContentLength threw an exception instead of returning -1 as described in the Java API specification.");
            n = 0x100000;
        }
        return n;
    }

    public int getBufferLength() {
        int n = this.getContentLength();
        double d = (double)n * 0.05;
        if (d > 1048576.0) {
            d = 1048576.0;
        }
        return (int)d;
    }

    public int available() {
        return 1;
    }

    public Percentage getStatus() {
        Percentage percentage;
        int n = (int)((long)this.totalbytes / (long)this.onePercent);
        try {
            percentage = new Percentage(n);
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Downloader.getStatus(): Unable to create a Percentage from " + n + ".");
            percentage = new Percentage(100);
        }
        return percentage;
    }

    public Percentage getProgress() {
        return this.getStatus();
    }

    protected void resetProgress() {
        this.contentLength = this.getContentLength();
        this.onePercent = (int)((long)this.contentLength / 100L);
        this.numBytesRead = 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.cancelEnabled) {
            this.sendFailureEvent();
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            if (this.contentLength >= 0) {
                this.sendDoneEvent();
            } else {
                this.sendFailureEvent();
            }
        }
        this.numBytesRead += n3;
        if (this.numBytesRead >= this.getBufferLength()) {
            this.totalbytes += this.numBytesRead;
            this.numBytesRead = 0;
            this.updateProgress();
        }
        return n3;
    }

    public int read() throws IOException {
        if (this.cancelEnabled) {
            this.sendFailureEvent();
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            if (this.contentLength >= 0) {
                this.sendDoneEvent();
            } else {
                this.sendFailureEvent();
            }
        }
        ++this.totalbytes;
        if (this.totalbytes % (this.onePercent * 5) == 0) {
            this.updateProgress();
        }
        return n;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgress() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadProgress(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendDoneEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadDone(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFailureEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadFailed(new DownloadEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAuthenticationFailureEvent() {
        Vector vector = this.listeners;
        synchronized (vector) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                DownloadListener downloadListener = (DownloadListener)this.listeners.elementAt(i);
                downloadListener.downloadFailed(new DownloadEvent(this));
            }
        }
    }

    public void cancelDownload() {
        this.cancelEnabled = true;
    }

    public boolean isCancelEnabled() {
        return this.cancelEnabled;
    }

    public String getAuthenticationDomain() {
        String string = this.connection.getHeaderField("WWW-Authenticate");
        string = string.substring(string.indexOf(34) + 1, string.length() - 1);
        return string;
    }

    public void setSignatureHeader(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.isPatchServer = this.properties.getProperty("patchpro.ispatchserver").equals("true");
        String string3 = this.isPatchServer ? "_1" : "_0";
        stringBuffer.append(string3).append(string).append(':').append(string2);
        Base64 base64 = new Base64();
        String string4 = Base64.encodePart(stringBuffer.toString().getBytes());
        this.connection.setRequestProperty("Authorization", "Basic " + string4);
    }

    public void setAuthentication(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(':').append(string2);
        String string3 = new BASE64Encoder().encode(stringBuffer.toString().getBytes());
        this.connection.setRequestProperty("Authorization", "Basic " + string3);
    }

    public int getResponseCode() {
        int n = 0;
        try {
            if (this.protocolIsFile) {
                n = this.fileIsAccessible ? 200 : 404;
            } else {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.connection;
                n = httpURLConnection.getResponseCode();
                this.log.println(this, 4, "response code is " + n);
            }
        }
        catch (IOException iOException) {
            this.log.println(this, 3, "Downloader.getResponseCode() : IOException" + iOException.getMessage());
            n = 500;
        }
        return n;
    }

    public String getHeaderField(String string) {
        return this.connection.getHeaderField(string);
    }
}

