/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CCRIOException;
import com.sun.patchpro.util.InvalidParameterException;
import com.sun.patchpro.util.LockException;
import com.sun.patchpro.util.PrivilegedAccessDeniedException;
import com.sun.patchpro.util.PropertyNotDefinedException;
import com.sun.patchpro.util.PropertyNotSpecifiedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CCRCmdLine {
    private String declaration;
    private String privileged;
    private String nonprivileged;
    private String value = null;
    private final String CCR_EXE;
    private static CCRCmdLine ccrCmdLine;
    private PatchProProperties properties;
    PatchProLog log = null;

    private CCRCmdLine(String string, String string2, String string3) {
        this.declaration = string;
        this.privileged = string2;
        this.nonprivileged = string3;
        this.properties = PatchProProperties.getInstance();
        String string4 = this.properties.getProperty("patchpro.ccr.directory", "/usr/lib/cc-ccr/bin/ccr");
        this.CCR_EXE = System.getProperty("CCREXE", string4);
        this.log = PatchProLog.getInstance();
    }

    private CCRCmdLine() {
        this(null, null, null);
    }

    public static synchronized CCRCmdLine getInstance() {
        if (ccrCmdLine == null) {
            ccrCmdLine = new CCRCmdLine();
        }
        return ccrCmdLine;
    }

    public static synchronized CCRCmdLine getInstance(String string, String string2, String string3) {
        if (ccrCmdLine == null) {
            ccrCmdLine = new CCRCmdLine(string, string2, string3);
        }
        return ccrCmdLine;
    }

    public String get(String string) throws Exception {
        if (this.value == null) {
            try {
                this.value = CCRCmdLine.listToString(this.exec("-g " + string));
            }
            catch (PropertyNotDefinedException propertyNotDefinedException) {
                this.log.printStackTrace(this, 3, propertyNotDefinedException);
                throw propertyNotDefinedException;
            }
            catch (PropertyNotSpecifiedException propertyNotSpecifiedException) {
                this.log.printStackTrace(this, 3, propertyNotSpecifiedException);
                throw propertyNotSpecifiedException;
            }
            catch (LockException lockException) {
                this.log.printStackTrace(this, 3, lockException);
                throw lockException;
            }
            catch (InvalidParameterException invalidParameterException) {
                this.log.printStackTrace(this, 3, invalidParameterException);
                throw invalidParameterException;
            }
            catch (CCRIOException cCRIOException) {
                this.log.printStackTrace(this, 3, cCRIOException);
                throw cCRIOException;
            }
            catch (PrivilegedAccessDeniedException privilegedAccessDeniedException) {
                this.log.printStackTrace(this, 3, privilegedAccessDeniedException);
                throw privilegedAccessDeniedException;
            }
            catch (RuntimeException runtimeException) {
                this.log.printStackTrace(this, 3, runtimeException);
                throw runtimeException;
            }
            this.set(this.value);
        }
        return this.value;
    }

    private void set(String string) {
        this.value = string;
    }

    private List exec(String string) throws Exception {
        ArrayList<String> arrayList = null;
        String string2 = this.CCR_EXE + (this.declaration == null ? "" : " -x " + this.declaration + " -y " + this.privileged + " -z " + this.nonprivileged) + " " + string;
        try {
            Process process = Runtime.getRuntime().exec(string2);
            process.waitFor();
            int n = process.exitValue();
            if (n == 0) {
                arrayList = new ArrayList<String>();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    arrayList.add(string3);
                    string3 = bufferedReader.readLine();
                }
            } else {
                if (n == 1) {
                    throw new PropertyNotDefinedException("PropertyNotDefinedException: Error code calling " + string2 + " : " + n);
                }
                if (n == 2) {
                    throw new PropertyNotSpecifiedException("PropertyNotSpecifiedException: Error code calling " + string2 + " : " + n);
                }
                if (n == 3) {
                    throw new LockException("LockException: Error code calling " + string2 + " : " + n);
                }
                if (n == 4) {
                    throw new InvalidParameterException("InvalidParameterException: Error code calling " + string2 + " : " + n);
                }
                if (n == 5) {
                    throw new CCRIOException("CCRIOException: Error code calling " + string2 + " : " + n);
                }
                if (n == 6) {
                    throw new PrivilegedAccessDeniedException("PrivilegedAccessDeniedException: Error code calling " + string2 + " : " + n);
                }
                if (n == 7) {
                    throw new RuntimeException("Exception: Error code calling " + string2 + " : " + n);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Cannot exec " + string2 + ": " + iOException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException("Cannot exec " + string2 + ": " + interruptedException);
        }
        return arrayList;
    }

    private static String listToString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

