/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchContents;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.util.FootPrints;
import java.io.File;
import java.util.StringTokenizer;

public class PatchImpl
implements Patch {
    private PatchInfoImpl patchInfo;
    private PatchID patchid;
    private PatchContents contents;
    private boolean debug = false;
    private File inuseFile = null;
    private FootPrints footPrints = null;
    private PatchProProperties properties;

    public PatchImpl(PatchID patchID) {
        this(null, patchID);
    }

    public PatchImpl(PatchInfoImpl patchInfoImpl, PatchID patchID) {
        this.setPatchInfo(patchInfoImpl);
        this.patchid = patchID;
        this.setPatchContents();
    }

    public PatchImpl(PatchInfo patchInfo, PatchID patchID) {
        this(new PatchInfoImpl(patchInfo), patchID);
    }

    public void setPatchInfo(PatchInfoImpl patchInfoImpl) {
        if (patchInfoImpl == null) {
            patchInfoImpl = new PatchInfoImpl();
        }
        this.patchInfo = patchInfoImpl;
    }

    public PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    public PatchID getPatchID() {
        return this.patchid;
    }

    public String getPatchIDKey() {
        return this.patchid.getPatchID();
    }

    public String getBasecodeKey() {
        return this.patchid.getBasecode();
    }

    public PatchContents getPatchContents() {
        return this.contents;
    }

    public PatchInfoImpl getPatchInfoImpl() {
        return this.patchInfo;
    }

    public boolean equals(Patch patch) {
        PatchID patchID = patch.getPatchID();
        if (this.patchid != null && patchID != null ? !this.patchid.equals(patchID) : this.patchid != null || patchID != null) {
            return false;
        }
        PatchInfo patchInfo = patch.getPatchInfo();
        return !(this.patchInfo != null && patchInfo != null ? !this.patchInfo.equals(patchInfo) : this.patchInfo != null || patchInfo != null);
    }

    public boolean isEquivalentTo(Patch patch) {
        boolean bl = false;
        String string = this.patchid.getBasecode();
        String string2 = this.patchid.getRevision();
        String string3 = patch.getPatchID().getPatchID();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (string.compareTo(string4) == 0) {
            int n = new Integer(string2);
            int n2 = new Integer(string5);
            if (n2 >= n) {
                bl = true;
            }
        }
        return bl;
    }

    private void setPatchContents() {
        if (this.patchInfo != null) {
            this.contents = new PatchContents(this, this.patchid.getBasecode(), this.patchid.getRevision(), this.patchInfo.getProperties());
        }
    }

    public boolean lock() {
        boolean bl = false;
        boolean bl2 = false;
        this.footPrints = FootPrints.getInstance();
        this.properties = PatchProProperties.getInstance();
        this.debug = this.properties.getProperty("patchpro.debug").equals("true");
        bl2 = this.properties.getProperty("patchpro.internal.shutdown").equals("true");
        if (bl2) {
            if (this.debug) {
                System.out.println("Shutdown in progress. Patch " + this.getPatchID().getPatchID() + "will not be locked.");
            }
            return false;
        }
        if (this.debug) {
            System.out.println("Locking patch " + this.getPatchID().getPatchID() + ".");
        }
        String string = this.properties.getProperty("patchpro.patch.footprint.directory", File.separator + "var" + File.separator + "run");
        File file = new File(string);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
            this.inuseFile = new File(file.getAbsolutePath(), this.getPatchID().getPatchID() + ".inuse");
            if (!this.inuseFile.exists()) {
                if (this.debug) {
                    System.out.println("... Creating the lock (inuse) file.");
                }
                this.inuseFile.createNewFile();
                this.footPrints.setPatchFile(this.inuseFile);
                bl = true;
            } else {
                if (this.debug) {
                    System.out.print("... Have to wait before creating the lock (inuse) file...");
                }
                for (int i = 0; i < 17280; ++i) {
                    Thread.sleep(5000L);
                    if (this.inuseFile.exists()) continue;
                    this.inuseFile.createNewFile();
                    this.footPrints.setPatchFile(this.inuseFile);
                    bl = true;
                    if (!this.debug) break;
                    System.out.println("... Was able to create lock (inuse) file after " + i * 5 + " seconds.");
                    break;
                }
            }
            if (!bl) {
                if (this.debug) {
                    System.err.println("Was not able to create inuse file after the reserved amount of time ");
                }
                return false;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public void unlock() {
        this.footPrints = FootPrints.getInstance();
        this.debug = this.properties.getProperty("patchpro.debug").equals("true");
        if (this.debug) {
            System.out.println("Unlocking patch " + this.getPatchID().getPatchID() + ".");
        }
        if (this.inuseFile != null) {
            this.inuseFile.delete();
        }
        this.footPrints.setPatchFile(null);
    }
}

