/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cc.transport.client;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class SysLogHandler
extends StreamHandler {
    private static String hostname;
    private static InetAddress ipAddress;
    private static String identity;
    private static String logPrepend;
    private static Level level;

    public SysLogHandler() {
        this.getProps();
        LogManager.getLogManager().addPropertyChangeListener(new SysLogPropChgs());
    }

    private void getProps() {
        hostname = LogManager.getLogManager().getProperty("com.sun.cc.transport.client.SysLogHandler.hostname");
        if (hostname == null) {
            hostname = "localhost";
        }
        try {
            ipAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            System.err.println("com.sun.cc.transport.client.SysLogHandler unable to resolve host '" + hostname + "'.  Defaulting to localhost.");
            e.printStackTrace();
            hostname = "localhost";
            try {
                ipAddress = InetAddress.getByName(hostname);
            }
            catch (UnknownHostException x) {
                System.err.println("com.sun.cc.transport.client.SysLogHandler unable to resolve host '" + hostname + "'.  Defaulting to stderr.");
                x.printStackTrace();
            }
        }
        identity = LogManager.getLogManager().getProperty("com.sun.cc.transport.client.SysLogHandler.ident");
        if (identity == null) {
            identity = "IM-CC_ENG-unknown";
        }
        level = null;
        String lvl = LogManager.getLogManager().getProperty("com.sun.cc.transport.client.SysLogHandler.level");
        if (lvl != null) {
            level = Level.parse(lvl);
        }
        logPrepend = LogManager.getLogManager().getProperty("com.sun.cc.transport.client.SysLogHandler.prepend");
    }

    public String getIPAddress() {
        return hostname;
    }

    private void sendMessage(String logSev, String msg) {
        block3: {
            try {
                DatagramSocket soc = new DatagramSocket();
                msg = logPrepend != null ? "<3>" + identity + ":  " + logSev + ":  " + logPrepend + ":  " + msg : "<3>" + identity + ":  " + logSev + ":  " + msg;
                if (ipAddress == null) {
                    System.err.println(msg);
                    return;
                }
                byte[] msgA = msg.getBytes();
                DatagramPacket p = new DatagramPacket(msgA, msgA.length, ipAddress, 514);
                soc.send(p);
                soc.close();
            }
            catch (Exception e) {
                System.err.println("com.sun.cc.transport.client.SysLogHandler Failed to Write to Syslog");
                e.printStackTrace();
                if (msg == null) break block3;
                System.err.println(msg);
            }
        }
    }

    public void publish(LogRecord logRec) {
        int lvlVal = logRec.getLevel().intValue();
        if (level != null) {
            if (lvlVal >= level.intValue()) {
                this.sendMessage(this.mapLevel(lvlVal), this.getFormatter().formatMessage(logRec));
            }
        } else {
            this.sendMessage(this.mapLevel(lvlVal), this.getFormatter().formatMessage(logRec));
        }
    }

    private String mapLevel(int lvlVal) {
        switch (lvlVal) {
            case 1000: {
                return "ERROR";
            }
            case 900: {
                return "WARNING";
            }
            case 800: {
                return "INFO";
            }
            case 700: {
                return "CONFIG";
            }
            case 500: {
                return "FINE";
            }
            case 400: {
                return "FINER";
            }
            case 300: {
                return "FINEST";
            }
        }
        return "INFO";
    }

    static {
        level = null;
    }

    class SysLogPropChgs
    implements PropertyChangeListener {
        SysLogPropChgs() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SysLogHandler.this.getProps();
        }
    }
}

