/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dtd;

import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.util.Vector;

public class XMLDTDDescription
extends XMLResourceIdentifierImpl
implements com.sun.org.apache.xerces.internal.xni.grammars.XMLDTDDescription {
    protected String fRootName = null;
    protected Vector fPossibleRoots = null;

    public int hashCode() {
        if (this.fExpandedSystemId != null) {
            return this.fExpandedSystemId.hashCode();
        }
        if (this.fPublicId != null) {
            return this.fPublicId.hashCode();
        }
        return 0;
    }

    public XMLDTDDescription(XMLInputSource source) {
        this.setValues(source.getPublicId(), null, source.getBaseSystemId(), source.getSystemId());
        this.fRootName = null;
        this.fPossibleRoots = null;
    }

    public boolean equals(Object desc) {
        if (!(desc instanceof XMLGrammarDescription)) {
            return false;
        }
        if (!this.getGrammarType().equals(((XMLGrammarDescription)desc).getGrammarType())) {
            return false;
        }
        XMLDTDDescription dtdDesc = (XMLDTDDescription)desc;
        if (this.fRootName != null) {
            if (dtdDesc.fRootName != null && !dtdDesc.fRootName.equals(this.fRootName)) {
                return false;
            }
            if (dtdDesc.fPossibleRoots != null && !dtdDesc.fPossibleRoots.contains(this.fRootName)) {
                return false;
            }
        } else if (this.fPossibleRoots != null) {
            if (dtdDesc.fRootName != null) {
                if (!this.fPossibleRoots.contains(dtdDesc.fRootName)) {
                    return false;
                }
            } else {
                if (dtdDesc.fPossibleRoots == null) {
                    return false;
                }
                boolean found = false;
                int i = 0;
                while (i < this.fPossibleRoots.size()) {
                    String root = (String)this.fPossibleRoots.elementAt(i);
                    found = dtdDesc.fPossibleRoots.contains(root);
                    if (found) break;
                    ++i;
                }
                if (!found) {
                    return false;
                }
            }
        }
        if (this.fExpandedSystemId != null ? !this.fExpandedSystemId.equals(dtdDesc.fExpandedSystemId) : dtdDesc.fExpandedSystemId != null) {
            return false;
        }
        return !(this.fPublicId != null ? !this.fPublicId.equals(dtdDesc.fPublicId) : dtdDesc.fPublicId != null);
    }

    public String getGrammarType() {
        return "http://www.w3.org/TR/REC-xml";
    }

    public String getRootName() {
        return this.fRootName;
    }

    public void setRootName(String rootName) {
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }

    public void setPossibleRoots(Vector possibleRoots) {
        this.fPossibleRoots = possibleRoots;
    }

    public XMLDTDDescription(XMLResourceIdentifier id, String rootName) {
        this.setValues(id.getPublicId(), id.getLiteralSystemId(), id.getBaseSystemId(), id.getExpandedSystemId());
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }

    public XMLDTDDescription(String publicId, String literalId, String baseId, String expandedId, String rootName) {
        this.setValues(publicId, literalId, baseId, expandedId);
        this.fRootName = rootName;
        this.fPossibleRoots = null;
    }
}

