/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.swup.client.common.Status;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class StatusParser {
    public static Status parseAnalyzeMessages(String messages) {
        Status theStatus = new Status();
        StringTokenizer st = new StringTokenizer(messages, "\n");
        block2: while (st.hasMoreTokens()) {
            String line = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(line, " ");
            while (st2.hasMoreTokens()) {
                try {
                    if (!st2.nextToken().equals("STATUS")) continue block2;
                    String subOp = st2.nextToken();
                    if (!st2.nextToken().equals("END") || !subOp.equals("ANALYZE") && !subOp.equals("DOWNLOAD_PATCHDB") && !subOp.equals("DOWNLOAD_DETECTORS")) continue block2;
                    String completionCode = st2.nextToken();
                    st2.nextToken("\"");
                    String completionMsg = st2.nextToken("\"").trim();
                    Vector<String> params = new Vector<String>();
                    while (st2.hasMoreTokens()) {
                        st2.nextToken("\"");
                        if (!st2.hasMoreTokens()) continue;
                        params.addElement(st2.nextToken("\"").trim());
                    }
                    for (int i = 0; i < params.size(); ++i) {
                        String toReplace = "{" + i + "}";
                        completionMsg = StatusParser.replace(completionMsg, toReplace, (String)params.elementAt(i));
                    }
                    theStatus.setSubOp(subOp);
                    theStatus.setCompletionCode(completionCode);
                    theStatus.setCompletionMessage(completionMsg);
                    theStatus.setUMStatus(StatusParser.translateCode(completionCode));
                }
                catch (NoSuchElementException nsee) {
                    NoSuchElementException newExc = new NoSuchElementException(nsee.getMessage() + ": " + line);
                    newExc.setStackTrace(nsee.getStackTrace());
                    newExc.printStackTrace();
                    continue block2;
                }
            }
        }
        return theStatus;
    }

    public static Status[] parseMessages(String[] updateIDs, String messages) {
        Vector<Status> statuses = new Vector<Status>();
        for (int i = 0; i < updateIDs.length; ++i) {
            Status aStatus = new Status();
            aStatus.setUpdateID(updateIDs[i].substring(0, 6));
            statuses.addElement(aStatus);
        }
        StringTokenizer st = new StringTokenizer(messages, "\n");
        block3: while (st.hasMoreTokens()) {
            String line = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(line, " ");
            while (st2.hasMoreTokens()) {
                try {
                    int i;
                    if (!st2.nextToken().equals("STATUS")) continue block3;
                    String subOp = st2.nextToken();
                    if (!st2.nextToken().equals("END")) continue block3;
                    String patchID = "";
                    if (!(subOp.equals("ANALYZE") || subOp.equals("DOWNLOAD_PATCHDB") || subOp.equals("DOWNLOAD_DETECTORS"))) {
                        patchID = st2.nextToken().substring(0, 6);
                    }
                    String completionCode = st2.nextToken();
                    st2.nextToken("\"");
                    String completionMsg = st2.nextToken("\"").trim();
                    Vector<String> params = new Vector<String>();
                    while (st2.hasMoreTokens()) {
                        st2.nextToken("\"");
                        if (!st2.hasMoreTokens()) continue;
                        params.addElement(st2.nextToken("\"").trim());
                    }
                    for (i = 0; i < params.size(); ++i) {
                        String toReplace = "{" + i + "}";
                        completionMsg = StatusParser.replace(completionMsg, toReplace, (String)params.elementAt(i));
                    }
                    for (i = 0; i < statuses.size() && !completionCode.equals("PATCH_SEQUENCER.0") && !completionCode.equals("DOWNLOAD_PATCH.0"); ++i) {
                        if (!(((Status)statuses.elementAt(i)).getUpdateID().equals(patchID) || subOp.equals("ANALYZE") && StatusParser.translateCode(completionCode) != 0 || subOp.equals("DOWNLOAD_PATCHDB") && StatusParser.translateCode(completionCode) != 0) && (!subOp.equals("DOWNLOAD_DETECTORS") || StatusParser.translateCode(completionCode) == 0)) continue;
                        ((Status)statuses.elementAt(i)).setSubOp(subOp);
                        ((Status)statuses.elementAt(i)).setCompletionCode(completionCode);
                        ((Status)statuses.elementAt(i)).setCompletionMessage(completionMsg);
                        ((Status)statuses.elementAt(i)).setUMStatus(StatusParser.translateCode(completionCode));
                    }
                }
                catch (NoSuchElementException nsee) {
                    NoSuchElementException newExc = new NoSuchElementException(nsee.getMessage() + ": " + line);
                    newExc.setStackTrace(nsee.getStackTrace());
                    newExc.printStackTrace();
                    continue block3;
                }
            }
        }
        Status[] theStatuses = new Status[statuses.size()];
        for (int i = 0; i < statuses.size(); ++i) {
            theStatuses[i] = (Status)statuses.elementAt(i);
        }
        return theStatuses;
    }

    static String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    static int translateCode(String code) {
        int status = -1;
        int codeValue = Integer.parseInt(code.substring(code.indexOf(46) + 1, code.length()).trim());
        if (code.startsWith("ANALYZE")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                case 253: {
                    status = 5;
                    break;
                }
                default: {
                    status = 1;
                    break;
                }
            }
        } else if (code.startsWith("INSTALL")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                case 251: {
                    status = 2;
                    break;
                }
                case 252: {
                    status = 3;
                    break;
                }
                case 253: {
                    status = 5;
                    break;
                }
                case 254: {
                    status = 4;
                    break;
                }
                default: {
                    status = 1;
                    break;
                }
            }
        } else if (code.startsWith("REMOVE")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                case 253: {
                    status = 5;
                    break;
                }
                default: {
                    status = 1;
                    break;
                }
            }
        } else if (code.startsWith("DOWNLOAD_PATCH")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                case 253: {
                    status = 5;
                    break;
                }
                default: {
                    status = 1;
                    break;
                }
            }
        } else if (code.startsWith("PATCH_SEQUENCER")) {
            switch (codeValue) {
                default: 
            }
            status = 0;
        } else if (code.startsWith("DOWNLOAD_PATCHDB")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                default: {
                    status = 1;
                    break;
                }
            }
        } else if (code.startsWith("DOWNLOAD_DETECTORS")) {
            switch (codeValue) {
                case 0: {
                    status = 0;
                    break;
                }
                default: {
                    status = 1;
                }
            }
        }
        return status;
    }
}

