/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.common;

import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.LocalCache;
import com.sun.swup.client.common.UMData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class NAUtils {
    static final String PS_CMD = "/usr/bin/ps -p";
    static final String TOUCH_CMD = "/usr/bin/touch";
    static final String REMOVE_CMD = "/usr/bin/rm -f";
    static final String KILL_CMD = "/usr/bin/kill -9";
    static final String SWUPNOT = "/usr/bin/swupnot";
    static final String CP_CMD = "/usr/bin/cp";
    static final String LOCALANALYSIS_DIR = ".softwareupdate";
    static final String PID_FILE = "pid";
    static final String DISABLENOTIFICATION_FLAG = "disableNotification";
    static String assetId = null;
    static String localCacheDir = null;

    public static String getAssetId(boolean debug) {
        return assetId;
    }

    public static String getFullyQualifiedLocalCachePath(boolean debug) {
        if (UMData.getDebug()) {
            System.out.println("assetId=" + assetId + "|");
        }
        localCacheDir = assetId.length() == 0 ? new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + NAUtils.getHostID(debug) + File.separator) : new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + assetId + File.separator);
        if (UMData.getDebug()) {
            System.out.println("localCacheDir=" + localCacheDir + "|");
        }
        return localCacheDir;
    }

    public static void disableNotApp(boolean debug) {
        Vector<String> v = new Vector<String>();
        BufferedReader file = null;
        if (UMData.getDebug()) {
            System.out.println("---->disableNotApp()");
        }
        NAUtils.readAssetId(debug);
        NAUtils.execCmd("/usr/bin/touch " + NAUtils.getFullyQualifiedLocalCachePath(debug) + DISABLENOTIFICATION_FLAG, debug);
        try {
            String line;
            file = new BufferedReader(new FileReader(NAUtils.getFullyQualifiedLocalCachePath(debug) + PID_FILE));
            while ((line = file.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (IOException err) {
            System.out.println("IO Exception occurs while readline.");
        }
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (IOException err) {
            System.out.println("IO Exception occurs while closing file.");
            err.printStackTrace();
        }
        for (int i = 0; i < v.size(); ++i) {
            NAUtils.execCmd("/usr/bin/kill -9 " + (String)v.elementAt(i), debug);
        }
    }

    public static boolean isNotAppEnabled(boolean debug) {
        File disNotAppFile;
        if (UMData.getDebug()) {
            System.out.println("---->isNotAppEnabled()");
        }
        NAUtils.readAssetId(debug);
        String disNotAppFlag = new String(NAUtils.getFullyQualifiedLocalCachePath(debug) + DISABLENOTIFICATION_FLAG);
        if (UMData.getDebug()) {
            System.out.println("isNotAppEnabled(): disNotAppFlag=" + disNotAppFlag);
        }
        try {
            disNotAppFile = new File(disNotAppFlag);
            if (UMData.getDebug()) {
                System.out.println("isNotAppEnabled(): new disNotAppFlag successful");
            }
        }
        catch (Exception err) {
            System.out.println("Exception occurs while opening file.");
            err.printStackTrace();
            return false;
        }
        return !disNotAppFile.exists();
    }

    public static boolean isNotAppRunning(boolean debug) {
        boolean naRunning = false;
        Vector<String> v = new Vector<String>();
        BufferedReader file = null;
        if (UMData.getDebug()) {
            System.out.println("---->isNotAppRunning()");
        }
        NAUtils.readAssetId(debug);
        try {
            String line;
            file = new BufferedReader(new FileReader(NAUtils.getFullyQualifiedLocalCachePath(debug) + PID_FILE));
            while ((line = file.readLine()) != null) {
                v.addElement(line);
            }
        }
        catch (IOException err) {
            System.out.println("IO Exception while reading pid file.");
            err.printStackTrace();
        }
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (IOException err) {
            System.out.println("IO Exception while closing pid file.");
            err.printStackTrace();
        }
        for (int i = 0; i < v.size(); ++i) {
            String cmd = "/usr/bin/ps -p " + (String)v.elementAt(i);
            if (UMData.getDebug()) {
                System.out.println("string=" + cmd + "|");
            }
            ExecuteCommand exCmd = new ExecuteCommand(cmd);
            exCmd.setCollectOutput(true);
            exCmd.setOutputType(1);
            String cmdOut = null;
            int cmdRes = 0;
            try {
                exCmd.execute();
                cmdOut = exCmd.getOutput();
                cmdRes = exCmd.getResult();
                if (UMData.getDebug()) {
                    System.out.println("cmdOut=" + cmdOut + "|");
                    System.out.println("cmdRes=" + cmdRes + "|");
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (cmdRes == 0) {
                naRunning = true;
                if (!UMData.getDebug()) continue;
                System.out.println("found the NotApps process.");
                continue;
            }
            if (!UMData.getDebug()) continue;
            System.out.println("find no NotApps process.");
        }
        return naRunning;
    }

    public static boolean execCmd(String cmd, boolean debug) {
        if (UMData.getDebug()) {
            System.out.println("execCmd: cmd = " + cmd);
        }
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception err) {
            System.out.println("error executing " + cmd);
            err.printStackTrace();
            return false;
        }
        return true;
    }

    public static void enableNotApp(boolean debug) {
        if (UMData.getDebug()) {
            System.out.println("---->enableNotApp()");
        }
        NAUtils.readAssetId(debug);
        NAUtils.execCmd("/usr/bin/rm -f " + NAUtils.getFullyQualifiedLocalCachePath(debug) + DISABLENOTIFICATION_FLAG, debug);
        NAUtils.startNotApp(debug);
    }

    public static void startNotApp(boolean debug) {
        if (UMData.getDebug()) {
            System.out.println("---->startNotApp()");
        }
        NAUtils.execCmd(SWUPNOT, debug);
    }

    public static String getHomeDirectory(boolean debug) {
        String hDir = System.getProperty("user.home");
        if (UMData.getDebug()) {
            System.out.println("$HOME Directory=" + hDir);
        }
        return hDir;
    }

    public static String getHostID(boolean debug) {
        ExecuteCommand ec = new ExecuteCommand("/usr/bin/hostid");
        ec.setCollectOutput(true);
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            return null;
        }
        String cmdOutput = ec.getOutput();
        int cmdResult = ec.getResult();
        if (UMData.getDebug()) {
            System.out.println("cmdOutput=" + cmdOutput);
        }
        return cmdOutput.trim();
    }

    public static void copyPidFromHost2AssetidDir(boolean debug) {
        NAUtils.readAssetId(debug);
        if (assetId.length() != 0) {
            String fromDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + NAUtils.getHostID(debug) + File.separator);
            String toDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + assetId + File.separator);
            if (LocalCache.testAndCreateDir(toDir, debug)) {
                NAUtils.execCmd("/usr/bin/cp " + fromDir + "pid " + toDir + PID_FILE, debug);
            }
        } else {
            System.out.println("copyPidFromHost2AssetidDir: something wrong here, no assetId");
        }
    }

    public static void copyPidFromAssetid2HostDir(String assetId, boolean debug) {
        if (assetId.length() != 0) {
            String fromDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + assetId + File.separator);
            String toDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + NAUtils.getHostID(debug) + File.separator);
            if (LocalCache.testAndCreateDir(toDir, debug)) {
                NAUtils.execCmd("/usr/bin/cp " + fromDir + "pid " + toDir + PID_FILE, debug);
            }
        } else {
            System.out.println("copyPidFromAssetid2HostDir: something wrong here, no assetId");
        }
    }

    public static void copyPidFromAssetid2HostDir(boolean debug) {
        NAUtils.readAssetId(debug);
        if (assetId.length() != 0) {
            String fromDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + assetId + File.separator);
            String toDir = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + NAUtils.getHostID(debug) + File.separator);
            if (LocalCache.testAndCreateDir(toDir, debug)) {
                NAUtils.execCmd("/usr/bin/cp " + fromDir + "pid " + toDir + PID_FILE, debug);
            }
        } else {
            System.out.println("copyPidFromAssetid2HostDir: something wrong here, no assetId");
        }
    }

    public static void readAssetId(boolean debug) {
        String pAssetId = null;
        if (assetId != null) {
            pAssetId = assetId;
            if (UMData.getDebug()) {
                System.out.println("readAssetId: pAssetId=" + pAssetId);
            }
        }
        assetId = CCRUtils.getCCRValue("cns.assetid");
        if (UMData.getDebug()) {
            System.out.println("readAssetId: new assetId=" + assetId);
        }
        if (assetId.length() > 0 && assetId.charAt(0) == '-') {
            assetId = new String("N" + assetId.substring(1, assetId.length()));
            if (UMData.getDebug()) {
                System.out.println("NEGATIVE ASSETID, new assetId=" + assetId);
            }
        }
        String preDir = null;
        String newDir = null;
        if (pAssetId == null) {
            return;
        }
        if (pAssetId.length() != 0) {
            if (!pAssetId.equals(assetId)) {
                preDir = pAssetId;
                newDir = assetId.length() != 0 ? assetId : NAUtils.getHostID(debug);
            }
        } else {
            preDir = NAUtils.getHostID(debug);
            if (assetId.length() != 0) {
                newDir = assetId;
            }
        }
        if (preDir != null && newDir != null) {
            if (UMData.getDebug()) {
                System.out.println("readAssetId: detects a change, pAssetId=" + pAssetId + " nAssetId=" + assetId + "|newDir=" + newDir + "|preDir=" + preDir);
            }
            String preLoc = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + preDir + File.separator);
            String newLoc = new String(NAUtils.getHomeDirectory(debug) + File.separator + LOCALANALYSIS_DIR + File.separator + newDir + File.separator);
            if (LocalCache.testAndCreateDir(newLoc, debug)) {
                NAUtils.execCmd("/usr/bin/cp " + preLoc + "pid " + newLoc + PID_FILE, debug);
                if (UMData.getDebug()) {
                    System.out.println("readAssetId: just copy from " + preDir + " to " + newDir);
                }
            } else if (UMData.getDebug()) {
                System.out.println("readAssetId: cannot create newDir=" + newDir);
            }
        } else if (UMData.getDebug()) {
            System.out.println("readAssetId: no change  pAssetId=" + pAssetId + " nAssetId=" + assetId);
        }
    }
}

