/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.ndbm;

import com.sun.database.simpleadapter.common.PracticalTokenizer;
import java.lang.reflect.Field;

public class ClassXlator {
    private String fieldDelimiter;
    private Class classInStore;
    private Field[] classFields;
    private int fieldCount;
    private int currentObjectHandle = -1;

    public ClassXlator(String string, Class clazz, Field[] fieldArray) {
        this.classInStore = clazz;
        this.classFields = fieldArray;
        this.fieldCount = fieldArray.length;
        this.fieldDelimiter = string;
    }

    public int getFieldNumber(Field field) {
        for (int i = 0; i < this.fieldCount; ++i) {
            if (!field.equals(this.classFields[i])) continue;
            return i + 1;
        }
        return -1;
    }

    public String getRecordFromObject(Object object, int n) throws IllegalAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(n + this.fieldDelimiter);
        for (Field field : this.classFields) {
            String string = field.get(object).toString();
            stringBuffer.append(string + this.fieldDelimiter);
        }
        return stringBuffer.toString();
    }

    public Object getObjectFromRecord(String string) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        PracticalTokenizer practicalTokenizer = new PracticalTokenizer(this.fieldDelimiter, string);
        try {
            practicalTokenizer.nextToken();
        }
        catch (Exception exception) {
            throw new NoSuchFieldException("Could not acquire the object handle.");
        }
        this.currentObjectHandle = new Integer(practicalTokenizer.sval);
        Object t = this.classInStore.newInstance();
        int n = this.classFields.length;
        for (int i = 0; i < n; ++i) {
            try {
                practicalTokenizer.nextToken();
            }
            catch (Exception exception) {
                throw new NoSuchFieldException("Could not acquire field number " + i + ".");
            }
            String string2 = practicalTokenizer.sval;
            Field field = this.classFields[i];
            String string3 = field.getType().getName();
            try {
                if (string3.compareTo("byte") == 0) {
                    field.setByte(t, new Byte(string2));
                    continue;
                }
                if (string3.compareTo("char") == 0) {
                    field.setChar(t, string2.charAt(0));
                    continue;
                }
                if (string3.compareTo("double") == 0) {
                    field.setDouble(t, new Double(string2));
                    continue;
                }
                if (string3.compareTo("float") == 0) {
                    field.setFloat(t, new Float(string2).floatValue());
                    continue;
                }
                if (string3.compareTo("int") == 0) {
                    field.setInt(t, new Integer(string2));
                    continue;
                }
                if (string3.compareTo("long") == 0) {
                    field.setLong(t, new Long(string2));
                    continue;
                }
                if (string3.compareTo("short") == 0) {
                    field.setShort(t, new Short(string2));
                    continue;
                }
                if (string3.compareTo("java.lang.String") == 0) {
                    field.set(t, string2);
                    continue;
                }
                throw new NoSuchFieldException("Could not type field" + string3 + ".");
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return t;
    }
}

