/*
 * Decompiled with CFR 0.152.
 */
package com.sun.database.simpleadapter.memory;

import com.sun.database.simpleadapter.memory.MemoryBTree;
import com.sun.database.simpleadapter.memory.MemoryObjectStore;
import com.sun.database.simpledatabase.DatabaseError;
import com.sun.database.simpledatabase.DuplicateEntryException;
import com.sun.database.simpledatabase.NoSuchObjectException;
import com.sun.database.simpledatabase.SimpleDatabasePrtl;
import com.sun.database.util.HierarchicalField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class MemoryAdapter
extends SimpleDatabasePrtl
implements Serializable {
    private static final String sccs_id = "1.6";
    int fieldCount = 0;
    MemoryObjectStore objectStore;

    public MemoryAdapter() {
    }

    public MemoryAdapter(Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException {
        this.initializeDatabase(clazz, stringArray);
    }

    public void initializeDatabase(Class clazz, String[] stringArray) throws NoSuchFieldException, SecurityException {
        this.keyFieldStrings = stringArray;
        this.fieldCount = stringArray.length;
        if (this.fieldCount == 0) {
            throw new NoSuchFieldException("No key fields specified. Use a Vector.");
        }
        this.objectStore = new MemoryObjectStore(clazz);
        this.keyFields = new HierarchicalField[this.fieldCount];
        this.keyTree = new MemoryBTree[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            try {
                this.keyFields[i] = new HierarchicalField(stringArray[i], clazz);
                this.keyTree[i] = new MemoryBTree(this.objectStore, this.keyFields[i]);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NoSuchFieldException("Invalid key field.");
            }
        }
    }

    public void destroyDatabase() throws IllegalAccessException {
        this.objectStore.destroyObjectStore();
        this.objectStore = null;
        for (int i = 0; i < this.keyTree.length; ++i) {
            try {
                this.keyTree[i].destroyAccessMethod();
                this.keyTree[i] = null;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DatabaseError(arrayIndexOutOfBoundsException, "MemoryDatabase.destroyDatabase: field array miscalculation.");
            }
        }
    }

    public synchronized int addObject(Object object) throws DuplicateEntryException, IllegalAccessException {
        int n = this.objectStore.insertObject(object);
        for (int i = 0; i < this.keyTree.length; ++i) {
            try {
                this.keyTree[i].insertLink(n);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new DatabaseError(arrayIndexOutOfBoundsException, "MemoryDatabase.addObject: field array miscalculation.");
            }
            catch (DuplicateEntryException duplicateEntryException) {
                while (--i >= 0) {
                    try {
                        this.keyTree[i].removeLink(n);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {}
                }
                this.objectStore.removeObject(n);
                throw new DuplicateEntryException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public synchronized void deleteObject(int n) throws NoSuchObjectException, IllegalAccessException {
        try {
            for (int i = 0; i < this.keyTree.length; ++i) {
                this.keyTree[i].removeLink(n);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.objectStore.removeObject(n);
    }

    public Object findObject(int n, Object object) throws NoSuchObjectException {
        int n2 = this.keyTree[n].findLink(object);
        return this.objectStore.getObject(n2);
    }

    public Object findObject(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObject(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public int findObjectHandle(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        return this.keyTree[n].findLink(object);
    }

    public int findObjectHandle(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findObjectHandle(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public Enumeration findList(int n, Object object) throws ArrayIndexOutOfBoundsException, NoSuchObjectException {
        return this.keyTree[n].findEnumeration(object);
    }

    public Enumeration findList(String string, Object object) throws NoSuchFieldException, NoSuchObjectException {
        return this.findList(this.findMatchingKeyfield(string, this.keyFieldStrings), object);
    }

    public Object getObject(int n) {
        return this.objectStore.getObject(n);
    }

    public Enumeration elements() {
        return this.objectStore.elements();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        for (n = 0; n < this.keyFieldStrings.length; ++n) {
            objectOutputStream.writeObject(this.keyFieldStrings[n]);
        }
        for (n = 0; n < this.keyTree.length; ++n) {
            objectOutputStream.writeObject(this.keyTree[n]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        this.keyFieldStrings = new String[this.fieldCount];
        this.keyFields = new HierarchicalField[this.fieldCount];
        this.keyTree = new MemoryBTree[this.fieldCount];
        for (n = 0; n < this.fieldCount; ++n) {
            this.keyFieldStrings[n] = (String)objectInputStream.readObject();
        }
        Class clazz = this.objectStore.getClassInStore();
        for (int i = 0; i < this.fieldCount; ++i) {
            try {
                this.keyFields[i] = new HierarchicalField(this.keyFieldStrings[i], clazz);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        for (n = 0; n < this.fieldCount; ++n) {
            this.keyTree[n] = (MemoryBTree)objectInputStream.readObject();
        }
    }
}

