/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.advertisement;

import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.adapter.DataCollectorAdapter;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.util.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SystemAdvertisement
implements Cloneable {
    private static SystemAdvertisement instance = null;
    private boolean systemAdvertisementLogRequired = true;
    private static String[] envp = new String[]{"LC_ALL=C"};
    private static final String BASICREG_PKG_NAME = "SUNWbreg";
    private String BasicRegInstallDirSuffix = "/SUNWbreg/bin/sparcv9";
    private String ProbeExecutable = "/probe.sparcv9";
    private String ProbeCFName = "-cfdir";
    private String ProbeConfigDir = " -cfdir ./sparcv9";
    private String cstCollectionDriverDir = ".";
    private static final String collectGeneral = " -class General -show ";
    private static final String collectPackage = " -class Package";
    private static final String collectPatch = " -class Patch";
    private static final String collectDevices = " -class Device";
    private String collectGeneralCmd = " -class General -show ";
    private String collectPackageCmd = " -class Package";
    private String collectPatchCmd = " -class Patch";
    private String collectDevicesCmd = " -class Device";
    private String platformVersion = "";
    private String hwarch;
    private String hwvendor;
    private Object id = null;
    private String ip;
    private String name;
    private String osname;
    private String osversion;
    private String osarch;
    private String inventory;
    private String SIHostname;
    private String SISystemModel;
    private String SISerialNumber;
    private String SIHostID;
    private String SIHostAliases;
    private String SIHostAddresses;
    private String SIDnsDomain;
    private String SINisDomain;
    private String SIMacAddress;
    private String SINumCpu;
    private String SICpuType;
    private String SICpuSpeed;
    private String SIMainMemory;
    private String SITotalDiskSpace;
    private String SINumDisk;
    private String SINumCdrom;
    private String SIRomVersion;
    private String SITimeZone;
    private String SIBootTime;
    private String SISystemLocale;
    private static String MACHINE_ID = "";
    private static String PUBLIC_KEY = "";
    private static String SUBSCRIPTION_KEY = "";
    private static String COMMON_NAME = "";
    private static String ASSET_ID = "";
    private static String PORTAL_ENABLED = "";
    private static String ECR_USER_NAME = "";
    private HashMap PKGCollection = new HashMap();
    private HashMap PatchCollection = new HashMap();
    private HashMap StorageDeviceCollection = new HashMap();
    private HashMap NICCollection = new HashMap();
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$advertisement$SystemAdvertisement == null ? (class$com$sun$cns$basicreg$advertisement$SystemAdvertisement = SystemAdvertisement.class$("com.sun.cns.basicreg.advertisement.SystemAdvertisement")) : class$com$sun$cns$basicreg$advertisement$SystemAdvertisement).getName());
    private static final String ComputerSystemTag = "computer.system";
    private static final String AgentUuidAttribute = "agentUuid";
    private static String AgentUuidAttributeVal = "4c111d85-7968-11d9-b344-080020a9ed93";
    private static final String FormatVersionAttribute = "formatVersion";
    private static final String FormatVersionAttributeVal = "0.5";
    private static final String CollectedDateTimeTag = "collected.time";
    private static final String CollectedDateTimeFormatTag = "format";
    private static final String CollectedDateTimeFormatTagVal = "iso";
    private static final String SystemInformationTag = "system.information";
    private static final String OSTag = "operating.system";
    private static final String OSVersionTag = "version";
    private static final String OSNameTag = "name";
    private static final String OSarchTag = "os.arch";
    private static final String hwarchTag = "hw.arch";
    private static final String hwvendorTag = "hw.vendor";
    private static final String idTag = "ID";
    private static final String ipTag = "ip";
    private static final String nameTag = "name";
    private static final String machineTag = "br.machine.id";
    private static final String SIHostnameTag = "host.name";
    private static final String SISystemModelTag = "model";
    private static final String SISerialNumberTag = "serial.number";
    private static final String SIHostIDTag = "host.id";
    private static final String SIHostAliasesTag = "host.aliases";
    private static final String SIHostAddressesTag = "host.addresses";
    private static final String SIDnsDomainTag = "dns.domain";
    private static final String SINisDomainTag = "nis.domain";
    private static final String SIMacAddressTag = "mac.address";
    private static final String SICpuListTag = "cpu.list";
    private static final String SINumCpuTag = "populated";
    private static final String SICpuTag = "cpu";
    private static final String SINumCpuIdTag = "id";
    private static final String SICpuArchitectureTag = "cpu.architecture";
    private static final String SICpuDeviceIdTag = "cpu.device.id";
    private static final String SICpuModelTag = "cpu.model";
    private static final String SICpuSpeedTag = "cpu.speed";
    private static final String SICpuSpeedUnitsTag = "units";
    private static final String SICpuMemoryTag = "cpu.memory";
    private static final String SICpuMemoryUnitsTag = "units";
    private static final String SICpuStatusTag = "cpu.status";
    private static final String SICpuTypeTag = "cpu.type";
    private static final String SIMainMemoryTag = "memory.size";
    private static final String SIMainMemoryUnitsTag = "units";
    private static final String SIRomVersionTag = "firmware.version";
    private static final String SITimeZoneTag = "time.zone";
    private static final String SIBootTimeTag = "last.boot.time";
    private static final String SIBootTimeFormatTag = "format";
    private static final String SIBootTimeFormatTagVal = "verbatim";
    private static final String SISystemLocaleTag = "locale";
    private static final String SISystemLocaleFromTag = "from";
    private static final String SINicListConfigTag = "network.interface.config";
    private static final String SINicInterfaceTag = "network.interface";
    private static final String SINicNameTag = "name";
    private static final String SINicPrimaryTag = "primary";
    private static final String SINicIPTag = "ip";
    private static final String SINicProtocolTag = "protocol";
    private static final String SINicMacTag = "mac.address";
    private static final String SITotalDiskSpaceTag = "total.disk.space";
    private static final String SINumDiskTag = "number.disks";
    private static final String SINumCdromTag = "number.cdroms";
    private static final String SIStorageInventoryTag = "storage.inventory";
    private static final String SIStorageDeviceTag = "storage.device";
    private static final String SIStorageDeviceNameTag = "name";
    private static final String SIStorageBootPromTag = "bootprom.id";
    private static final String SIStorageFirmwareVersionTag = "firmware.version";
    private static final String SIStorageVendorTag = "vendor";
    private static final String SIStorageProductTag = "product";
    private static final String SIStorageRevisionTag = "revision";
    private static final String SIStorageSerialNumberTag = "serial.number";
    private static final String SIStorageDriveSizeTag = "drive.size";
    private static final String SIStorageDriveSizeUnitsTag = "units";
    private static final String PKGInventoryTag = "package.inventory";
    private static final String PKGTag = "package";
    private static final String PKGInstTag = "pkginst";
    private static final String PKGVersionTag = "version";
    private static final String PKGInstallDateTag = "instdate";
    private static final String PKGInstallDateFormatTag = "format";
    private static final String PKGStatusTag = "status";
    private static final String PatchInventoryTag = "patch.inventory";
    private static final String PatchTag = "patch";
    private static final String PatchIdTag = "id";
    private static final String PatchObsoletesTag = "obsoletes";
    private static final String PatchRequiresTag = "requires";
    private static final String PatchIncompatiblesTag = "incompatibles";
    private static final String PatchPackageTag = "packages";
    private static final String AccountTag = "account";
    private static final String AccountEcrUserNameTag = "ecr.user.name";
    private static final String CCRPublicKeyTag = "public.key";
    private static final String SubscriptionKeyTag = "subscription.key";
    private static final String CommonNameTag = "common.name";
    private static final String AssetIdTag = "asset.id";
    private static final String PortalEnabledTag = "swup.portal.enabled";
    private static final String PatchCollectionTag = "patches";
    private static final String[] fields = new String[]{"ID", "name", "hw.arch"};
    private String[] cpuStatusAll;
    private String[] cpuStatusDeviceIdAll;
    private DataCollectorAdapter dca = DataCollectorAdapter.getInstance();
    private CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
    static /* synthetic */ Class class$com$sun$cns$basicreg$advertisement$SystemAdvertisement;

    private SystemAdvertisement() {
        this.getInstallLocation();
        this.initNodeCollectionData();
    }

    public static SystemAdvertisement getInstance() {
        if (instance == null) {
            instance = new SystemAdvertisement();
        }
        return instance;
    }

    private String runPrivCommand(String command, Vector arguments) {
        String result = "";
        SystemAdvertisement systemAdvertisement = this;
        if (!systemAdvertisement.csmAuthAdapter.isAuthenticated()) {
            if (!this.csmAuthAdapter.authenticateUser()) {
                this.csmAuthAdapter.closeFrame();
            } else {
                CSMAuthAdapter.setAuthenticated(true);
            }
        }
        try {
            LOG.info("Running cmd := " + command + " " + arguments.toString());
            result = this.csmAuthAdapter.runCMD(command, arguments);
            LOG.info("command: " + result);
        }
        catch (Exception e) {
            LOG.severe("Cannot exec probe cmd " + command);
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public String getISO8601DateTime() {
        SimpleDateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TimeZone timeZone = TimeZone.getDefault();
        ISO8601Local.setTimeZone(timeZone);
        DecimalFormat twoDigits = new DecimalFormat("00");
        Date now = new Date();
        int offset = ISO8601Local.getTimeZone().getOffset(now.getTime());
        String sign = "+";
        if (offset < 0) {
            offset = -offset;
            sign = "-";
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 3600000) / 60000;
        String ISO8601Now = ISO8601Local.format(now) + sign + twoDigits.format(hours) + ":" + twoDigits.format(minutes);
        return ISO8601Now;
    }

    public void setHWArch(String hwarch) {
        this.hwarch = hwarch;
    }

    public void setOSArch(String osarch) {
        this.osarch = osarch;
    }

    public void setHWVendor(String hwvendor) {
        this.hwvendor = hwvendor;
    }

    public void setIP(String ip) {
        this.ip = ip;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOSName(String osname) {
        this.osname = osname;
    }

    public void setOSVersion(String osversion) {
        this.osversion = osversion;
    }

    public void setSISystemModel(String SISystemModel) {
        this.SISystemModel = SISystemModel;
    }

    public void setSISerialNumber(String SISerialNumber) {
        this.SISerialNumber = SISerialNumber;
    }

    public void setSIHostID(String SIHostID) {
        this.SIHostID = SIHostID;
    }

    public void setSIHostname(String SIHostname) {
        this.SIHostname = SIHostname;
    }

    public void setSIHostAliases(String SIHostAliases) {
        this.SIHostAliases = SIHostAliases;
    }

    public void setSIHostAddresses(String SIHostAddresses) {
        this.SIHostAddresses = SIHostAddresses;
    }

    public void setSIDnsDomain(String SIDnsDomain) {
        this.SIDnsDomain = SIDnsDomain;
    }

    public void setSINisDomain(String SINisDomain) {
        this.SINisDomain = SINisDomain;
    }

    public void setSIMacAddress(String SIMacAddress) {
        this.SIMacAddress = SIMacAddress;
    }

    public void setSINumCpu(String SINumCpu) {
        this.SINumCpu = SINumCpu;
    }

    public void setSICpuInfo(String[] SICpuInfo) {
        this.cpuStatusAll = SICpuInfo;
    }

    public void setSICpuType(String SICpuType) {
        this.SICpuType = SICpuType;
    }

    public void setSICpuSpeed(String SICpuSpeed) {
        this.SICpuSpeed = SICpuSpeed;
    }

    public void setSIMainMemory(String SIMainMemory) {
        this.SIMainMemory = SIMainMemory;
    }

    public void setSITotalDiskSpace(String SITotalDiskSpace) {
        this.SITotalDiskSpace = SITotalDiskSpace;
    }

    public void setSINumDisk(String SINumDisk) {
        this.SINumDisk = SINumDisk;
    }

    public void setSINumCdrom(String SINumCdrom) {
        this.SINumCdrom = SINumCdrom;
    }

    public void setSIRomVersion(String SIRomVersion) {
        this.SIRomVersion = SIRomVersion;
    }

    public void setSITimeZone(String SITimeZone) {
        this.SITimeZone = SITimeZone;
    }

    public void setSIBootTime(String SIBootTime) {
        this.SIBootTime = SIBootTime;
    }

    public void setSISystemLocale(String SISystemLocale) {
        this.SISystemLocale = SISystemLocale;
    }

    public void setSWInventory(String inventory) {
        this.inventory = inventory;
    }

    public void setCCRPublicKey(String publicKey) {
        PUBLIC_KEY = publicKey;
    }

    public void setSubscriptionKey(String subscriptionKey) {
        SUBSCRIPTION_KEY = subscriptionKey;
    }

    public void setCommonName(String commonName) {
        COMMON_NAME = commonName;
    }

    public void setAssetId(String assetId) {
        ASSET_ID = assetId;
    }

    public void setPortalEnabled(String portalEnabled) {
        PORTAL_ENABLED = portalEnabled;
    }

    public void setEcrUserName(String ecrUserName) {
        ECR_USER_NAME = ecrUserName;
    }

    public void setPKGCollection(HashMap PKGCollection) {
        this.PKGCollection = PKGCollection;
    }

    public void setPatchCollection(HashMap PatchCollection) {
        this.PatchCollection = PatchCollection;
    }

    public static void setAgentUUId(String agentUUID) {
        AgentUuidAttributeVal = agentUUID;
    }

    public synchronized Document getDocument(boolean partialDoc) {
        String value;
        String name;
        Element computersystem = new Element(ComputerSystemTag);
        Document adv = new Document(computersystem, new DocType("jxta:System"));
        computersystem.setAttribute(FormatVersionAttribute, FormatVersionAttributeVal);
        computersystem.setAttribute(AgentUuidAttribute, AgentUuidAttributeVal);
        Element e = new Element(CollectedDateTimeTag);
        e.addContent(this.getISO8601DateTime());
        computersystem.addContent((Content)e);
        e.setAttribute("format", CollectedDateTimeFormatTagVal);
        Element sysinfo = new Element(SystemInformationTag);
        computersystem.addContent((Content)sysinfo);
        e = new Element(CommonNameTag);
        e.addContent(this.getCommonName().trim());
        sysinfo.addContent((Content)e);
        if (!partialDoc) {
            e = new Element(SIDnsDomainTag);
            e.addContent(this.getSIDnsDomain().trim());
            sysinfo.addContent((Content)e);
        }
        if (!partialDoc) {
            e = new Element(SINisDomainTag);
            e.addContent(this.getSINisDomain().trim());
            sysinfo.addContent((Content)e);
        }
        if (!partialDoc) {
            e = new Element("firmware.version");
            e.addContent(this.getSIRomVersion().trim());
            sysinfo.addContent((Content)e);
        }
        e = new Element(SIHostIDTag);
        e.addContent(this.getSIHostID().trim());
        sysinfo.addContent((Content)e);
        e = new Element(SIHostnameTag);
        e.addContent(this.getSIHostname().trim());
        sysinfo.addContent((Content)e);
        e = new Element(OSTag);
        sysinfo.addContent((Content)e);
        Element tmp = new Element("version");
        tmp.addContent(this.getOSVersion().trim());
        e.addContent((Content)tmp);
        tmp = new Element("name");
        tmp.addContent(this.getOSName().trim());
        e.addContent((Content)tmp);
        e = new Element(AssetIdTag);
        if (this.getAssetId().length() != 0) {
            e.addContent(this.getAssetId().trim());
        }
        sysinfo.addContent((Content)e);
        if (!partialDoc) {
            e = new Element(SISystemLocaleTag);
            e.setAttribute(SISystemLocaleFromTag, "LC_ALL");
            String newLocale = this.getSISystemLocale().replaceAll("LC_ALL", "");
            newLocale = newLocale.replaceAll("-", "");
            e.addContent(newLocale.trim());
            sysinfo.addContent((Content)e);
        }
        if (!partialDoc) {
            e = new Element(SIBootTimeTag);
            e.addContent(this.getSIBootTime().trim());
            sysinfo.addContent((Content)e);
            e.setAttribute("format", SIBootTimeFormatTagVal);
        }
        int iIndex = this.getSIMainMemory().indexOf(32);
        try {
            name = this.getSIMainMemory().substring(iIndex).trim();
        }
        catch (Exception exa) {
            name = "";
        }
        try {
            value = this.getSIMainMemory().substring(0, iIndex).trim();
        }
        catch (Exception exb) {
            value = "";
        }
        e = new Element(SIMainMemoryTag);
        e.addContent(value);
        sysinfo.addContent((Content)e);
        e.setAttribute("units", name);
        e = new Element(SISystemModelTag);
        e.addContent(this.getSISystemModel().trim());
        sysinfo.addContent((Content)e);
        e = new Element(CCRPublicKeyTag);
        e.addContent(this.getCCRPublicKey().trim());
        sysinfo.addContent((Content)e);
        e = new Element("serial.number");
        e.addContent(this.getSISerialNumber().trim());
        sysinfo.addContent((Content)e);
        e = new Element(SubscriptionKeyTag);
        e.addContent(this.getSubscriptionKey().trim());
        sysinfo.addContent((Content)e);
        int i = 0;
        boolean x = false;
        boolean y = false;
        int cpuNum = 0;
        int cpuStatus = 0;
        int cpuArchitecture = 0;
        int cpuSpeed = 0;
        int cpuSpeedUnits = 0;
        String cpuInfo = "";
        String cpuDeviceId = "";
        String cpuModel = this.getSISystemModel().trim();
        int cpuIndexType = cpuModel.indexOf("UltraSPARC");
        if (cpuIndexType == -1) {
            cpuIndexType = cpuModel.indexOf("SPARC");
        }
        if (cpuIndexType > -1) {
            String tmpString = cpuModel.substring(cpuIndexType);
            StringBuffer sb = new StringBuffer();
            char myChar = ' ';
            for (int count = 0; count < tmpString.length() && !Character.isWhitespace(myChar = (char)tmpString.charAt(count)); ++count) {
                if (!Character.isLetter(myChar) && myChar != '-' && myChar != 43) continue;
                sb.append(myChar);
            }
            cpuModel = sb.toString();
        } else {
            cpuModel = "NA";
        }
        e = new Element(SICpuListTag);
        sysinfo.addContent((Content)e);
        e.setAttribute(SINumCpuTag, this.getSINumCpu().trim());
        for (i = 0; i < Integer.parseInt(this.getSINumCpu()); ++i) {
            LOG.info("getSINumCpu as int: " + i);
            Element cpu = new Element(SICpuTag);
            e.addContent((Content)cpu);
            cpuInfo = this.cpuStatusAll[i];
            LOG.info(">>> cpuinfo = >>> " + cpuInfo);
            cpuNum = cpuInfo.indexOf("Num:");
            cpuArchitecture = cpuInfo.indexOf("Architecture:");
            cpuStatus = cpuInfo.indexOf("Status:");
            cpuSpeed = cpuInfo.indexOf("Speed:");
            cpuSpeedUnits = cpuInfo.indexOf("Units:");
            try {
                cpu.setAttribute("id", cpuInfo.substring(cpuNum + 4, cpuArchitecture).trim());
            }
            catch (Exception ex1) {
                tmp.addContent("");
            }
            tmp = new Element(SICpuArchitectureTag);
            try {
                tmp.addContent(cpuInfo.substring(cpuArchitecture + 13, cpuStatus).trim());
            }
            catch (Exception ex1) {
                tmp.addContent("");
            }
            cpu.addContent((Content)tmp);
            tmp = new Element(SICpuDeviceIdTag);
            cpuDeviceId = this.cpuStatusDeviceIdAll[i];
            try {
                tmp.addContent(cpuDeviceId.substring(cpuDeviceId.indexOf(9), cpuDeviceId.length()).trim());
            }
            catch (Exception ex2) {
                tmp.addContent("");
            }
            cpu.addContent((Content)tmp);
            tmp = new Element(SICpuModelTag);
            tmp.addContent(cpuModel);
            cpu.addContent((Content)tmp);
            tmp = new Element(SICpuSpeedTag);
            try {
                tmp.addContent(cpuInfo.substring(cpuSpeed + 6, cpuSpeedUnits).trim());
            }
            catch (Exception ex3) {
                tmp.addContent("");
            }
            cpu.addContent((Content)tmp);
            try {
                tmp.setAttribute("units", cpuInfo.substring(cpuSpeedUnits + 6, cpuInfo.length()).trim());
            }
            catch (Exception ex4) {
                tmp.setAttribute("units", "");
            }
            tmp = new Element(SICpuMemoryTag);
            tmp.addContent("");
            cpu.addContent((Content)tmp);
            tmp.setAttribute("units", "");
            tmp = new Element(SICpuStatusTag);
            try {
                tmp.addContent(cpuInfo.substring(cpuStatus + 7, cpuSpeed).trim());
            }
            catch (Exception ex5) {
                tmp.addContent("");
            }
            cpu.addContent((Content)tmp);
        }
        Set NICSet = this.NICCollection.entrySet();
        Iterator it = NICSet.iterator();
        int index = -1;
        int indexOfTab = -1;
        String keyValue = "";
        String primary = "";
        String ipv4 = "";
        String ipv6 = "";
        String mac = "";
        Element nicInterfaceConfig = new Element(SINicListConfigTag);
        sysinfo.addContent((Content)nicInterfaceConfig);
        LOG.info("Num NIC records: " + NICSet.size());
        while (it.hasNext()) {
            Element nicInterface = new Element(SINicInterfaceTag);
            nicInterfaceConfig.addContent((Content)nicInterface);
            Map.Entry me = it.next();
            nicInterface.setAttribute("name", me.getKey().toString());
            keyValue = (String)me.getValue();
            index = keyValue.indexOf("primary:");
            if (index != -1) {
                indexOfTab = keyValue.indexOf(9, index);
                try {
                    primary = keyValue.substring(index + 8, indexOfTab).trim();
                }
                catch (Exception ex6) {
                    primary = "";
                }
            } else {
                primary = "";
            }
            nicInterface.setAttribute(SINicPrimaryTag, primary);
            index = keyValue.indexOf("v4:");
            if (index != -1) {
                indexOfTab = keyValue.indexOf(9, index);
                try {
                    ipv4 = keyValue.substring(index + 3, indexOfTab).trim();
                }
                catch (Exception ex7) {
                    ipv4 = "";
                }
            } else {
                ipv4 = "";
            }
            e = new Element("ip");
            e.setAttribute(SINicProtocolTag, "v4");
            e.addContent(ipv4);
            nicInterface.addContent((Content)e);
            index = keyValue.indexOf("v6:");
            if (index != -1) {
                try {
                    ipv6 = keyValue.substring(index + 3, keyValue.length()).trim();
                }
                catch (Exception ex8) {
                    ipv6 = "";
                }
            } else {
                ipv6 = "";
            }
            e = new Element("ip");
            e.setAttribute(SINicProtocolTag, "v6");
            e.addContent(ipv6);
            nicInterface.addContent((Content)e);
            index = keyValue.indexOf("mac:");
            if (index != -1) {
                indexOfTab = keyValue.indexOf(9, index);
                try {
                    mac = keyValue.substring(index + 4, indexOfTab).trim();
                }
                catch (Exception ex9) {
                    mac = "";
                }
            } else {
                mac = "";
            }
            e = new Element("mac.address");
            e.addContent(mac);
            nicInterface.addContent((Content)e);
        }
        if (!partialDoc) {
            Set StorageSet = this.StorageDeviceCollection.entrySet();
            it = StorageSet.iterator();
            keyValue = "";
            String bootpromId = "";
            String firmwareVer = "";
            String vendor = "";
            String product = "";
            String revision = "";
            String serialNum = "";
            String driveSize = "";
            String driveSizeUnits = "";
            Element storageinventory = new Element(SIStorageInventoryTag);
            sysinfo.addContent((Content)storageinventory);
            while (it.hasNext()) {
                Element storagedevice = new Element(SIStorageDeviceTag);
                storageinventory.addContent((Content)storagedevice);
                Map.Entry me = it.next();
                storagedevice.setAttribute("name", me.getKey().toString());
                keyValue = (String)me.getValue();
                e = new Element(SIStorageBootPromTag);
                storagedevice.addContent((Content)e);
                e = new Element("firmware.version");
                e.addContent("");
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9);
                    try {
                        vendor = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex10) {
                        vendor = "";
                    }
                } else {
                    vendor = "";
                }
                e = new Element(SIStorageVendorTag);
                e.addContent(vendor);
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58, indexOfTab);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9, index);
                    try {
                        product = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex11) {
                        product = "";
                    }
                } else {
                    product = "";
                }
                e = new Element(SIStorageProductTag);
                e.addContent(product);
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58, indexOfTab);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9, index);
                    try {
                        revision = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex12) {
                        revision = "";
                    }
                } else {
                    revision = "";
                }
                e = new Element(SIStorageRevisionTag);
                e.addContent(revision);
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58, indexOfTab);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9, index);
                    try {
                        serialNum = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex13) {
                        serialNum = "";
                    }
                } else {
                    serialNum = "";
                }
                e = new Element("serial.number");
                e.addContent(serialNum);
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58, indexOfTab);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9, index);
                    try {
                        driveSize = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex14) {
                        driveSize = "";
                    }
                } else {
                    driveSize = "";
                }
                e = new Element(SIStorageDriveSizeTag);
                e.addContent(driveSize);
                storagedevice.addContent((Content)e);
                index = keyValue.indexOf(58, indexOfTab);
                if (index != -1) {
                    try {
                        driveSizeUnits = keyValue.substring(index + 1, keyValue.length()).trim();
                    }
                    catch (Exception ex15) {
                        driveSizeUnits = "";
                    }
                } else {
                    driveSizeUnits = "";
                }
                e.setAttribute("units", driveSizeUnits);
            }
        }
        if (!partialDoc) {
            Element pkginv = new Element(PKGInventoryTag);
            sysinfo.addContent((Content)pkginv);
            Set pkgSet = this.PKGCollection.entrySet();
            it = pkgSet.iterator();
            String version = "";
            String instdate = "";
            String status = "";
            while (it.hasNext()) {
                Element pkg = new Element(PKGTag);
                pkginv.addContent((Content)pkg);
                Map.Entry me = it.next();
                pkg.setAttribute(PKGInstTag, me.getKey().toString());
                keyValue = (String)me.getValue();
                index = keyValue.indexOf(58);
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9);
                    try {
                        version = keyValue.substring(index + 1, indexOfTab).trim();
                    }
                    catch (Exception ex16) {
                        version = "";
                    }
                } else {
                    version = "";
                }
                e = new Element("version");
                e.addContent(version);
                pkg.addContent((Content)e);
                index = keyValue.indexOf("INSTDATE:");
                if (index != -1) {
                    indexOfTab = keyValue.indexOf(9, index);
                    try {
                        instdate = keyValue.substring(index + 9, indexOfTab).trim();
                    }
                    catch (Exception ex17) {
                        instdate = "";
                    }
                } else {
                    instdate = "";
                }
                e = new Element(PKGInstallDateTag);
                e.addContent(instdate);
                pkg.addContent((Content)e);
                e.setAttribute("format", SIBootTimeFormatTagVal);
                index = keyValue.lastIndexOf(58);
                if (index != -1) {
                    try {
                        status = keyValue.substring(index + 1, keyValue.length()).trim();
                    }
                    catch (Exception ex18) {
                        status = "";
                    }
                } else {
                    status = "";
                }
                e = new Element(PKGStatusTag);
                e.addContent(status);
                pkg.addContent((Content)e);
            }
            Element patchinv = new Element(PatchInventoryTag);
            keyValue = "";
            Object key = null;
            String OBSOLETES = "Obsoletes: ";
            String REQUIRES = "Requires: ";
            String INCOMPATIBLES = "Incompatibles: ";
            String PACKAGES = "Packages: ";
            Set patchSet = this.PatchCollection.entrySet();
            it = patchSet.iterator();
            patchinv = new Element(PatchInventoryTag);
            sysinfo.addContent((Content)patchinv);
            boolean count = false;
            while (it.hasNext()) {
                Element patch = new Element(PatchTag);
                patchinv.addContent((Content)patch);
                Map.Entry me = it.next();
                patch.setAttribute("id", me.getKey().toString());
                keyValue = (String)me.getValue();
                int indexOfStart = keyValue.indexOf(OBSOLETES) + OBSOLETES.length();
                int indexOfEnd = keyValue.indexOf(REQUIRES);
                if (indexOfStart + 1 != indexOfEnd) {
                    e = new Element(PatchObsoletesTag);
                    try {
                        e.addContent(keyValue.substring(indexOfStart, indexOfEnd - 1).trim());
                    }
                    catch (Exception ex19) {
                        e.addContent("");
                    }
                } else {
                    e = new Element(PatchObsoletesTag);
                }
                patch.addContent((Content)e);
                indexOfStart = keyValue.indexOf(REQUIRES) + REQUIRES.length();
                indexOfEnd = keyValue.indexOf(INCOMPATIBLES);
                if (indexOfStart + 1 != indexOfEnd) {
                    e = new Element(PatchRequiresTag);
                    try {
                        e.addContent(keyValue.substring(indexOfStart, indexOfEnd - 1).trim());
                    }
                    catch (Exception ex20) {
                        e.addContent("");
                    }
                } else {
                    e = new Element(PatchRequiresTag);
                }
                patch.addContent((Content)e);
                indexOfStart = keyValue.indexOf(INCOMPATIBLES) + INCOMPATIBLES.length();
                indexOfEnd = keyValue.indexOf(PACKAGES);
                if (indexOfStart + 1 != indexOfEnd) {
                    e = new Element(PatchIncompatiblesTag);
                    try {
                        e.addContent(keyValue.substring(indexOfStart, indexOfEnd - 1).trim());
                    }
                    catch (Exception ex21) {
                        e.addContent("");
                    }
                } else {
                    e = new Element(PatchIncompatiblesTag);
                }
                patch.addContent((Content)e);
                indexOfStart = keyValue.indexOf(PACKAGES) + PACKAGES.length();
                indexOfEnd = keyValue.length();
                if (indexOfStart + 1 != indexOfEnd) {
                    e = new Element(PatchPackageTag);
                    try {
                        e.addContent(keyValue.substring(indexOfStart, indexOfEnd).trim());
                    }
                    catch (Exception ex22) {
                        e.addContent("");
                    }
                } else {
                    e = new Element(PatchPackageTag);
                }
                patch.addContent((Content)e);
            }
        }
        e = new Element(PortalEnabledTag);
        e.addContent(this.getPortalEnabled().trim());
        sysinfo.addContent((Content)e);
        e = new Element(AccountTag);
        computersystem.addContent((Content)e);
        tmp = new Element(AccountEcrUserNameTag);
        tmp.addContent(this.getEcrUserName());
        e.addContent((Content)tmp);
        Format f = Format.getPrettyFormat();
        f.setLineSeparator("\n");
        XMLOutputter xout = new XMLOutputter(f);
        if (this.systemAdvertisementLogRequired) {
            LOG.info(xout.outputString(adv));
            this.systemAdvertisementLogRequired = false;
        }
        return adv;
    }

    public String getHWArch() {
        if (this.hwarch == null) {
            this.hwarch = "";
        }
        return this.hwarch;
    }

    public String getOSArch() {
        if (this.osarch == null) {
            this.osarch = "";
        }
        return this.osarch;
    }

    public String getHWVendor() {
        if (this.hwvendor == null) {
            this.hwvendor = "";
        }
        return this.hwvendor;
    }

    public Object getID() {
        return this.id == null ? null : this.id;
    }

    public String getIP() {
        if (this.ip == null) {
            this.ip = "";
        }
        return this.ip;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public String getOSName() {
        if (this.osname == null) {
            this.osname = "";
        }
        return this.osname;
    }

    public String getSWInventory() {
        if (this.inventory == null) {
            this.inventory = "";
        }
        return this.inventory;
    }

    public String getSIHostname() {
        if (this.SIHostname == null) {
            this.SIHostname = "";
        }
        return this.SIHostname;
    }

    public String getSISystemModel() {
        if (this.SISystemModel == null) {
            this.SISystemModel = "";
        }
        return this.SISystemModel;
    }

    public String getSISerialNumber() {
        if (this.SISerialNumber == null) {
            this.SISerialNumber = "NONE";
        }
        return this.SISerialNumber;
    }

    public String getSIHostID() {
        if (this.SIHostID == null) {
            this.SIHostID = "";
        }
        return this.SIHostID;
    }

    public String getSIHostAliases() {
        if (this.SIHostAliases == null) {
            this.SIHostAliases = "";
        }
        return this.SIHostAliases;
    }

    public String getSIHostAddresses() {
        if (this.SIHostAddresses == null) {
            this.SIHostAddresses = "";
        }
        return this.SIHostAddresses;
    }

    public String getSIDnsDomain() {
        if (this.SIDnsDomain == null) {
            this.SIDnsDomain = "";
        }
        return this.SIDnsDomain;
    }

    public String getSINisDomain() {
        if (this.SINisDomain == null) {
            this.SINisDomain = "";
        }
        return this.SINisDomain;
    }

    public String getSIMacAddress() {
        if (this.SIMacAddress == null) {
            this.SIMacAddress = "";
        }
        return this.SIMacAddress;
    }

    public String getSINumCpu() {
        if (this.SINumCpu == null) {
            this.SINumCpu = "";
        }
        return this.SINumCpu;
    }

    public String[] getSICpuInfo() {
        if (this.cpuStatusAll == null) {
            this.cpuStatusAll[0] = "error";
        }
        return this.cpuStatusAll;
    }

    public String getSICpuType() {
        if (this.SICpuType == null) {
            this.SICpuType = "";
        }
        return this.SICpuType;
    }

    public String getSICpuSpeed() {
        if (this.SICpuSpeed == null) {
            this.SICpuSpeed = "";
        }
        return this.SICpuSpeed;
    }

    public String getSIMainMemory() {
        if (this.SIMainMemory == null) {
            this.SIMainMemory = "";
        }
        return this.SIMainMemory;
    }

    public String getSITotalDiskSpace() {
        if (this.SITotalDiskSpace == null) {
            this.SITotalDiskSpace = "";
        }
        return this.SITotalDiskSpace;
    }

    public String getSINumDisk() {
        if (this.SINumDisk == null) {
            this.SINumDisk = "";
        }
        return this.SINumDisk;
    }

    public String getSINumCdrom() {
        if (this.SINumCdrom == null) {
            this.SINumCdrom = "";
        }
        return this.SINumCdrom;
    }

    public String getSIRomVersion() {
        if (this.SIRomVersion == null) {
            this.SIRomVersion = "";
        }
        return this.SIRomVersion;
    }

    public String getSITimeZone() {
        if (this.SITimeZone == null) {
            this.SITimeZone = "";
        }
        return this.SITimeZone;
    }

    public String getSIBootTime() {
        if (this.SIBootTime == null) {
            this.SIBootTime = "";
        }
        return this.SIBootTime;
    }

    public String getSISystemLocale() {
        if (this.SISystemLocale == null) {
            this.SISystemLocale = "";
        }
        return this.SISystemLocale;
    }

    public HashMap getPKGCollection() {
        if (this.PKGCollection == null) {
            this.PKGCollection = new HashMap();
        }
        return this.PKGCollection;
    }

    public String getOSVersion() {
        if (this.osversion == null) {
            this.osversion = "";
        }
        return this.osversion;
    }

    public String getCCRPublicKey() {
        if (PUBLIC_KEY == null) {
            PUBLIC_KEY = "";
        }
        return PUBLIC_KEY;
    }

    public String getSubscriptionKey() {
        if (SUBSCRIPTION_KEY == null) {
            SUBSCRIPTION_KEY = "";
        }
        return SUBSCRIPTION_KEY;
    }

    public String getCommonName() {
        if (COMMON_NAME == null) {
            COMMON_NAME = "";
        }
        return COMMON_NAME;
    }

    public String getAssetId() {
        if (ASSET_ID == null) {
            ASSET_ID = "";
        }
        return ASSET_ID;
    }

    public String getPortalEnabled() {
        if (PORTAL_ENABLED == null) {
            PORTAL_ENABLED = "";
        }
        return PORTAL_ENABLED;
    }

    public String getEcrUserName() {
        if (ECR_USER_NAME == null) {
            ECR_USER_NAME = "";
        }
        return ECR_USER_NAME;
    }

    public String getAgentUuid() {
        return AgentUuidAttributeVal;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static String getAdvertisementType() {
        return "jxta:System";
    }

    private void collectSIHostname() {
        LOG.info("Collect Hostname");
        String cmd = "/usr/bin/uname -n";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream" + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        this.SIHostname = s.trim();
    }

    public void collectHWArch() {
        LOG.info("Collect HWArch");
        String cmd = "/usr/bin/uname -p";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream" + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        this.hwarch = s.trim();
    }

    private void collectOSArch() {
        LOG.info("Collect OSArch");
        String cmd = "/usr/bin/uname -m";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream" + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        this.osarch = s.trim();
    }

    private void collectOSName() {
        LOG.info("Collect OSName");
        String cmd = "/usr/bin/uname -s";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream" + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        this.osname = s.trim();
    }

    private void collectOSVersion() {
        LOG.info("Collect OSVersion");
        String cmd = "/usr/bin/uname -r";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream" + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
        this.osversion = s.trim();
    }

    private void collectSISystemModel() {
        String key = "System Model";
        String resultValue = "";
        LOG.info("Collect System Model");
        String s = this.collectSIValue("name", "System Model");
        this.SISystemModel = s != null ? s.trim() : "Unknown";
    }

    private void collectSISerialNumber() {
        String key = "Serial Number";
        LOG.info("Collect Serial Number");
        String s = this.collectSIValue("serial", "Serial Number");
        this.SISerialNumber = s != null ? s.trim() : "NONE";
    }

    private void collectSIHostID() {
        String key = "Host ID";
        LOG.info("Collect HostID");
        String cmd = this.collectGeneralCmd + "hostid";
        String s = this.collectSIValue("hostid", "Host ID");
        this.SIHostID = s != null ? s.trim() : "";
    }

    private void collectSIHostAliases() {
        LOG.info("Collect HostAliases");
        this.SIHostAliases = this.collectSIValue("hostaliases", "Host Aliases");
    }

    private void collectSIHostAddresses() {
        LOG.info("Collect HostAddresses");
        this.SIHostAddresses = this.collectSIValue("hostaddrs", "Host Address(es)");
    }

    private void collectSIDnsDomain() {
        LOG.info("Collect DnsDomain");
        String tmp = this.collectSIValue("dnsdomain", "DNS Domain");
        this.SIDnsDomain = tmp.compareTo("UNKNOWN") == 0 ? "" : tmp;
    }

    private void collectSINisDomain() {
        LOG.info("Collect NisDomain");
        String tmp = this.collectSIValue("nisdomain", "NIS Domain");
        this.SINisDomain = tmp.compareTo("UNKNOWN") == 0 ? "" : tmp;
    }

    private void collectSIMacAddress() {
        LOG.info("Collect macaddrsMacAddress");
        this.SIMacAddress = this.collectSIValue("macaddrs", "MAC Address");
    }

    private void collectSINumCpu() {
        LOG.info("Collect NumCpu");
        this.SINumCpu = this.dca.getNumCPUs();
    }

    private void collectSICpuType() {
        LOG.info("Collect CpuType");
        this.SICpuType = this.collectSIValue(SICpuTag, "CPU Type");
    }

    private void collectSICpuSpeed() {
        LOG.info("Collect CpuSpeed");
        this.SICpuSpeed = this.dca.getCPUSpeed();
    }

    private void collectSICpuStatusAll() {
        LOG.info("Collect CpuStatus for CPU's");
        this.cpuStatusAll = this.dca.getCPUStatus();
    }

    private void collectSIMainMemory() {
        LOG.info("Collect MainMemory");
        this.SIMainMemory = this.collectSIValue("memory", "Main Memory");
    }

    private void collectSITotalDiskSpace() {
        LOG.info("Collect TotalDiskSpace");
        this.SITotalDiskSpace = this.collectSIValue("disk", "Total Disk Space");
    }

    private void collectSINumDisk() {
        LOG.info("Collect NumDisk");
        this.SINumDisk = this.collectSIValue("numdisk", "Total Disks");
    }

    private void collectSINumCdrom() {
        LOG.info("Collect NumCdrom");
        this.SINumCdrom = this.collectSIValue("numcdrom", "Total Cdroms");
    }

    private void collectSIRomVersion() {
        LOG.info("Collect RomVersion");
        this.SIRomVersion = this.collectSIValue("romver", "ROM Type");
    }

    private void collectSITimeZone() {
        LOG.info("Collect TimeZone");
        this.SITimeZone = this.collectSIValue("timezone", "Timezone");
        LOG.info("Timezone collect =" + this.collectSIValue("timezone", "Timezone"));
        LOG.info("Timezone this.SITimeZone =" + this.SITimeZone);
    }

    private void collectSIBootTime() {
        LOG.info("Collect BootTime");
        this.SIBootTime = this.collectSIValue("boottime", "Boot Time");
    }

    private void collectSISystemLocale() {
        LOG.info("Collect SystemLocale");
        this.SISystemLocale = this.collectSIValue("systemlocale", "Locale");
    }

    private String collectSIValue(String collectionID, String textKey) {
        String result = "";
        LOG.info("Harvesting value from dca : " + textKey);
        result = this.dca.collectValue(collectionID, textKey);
        return result;
    }

    private void collectPKGCollection() {
        this.PKGCollection = (HashMap)this.dca.collectPackages();
    }

    private void collectPatchCollection() {
        this.PatchCollection = (HashMap)this.dca.collectPatches();
    }

    private void collectStorageDevices() {
        this.StorageDeviceCollection = this.dca.collectStorageDevices();
    }

    private void collectNIC() {
        String szKey = "";
        String szValue = "";
        String szValue1 = "";
        int startIndex = -1;
        int stopIndex = -1;
        boolean bRead = true;
        String szProtocol = "";
        String szIP = "";
        String szMAC = "";
        String szInet6 = "";
        String szStoredValue = "";
        LOG.info("Collect NIC Devices");
        LOG.info("Collector harvesting NIC devices");
        String cmd = "/usr/sbin/ifconfig";
        String resultValue = "";
        Vector<String> args = new Vector<String>();
        args.add("ifconfig");
        args.add("-a");
        resultValue = this.runPrivCommand(cmd, args);
        LOG.info("resultValue:" + resultValue);
        if (resultValue != "" && resultValue != null) {
            startIndex = 0;
            stopIndex = resultValue.indexOf(10);
            bRead = stopIndex != -1;
            while (bRead && startIndex <= resultValue.length()) {
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    LOG.info("NIC val:" + szValue1);
                    startIndex = stopIndex + 1;
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                szValue1.trim();
                if (szValue1 == null || szValue1.length() <= 0 || szValue1.startsWith("lo") || szValue1.indexOf(": ") == -1) continue;
                szKey = szValue1.substring(0, szValue1.indexOf(58)).trim();
                int i = szValue1.indexOf("IPv");
                szProtocol = szValue1.substring(i, szValue1.indexOf(62, i)).trim();
                LOG.info("szProtocol=" + szProtocol);
                if (szProtocol.compareTo("IPv4") == 0) {
                    szProtocol = "v4";
                    stopIndex = resultValue.indexOf("\n", startIndex);
                    if (stopIndex != -1) {
                        szValue1 = resultValue.substring(startIndex, stopIndex);
                        startIndex = stopIndex + 1;
                        LOG.info("NIC val:" + szValue1);
                    } else {
                        szValue1 = resultValue.substring(startIndex, resultValue.length());
                        LOG.info("NIC val:" + szValue1);
                        bRead = false;
                    }
                    if (szValue1 != null && (i = szValue1.indexOf("inet ")) != -1) {
                        szIP = szValue1.substring(szValue1.indexOf(32, i), szValue1.indexOf("netmask")).trim();
                        LOG.info("szIP=" + szIP);
                    }
                    if ((stopIndex = resultValue.indexOf("\n", startIndex)) != -1) {
                        szValue1 = resultValue.substring(startIndex, stopIndex);
                        startIndex = stopIndex + 1;
                        LOG.info("NIC val:" + szValue1);
                    } else {
                        szValue1 = resultValue.substring(startIndex, resultValue.length());
                        LOG.info("NIC val:" + szValue1);
                        bRead = false;
                    }
                    if (szValue1 == null || (i = szValue1.indexOf("ether ")) == -1) continue;
                    LOG.info("NIC reading input=" + szValue1);
                    szMAC = szValue1.substring(i + 6, szValue1.length()).trim();
                    LOG.info("\nNIC name:" + szKey + "  szIP:" + szIP + "  szMAC:" + szMAC + "\n");
                    szValue = this.NICCollection.isEmpty() ? szProtocol + ":" + szIP + "\t" + "mac:" + szMAC + "\tprimary:true" : szProtocol + ":" + szIP + "\t" + "mac:" + szMAC + "\tprimary:false";
                    this.NICCollection.put(szKey, szValue);
                    LOG.info("Num NIC records: " + this.NICCollection.size());
                    continue;
                }
                if (szProtocol.compareTo("IPv6") != 0) continue;
                szProtocol = "v6";
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    startIndex = stopIndex + 1;
                    LOG.info("NIC val:" + szValue1);
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                if (szValue1 == null || szValue1.indexOf("ether ") == -1) continue;
                stopIndex = resultValue.indexOf("\n", startIndex);
                if (stopIndex != -1) {
                    szValue1 = resultValue.substring(startIndex, stopIndex);
                    startIndex = stopIndex + 1;
                    LOG.info("NIC val:" + szValue1);
                } else {
                    szValue1 = resultValue.substring(startIndex, resultValue.length());
                    LOG.info("NIC val:" + szValue1);
                    bRead = false;
                }
                if (szValue1 == null || (i = szValue1.indexOf("inet6 ")) == -1) continue;
                szInet6 = szValue1.substring(szValue1.indexOf(32, i), szValue1.indexOf(47, i)).trim();
                LOG.info("\nNIC name:" + szKey + "  szIP:" + szIP + "  szMAC:" + szMAC + "  szInet6:" + szInet6 + "\n");
                szStoredValue = this.NICCollection.get(szKey).toString();
                szValue = szStoredValue + "\t" + szProtocol + ":" + szInet6;
                this.NICCollection.put(szKey, szValue);
                LOG.info("NIC Stored key=" + szKey);
                LOG.info("NIC Stored value=" + this.NICCollection.get(szKey).toString());
                LOG.info("Num NIC records: " + this.NICCollection.size());
            }
        }
    }

    private void collectCPUDeviceIds() {
        int i;
        LOG.info("Collect CPU Device Id's");
        LOG.info("Collector harvesting CPU Device Id's");
        String numCpus = this.getSINumCpu();
        if (numCpus != null && numCpus != "") {
            this.cpuStatusDeviceIdAll = new String[Integer.parseInt(numCpus)];
            for (i = 0; i < Integer.parseInt(numCpus); ++i) {
                this.cpuStatusDeviceIdAll[i++] = "";
            }
        } else {
            this.cpuStatusDeviceIdAll = new String[64];
            for (i = 0; i < this.cpuStatusDeviceIdAll.length; ++i) {
                this.cpuStatusDeviceIdAll[i++] = "";
            }
        }
        String cmd = "/usr/bin/kstat -p -m cpu_info -s device_ID";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            int i2 = 0;
            s = input.readLine();
            while (s != null) {
                if ((s = s.trim()).length() > 0 && s.startsWith("cpu_info:")) {
                    this.cpuStatusDeviceIdAll[i2] = s.substring(s.indexOf("device_ID"), s.length());
                    if (this.cpuStatusDeviceIdAll[i2] == "0") {
                        this.cpuStatusDeviceIdAll[i2] = "";
                    }
                    ++i2;
                    LOG.info("CPU Device Id:" + s);
                } else {
                    this.cpuStatusDeviceIdAll[i2++] = "";
                }
                s = input.readLine();
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream from command: " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
    }

    private void initNodeCollectionData() {
        LOG.info("Initialize Node specific Data Collection items");
        this.collectSIHostname();
        this.collectHWArch();
        this.collectOSArch();
        this.collectOSName();
        this.collectOSVersion();
        this.collectSISystemModel();
        this.collectSISerialNumber();
        this.collectSIHostID();
        this.collectSIHostAliases();
        this.collectSIHostAddresses();
        this.collectSIDnsDomain();
        this.collectSINisDomain();
        this.collectSIMacAddress();
        this.collectSINumCpu();
        this.collectSICpuStatusAll();
        this.collectCPUDeviceIds();
        this.collectSICpuType();
        this.collectSICpuSpeed();
        this.collectSIMainMemory();
        this.collectSITotalDiskSpace();
        this.collectSINumDisk();
        this.collectSINumCdrom();
        this.collectSIRomVersion();
        this.collectSITimeZone();
        this.collectSIBootTime();
        this.collectSISystemLocale();
        this.setMachineId();
        this.collectPKGCollection();
        this.collectPatchCollection();
        this.collectStorageDevices();
        this.collectNIC();
        this.getDocument(false);
    }

    public String getMachineId() {
        return MACHINE_ID;
    }

    public void setMachineId() {
        byte[] result = null;
        String hash = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            StringBuffer sb = new StringBuffer();
            sb.append(this.getSIHostID());
            sb.append(this.getSIMacAddress());
            sb.append(this.getSISerialNumber());
            md.update(sb.toString().getBytes());
            MessageDigest tc1 = (MessageDigest)md.clone();
            result = tc1.digest();
            md.update(result);
            hash = Base64.byteArrayToBase64(result, false);
            MACHINE_ID = hash;
        }
        catch (Exception e) {
            LOG.severe(CommonUtil.getStackTrace(e));
        }
    }

    private void getInstallLocation() {
        LOG.info("Determine BasicReg package installation directory...");
        String cmd = "/usr/bin/pkginfo -r SUNWbreg";
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd, envp);
        }
        catch (Exception e) {
            LOG.info("Cannot exec " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String s = null;
        try {
            s = input.readLine();
            if (s == null || s.length() < 1) {
                LOG.log(Level.SEVERE, "Unable to determine BasicReg package installation directory, no value returned from command.");
                LOG.log(Level.SEVERE, "Command: " + cmd);
                this.cstCollectionDriverDir = "./sparcv9";
                this.ProbeConfigDir = " -cfdir " + this.cstCollectionDriverDir;
                this.collectGeneralCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectGeneral;
                LOG.info("cstCollectionDriverDir: " + this.cstCollectionDriverDir);
                LOG.info("ProbeConfigDir: " + this.ProbeConfigDir);
                LOG.info("collectGeneralCmd: " + this.collectGeneralCmd);
                this.collectPackageCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectPackage;
                LOG.info("collectPackageCmd: " + this.collectPackageCmd);
                this.collectPatchCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectPatch;
                LOG.info("collectPatchCmd: " + this.collectPatchCmd);
            } else {
                LOG.info("BasicReg package installation in: " + s);
                this.collectOSVersion();
                String osversionNum = this.osversion.substring(this.osversion.lastIndexOf(".") + 1);
                this.collectHWArch();
                if (osversionNum != null && this.hwarch != null) {
                    this.platformVersion = this.hwarch + "v" + osversionNum;
                    this.BasicRegInstallDirSuffix = this.BasicRegInstallDirSuffix.substring(0, this.BasicRegInstallDirSuffix.lastIndexOf("/") + 1) + this.platformVersion;
                    this.ProbeExecutable = this.ProbeExecutable.substring(0, this.ProbeExecutable.lastIndexOf(".") + 1) + this.platformVersion;
                }
                this.cstCollectionDriverDir = s + this.BasicRegInstallDirSuffix;
                this.ProbeConfigDir = " -cfdir " + this.cstCollectionDriverDir;
                this.collectGeneralCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectGeneral;
                LOG.info("cstCollectionDriverDir: " + this.cstCollectionDriverDir);
                LOG.info("ProbeConfigDir: " + this.ProbeConfigDir);
                LOG.info("collectGeneralCmd: " + this.collectGeneralCmd);
                this.collectPackageCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectPackage;
                LOG.info("collectPackageCmd: " + this.collectPackageCmd);
                this.collectPatchCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectPatch;
                LOG.info("collectPatchCmd: " + this.collectPatchCmd);
                this.collectDevicesCmd = this.cstCollectionDriverDir + this.ProbeExecutable + this.ProbeConfigDir + collectDevices;
                LOG.info("collectDevicesCmd: " + this.collectDevicesCmd);
            }
        }
        catch (Exception e) {
            LOG.info("Unable to read input stream from command: " + cmd);
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        try {
            input.close();
        }
        catch (IOException ioe) {
            LOG.info("Cannot close BufferedReader");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

