/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg;

import com.sun.cns.basicreg.adapter.CCRAdapter;
import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.adapter.eCRAdapter;
import com.sun.cns.basicreg.advertisement.SystemAdvertisement;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.ProxyManager;
import com.sun.cns.basicreg.common.RegistrationListener;
import com.sun.cns.basicreg.common.RegistrationProvider;
import com.sun.cns.basicreg.wizard.swing.GatherDialog;
import com.sun.cns.basicreg.wizard.swing.SwingWorker;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class BasicReg
implements RegistrationProvider {
    private static SystemAdvertisement sysAdv = null;
    private RegistrationListener registrationListener;
    private static final Logger LOG = Logger.getLogger((class$com$sun$cns$basicreg$BasicReg == null ? (class$com$sun$cns$basicreg$BasicReg = BasicReg.class$("com.sun.cns.basicreg.BasicReg")) : class$com$sun$cns$basicreg$BasicReg).getName());
    private CmdLineGlobalObject globalObject = CmdLineGlobalObject.getInstance();
    private PrintStream suppressedSystemOutPrintStream;
    private PrintStream suppressedSystemErrPrintStream;
    private PrintStream systemOutPrintStream;
    private PrintStream systemErrPrintStream;
    private int runMode;
    static /* synthetic */ Class class$com$sun$cns$basicreg$BasicReg;
    static /* synthetic */ Class class$java$lang$String;

    public BasicReg() {
        try {
            this.suppressedSystemOutPrintStream = new PrintStream(new FileOutputStream("/dev/null"));
            this.suppressedSystemErrPrintStream = new PrintStream(new FileOutputStream("/dev/null"));
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        this.systemOutPrintStream = System.out;
        this.systemErrPrintStream = System.err;
    }

    public BasicReg(PrintStream suppressedSystemOutPrintStream, PrintStream suppressedSystemErrPrintStream, PrintStream systemOutPrintStream, PrintStream systemErrPrintStream) {
        this.suppressedSystemOutPrintStream = suppressedSystemOutPrintStream;
        this.suppressedSystemErrPrintStream = suppressedSystemErrPrintStream;
        this.systemOutPrintStream = systemOutPrintStream;
        this.systemErrPrintStream = systemErrPrintStream;
    }

    public void loadPropertiesFromHomeDir() {
        Object object = this.checkPropertyManager();
        if (object != null) {
            String homeDir = System.getProperty("user.home");
            CmdLineGlobalObject.prop = (Properties)object;
            this.globalObject.setUpLogFile();
            LOG.info("properties file loaded from " + homeDir + "/QA-BR.properties");
        } else {
            this.loadProperties();
            LOG.info("properties file loaded from the default config.properties");
        }
        ProxyManager proxyManager = ProxyManager.getInstance();
        proxyManager.loadProxyProperties(CmdLineGlobalObject.prop);
    }

    public Object checkPropertyManager() {
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.sun.cns.basicreg.qa.PropertyManager");
            Constructor<?> constructor = clazz.getConstructor(null);
            Object object = constructor.newInstance(null);
            Method method = clazz.getMethod("loadProperties", null);
            result = method.invoke(object, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void loadProperties() {
        Properties prop = new Properties();
        InputStream iS = this.getClass().getClassLoader().getResourceAsStream("wizards/config.properties");
        if (iS != null) {
            try {
                prop.load(iS);
            }
            catch (IOException ie) {
                LOG.severe(ie.toString());
                LOG.severe(CommonUtil.getStackTrace(ie));
            }
        }
        CmdLineGlobalObject.prop = prop;
        this.globalObject.setUpLogFile();
    }

    public static SystemAdvertisement getSystemAdvertisement() {
        return sysAdv;
    }

    public static boolean isMachineRegistered() {
        boolean flag = false;
        try {
            String str = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.ASSET_ID);
            if (str != null && str.length() > 1) {
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return flag;
    }

    public static Object getCSMAuthenticator() {
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        return csmAuthAdapter.getCSMAuthenticator();
    }

    private boolean isRootAccessAuthorized() {
        LOG.info("checking root access");
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        if (!csmAuthAdapter.isAuthenticated()) {
            if (!csmAuthAdapter.isUserAuthenticatedAlready()) {
                LOG.warning("you don't have the privilege to run basicreg");
                return false;
            }
            CSMAuthAdapter.setAuthenticated(true);
        }
        CCRAdapter.setCSMAuthAdapter(csmAuthAdapter);
        csmAuthAdapter.closeFrame();
        return true;
    }

    public static Document authenticateUser(String user, String passwd) {
        Document doc = new Document();
        Element wizard = new Element("wizard");
        Element widget = new Element("widget");
        widget.setAttribute("id", "username");
        Element response = new Element("response");
        CDATA data = new CDATA(user);
        response.addContent((Content)data);
        widget.addContent((Content)response);
        wizard.addContent((Content)widget);
        widget = new Element("widget");
        widget.setAttribute("id", "password");
        response = new Element("response");
        data = new CDATA(passwd);
        response.addContent((Content)data);
        widget.addContent((Content)response);
        wizard.addContent((Content)widget);
        doc.setRootElement(wizard);
        try {
            XMLOutputter xout = new XMLOutputter();
            xout.output(doc, (OutputStream)System.out);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return BasicReg.authenticateUser(doc);
    }

    public static Document authenticateUser(Document doc) {
        eCRAdapter ecr = new eCRAdapter(doc);
        return ecr.authenticateUser();
    }

    public static String registerAsset(String usr, String password) {
        String str = null;
        return str;
    }

    public static String registerAsset(Document doc) {
        String str = null;
        return str;
    }

    private String getProfileFileName(int runMode) {
        if (runMode == 0) {
            return "wizards/profile.xml";
        }
        if (runMode == 1) {
            if (this.isPortalEnabled()) {
                return "wizards/profileSubscription1.xml";
            }
            return "wizards/profileSubscription.xml";
        }
        if (runMode == 2) {
            return "wizards/profileEnablePortal.xml";
        }
        if (runMode == 3) {
            return "wizards/profileSolaris.xml";
        }
        if (runMode == 4) {
            return "wizards/profileSolarisU1.xml";
        }
        LOG.severe("Unknown run mode: " + runMode);
        return "wizards/profile.xml";
    }

    private boolean isPortalEnabled() {
        boolean flag = false;
        try {
            String str = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PORTAL_MGMT_STATUS);
            if (str != null && str.equals("enabled")) {
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return flag;
    }

    public void setRegistrationListener(RegistrationListener registrationListener) {
        this.registrationListener = registrationListener;
    }

    public void runWizard() {
        this.runWizard(0, null, false);
    }

    public void runWizard(Frame parentFrame, boolean isModal) {
        this.runWizard(0, parentFrame, isModal);
    }

    public void runWizard(int runMode) {
        this.runWizard(runMode, null, false);
    }

    public void runWizard(final int runMode, final Frame parentFrame, final boolean isModal) {
        block4: {
            LOG.info("A mode: " + runMode);
            this.runMode = runMode;
            ProxyManager proxy = ProxyManager.getInstance();
            this.loadPropertiesFromHomeDir();
            if (!this.isRootAccessAuthorized()) {
                return;
            }
            GatherDialog gatherDialog = parentFrame == null ? new GatherDialog(null, 0, true, runMode == 0) : new GatherDialog(parentFrame, null, 0, true, runMode == 0);
            final GatherDialog finalGatherDialog = gatherDialog;
            SwingWorker worker = new SwingWorker(){
                boolean workerDone = false;

                public Object construct() {
                    LoadTask loadTask = new LoadTask(runMode, parentFrame, isModal);
                    this.workerDone = true;
                    finalGatherDialog.stop();
                    return loadTask;
                }

                public boolean isDone() {
                    return this.workerDone;
                }
            };
            worker.start();
            if (!worker.isDone()) {
                finalGatherDialog.start();
            }
            try {
                Class<?> wizardClazz = Class.forName("com.sun.cns.basicreg.wizard.swing.WizardFrame");
                Method runMethod = wizardClazz.getMethod("run", null);
                runMethod.invoke(null, null);
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                LOG.severe(CommonUtil.getStackTrace(e));
                if (!(e instanceof InvocationTargetException)) break block4;
                LOG.severe("Wrapped Target Exception:\n");
                Throwable targetThrowable = e.getCause();
                LOG.severe(targetThrowable != null ? CommonUtil.getStackTrace(targetThrowable) : "?");
            }
        }
    }

    public int getRunMode() {
        return this.runMode;
    }

    public Document runConsole() {
        this.loadPropertiesFromHomeDir();
        Document result = null;
        CommonUtil.disableSystemOut(this.suppressedSystemOutPrintStream, this.suppressedSystemErrPrintStream);
        LOG.info(">>>  Systemout disabled >>>");
        CommonUtil.enableSystemOut(this.systemOutPrintStream, this.systemErrPrintStream);
        LOG.info(">>> Systemout enabled >>>");
        try {
            Class<?> cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.CmdLineWizard");
            Object[] initArgs = new Object[]{new String("wizards/profile.xml")};
            Constructor<?> cons = cliClazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BasicReg.class$("java.lang.String")) : class$java$lang$String);
            Object cliWizard = cons.newInstance(initArgs);
            Method runMethod = cliClazz.getMethod("run", null);
            result = (Document)runMethod.invoke(cliWizard, null);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public static void main(String[] args) {
        Document doc = null;
        if (args.length > 0) {
            if ("-console".equalsIgnoreCase(args[0])) {
                BasicReg br = new BasicReg();
                LOG.finest("running basicreg in console mode");
                doc = br.runConsole();
            } else if ("-xml".equalsIgnoreCase(args[0])) {
                BasicReg br = new BasicReg();
                LOG.info("Future feature...import xml from command line.");
            }
        } else {
            BasicReg br = new BasicReg();
            LOG.finest("Running basicreg in gui, Solaris registration mode");
            br.runWizard(3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LoadTask {
        LoadTask(int runMode, Frame parentFrame, boolean isModal) {
            block2: {
                LOG.info("LoadTask ENTER");
                sysAdv = SystemAdvertisement.getInstance();
                try {
                    Class<?> cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.CmdLineWizard");
                    Object[] initArgs = new Object[]{new String(BasicReg.this.getProfileFileName(runMode))};
                    Constructor<?> cons = cliClazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BasicReg.class$("java.lang.String")) : class$java$lang$String);
                    Object cliWizard = cons.newInstance(initArgs);
                    Class<?> wizardClazz = Class.forName("com.sun.cns.basicreg.wizard.swing.WizardFrame");
                    initArgs = new Object[]{parentFrame, new Boolean(isModal), cliWizard, BasicReg.this.registrationListener, new Integer(runMode)};
                    Method createMethod = wizardClazz.getMethod("create", Class.forName("java.awt.Frame"), Class.forName("java.lang.Boolean"), Class.forName("com.sun.cns.basicreg.wizard.Wizard"), Class.forName("com.sun.cns.basicreg.common.RegistrationListener"), Class.forName("java.lang.Integer"));
                    createMethod.invoke(null, initArgs);
                }
                catch (Exception e) {
                    LOG.severe(e.toString());
                    LOG.severe(CommonUtil.getStackTrace(e));
                    if (!(e instanceof InvocationTargetException)) break block2;
                    LOG.severe("Wrapped Target Exception:\n");
                    Throwable targetThrowable = e.getCause();
                    LOG.severe(targetThrowable != null ? CommonUtil.getStackTrace(targetThrowable) : "?");
                }
            }
            LOG.info("LoadTask LEAVE");
        }
    }
}

