/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.java;

import com.sun.xml.rpc.processor.model.ModelException;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaMethod {
    private String name;
    private List parameters = new ArrayList();
    private List exceptions = new ArrayList();
    private JavaType returnType;
    private String declaringClass;

    public int getParameterCount() {
        return this.parameters.size();
    }

    public JavaMethod() {
    }

    public void addParameter(JavaParameter param) {
        if (this.hasParameter(param.getName())) {
            throw new ModelException("model.uniqueness");
        }
        this.parameters.add(param);
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(JavaType returnType) {
        this.returnType = returnType;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }

    public JavaMethod(String name) {
        this.name = name;
        this.returnType = null;
    }

    public void addException(String exception) {
        if (this.hasException(exception)) {
            throw new ModelException("model.uniqueness");
        }
        this.exceptions.add(exception);
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasException(String exception) {
        return this.exceptions.contains(exception);
    }

    public boolean hasParameter(String paramName) {
        int i = 0;
        while (i < this.parameters.size()) {
            if (paramName.equals(((JavaParameter)this.parameters.get(i)).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Iterator getExceptions() {
        return this.exceptions.iterator();
    }

    public Iterator getParameters() {
        return this.parameters.iterator();
    }

    public List getExceptionsList() {
        return this.exceptions;
    }

    public List getParametersList() {
        return this.parameters;
    }

    public void setExceptionsList(List l) {
        this.exceptions = l;
    }

    public void setParametersList(List l) {
        this.parameters = l;
    }
}

