/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.POP3Folder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.SharedInputStream;

public class POP3Message
extends MimeMessage {
    static final String UNKNOWN = "UNKNOWN";
    private POP3Folder folder;
    private int hdrSize = -1;
    private int msgSize = -1;
    String uid = "UNKNOWN";

    public int getSize() throws MessagingException {
        if (this.msgSize >= 0) {
            return this.msgSize;
        }
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.msgSize < 0) {
                    if (this.headers == null) {
                        this.loadHeaders();
                    }
                    this.msgSize = this.contentStream != null ? this.contentStream.available() : this.folder.getProtocol().list(this.msgnum) - this.hdrSize;
                }
                int n = this.msgSize;
                Object var3_5 = null;
                return n;
            }
        }
        catch (EOFException eOFException) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error getting size", iOException);
        }
    }

    private void loadHeaders() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.headers != null) {
                    Object var2_4 = null;
                    return;
                }
                InputStream inputStream = this.folder.getProtocol().top(this.msgnum, 0);
                if (inputStream == null) {
                    InputStream inputStream2 = this.getContentStream();
                    inputStream2.close();
                } else {
                    this.hdrSize = inputStream.available();
                    this.headers = new InternetHeaders(inputStream);
                }
                return;
            }
        }
        catch (EOFException eOFException) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error loading POP3 headers", iOException);
        }
    }

    public void saveChanges() throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    protected InputStream getContentStream() throws MessagingException {
        try {
            POP3Message pOP3Message = this;
            synchronized (pOP3Message) {
                if (this.contentStream == null) {
                    InputStream inputStream = this.folder.getProtocol().retr(this.msgnum, this.msgSize > 0 ? this.msgSize + this.hdrSize : 0);
                    if (inputStream == null) {
                        this.expunged = true;
                        throw new MessageRemovedException();
                    }
                    if (this.headers == null) {
                        this.headers = new InternetHeaders(inputStream);
                        this.hdrSize = (int)((SharedInputStream)((Object)inputStream)).getPosition();
                    } else {
                        int n;
                        block6: do {
                            int n2;
                            n = 0;
                            while ((n2 = inputStream.read()) >= 0) {
                                if (n2 == 10) continue block6;
                                if (n2 == 13) {
                                    if (inputStream.available() <= 0) continue block6;
                                    inputStream.mark(1);
                                    if (inputStream.read() == 10) continue block6;
                                    inputStream.reset();
                                    continue block6;
                                }
                                ++n;
                            }
                        } while (inputStream.available() != 0 && n != 0);
                        this.hdrSize = (int)((SharedInputStream)((Object)inputStream)).getPosition();
                    }
                    this.contentStream = ((SharedInputStream)((Object)inputStream)).newStream(this.hdrSize, -1L);
                    inputStream = null;
                }
            }
        }
        catch (EOFException eOFException) {
            this.folder.close(false);
            throw new FolderClosedException(this.folder, eOFException.toString());
        }
        catch (IOException iOException) {
            throw new MessagingException("error fetching POP3 content", iOException);
        }
        return super.getContentStream();
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getAllHeaders();
    }

    public void setFlags(Flags flags, boolean bl) throws MessagingException {
        Flags flags2 = (Flags)this.flags.clone();
        super.setFlags(flags, bl);
        if (!this.flags.equals(flags2)) {
            this.folder.notifyMessageChangedListeners(1, this);
        }
    }

    public POP3Message(Folder folder, int n) throws MessagingException {
        super(folder, n);
        this.folder = (POP3Folder)folder;
    }

    public String[] getHeader(String string) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(string);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("POP3 messages are read-only");
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        if (this.headers == null) {
            this.loadHeaders();
        }
        return this.headers.getHeader(string, string2);
    }
}

