/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.agent;

import com.sun.swup.client.agent.SwupAgentData;
import com.sun.swup.client.common.ExecuteCommand;
import com.sun.swup.client.common.UpdateMgrUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;

public class UpdateAnalysis {
    private static boolean debug = false;
    private static final long SWUP_ANALYSIS_INTERVAL = 86400000L;
    private static final String SWUP_ANALYSIS_DIR = UpdateMgrUtil.getInstance().getStoredDataLocation();
    private static final String SMPATCH_GET_PATCH_SET_CMD = "/usr/sbin/smpatch get patchpro.patchset";
    private static final String STORE_ANALYSIS_CMD = "/usr/sbin/smpatch analyze -@ -C patchpro.patchset={0}";
    private static SwupAgentData sad = null;
    private boolean forceAnalysis = false;

    public UpdateAnalysis() {
        this.forceAnalysis = false;
        sad = SwupAgentData.getInstance();
        debug = sad.getDebug();
    }

    public UpdateAnalysis(boolean force) {
        this.forceAnalysis = force;
        sad = SwupAgentData.getInstance();
        debug = sad.getDebug();
    }

    public void analysisCheck() {
        String colName = this.getCollectionName();
        if (colName != null && this.needUpdate(colName)) {
            this.updateAnalysisCache(colName);
        }
    }

    private String getCollectionName() {
        ExecuteCommand ec = new ExecuteCommand(SMPATCH_GET_PATCH_SET_CMD);
        ec.setCollectOutput(true);
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            return null;
        }
        String cmdOutput = ec.getAllOutput();
        if (cmdOutput == null || cmdOutput.length() < 3) {
            return null;
        }
        String collectionName = cmdOutput.charAt(cmdOutput.length() - 1) == '\n' ? cmdOutput.substring(0, cmdOutput.length() - 1) : cmdOutput;
        if (debug) {
            System.out.println("smpatch collection name:" + collectionName);
        }
        return collectionName;
    }

    public boolean needUpdate(String colName) {
        long lastModified;
        File analysisFile;
        boolean needupdate = true;
        if (this.forceAnalysis) {
            return needupdate;
        }
        File analysisDir = new File(SWUP_ANALYSIS_DIR);
        if (analysisDir.exists() && (analysisFile = UpdateMgrUtil.getInstance().getStoredDataFile(colName)).exists() && (lastModified = analysisFile.lastModified()) > 0L) {
            Date curTime = new Date();
            long curTimeMS = curTime.getTime();
            long fileAge = curTimeMS - lastModified;
            if (debug) {
                System.out.println("old cache age (min): " + fileAge / 60000L);
            }
            if (fileAge <= 86400000L) {
                needupdate = false;
            }
        }
        if (debug) {
            System.out.println("need an analysis update: " + needupdate);
        }
        return needupdate;
    }

    public void updateAnalysisCache(String colName) {
        File analysisDir = new File(SWUP_ANALYSIS_DIR);
        if (!analysisDir.exists()) {
            analysisDir.mkdirs();
            if (debug) {
                System.out.println("UpdateAnalysis: created dir: " + SWUP_ANALYSIS_DIR);
            }
        }
        MessageFormat msgFmt = new MessageFormat(STORE_ANALYSIS_CMD);
        Object[] msgArgs = new Object[]{colName};
        String analysisCmd = msgFmt.format(msgArgs);
        ExecuteCommand ec = new ExecuteCommand(analysisCmd);
        ec.setCollectOutput(true);
        if (debug) {
            System.out.println("UpdateAnalysis: executing cmd: " + analysisCmd);
        }
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        String cmdOutput = ec.getAllOutput();
        int retcode = ec.getResult();
        if (debug) {
            System.out.println("UpdateAnalysis: cmd exit code: " + retcode);
        }
        if (debug) {
            System.out.println("UpdateAnalysis: cmd output: " + cmdOutput);
        }
        try {
            PrintWriter cacheFile = new PrintWriter(new BufferedWriter(new FileWriter(UpdateMgrUtil.getInstance().getStoredDataFile(colName))));
            cacheFile.write(cmdOutput);
            cacheFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

