/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.agent;

import com.sun.cc.transport.client.Command;
import com.sun.cc.transport.client.CommandResponse;
import com.sun.cc.transport.client.Message;
import com.sun.cc.transport.client.StringCommand;
import com.sun.cc.transport.client.StringMessage;
import com.sun.cc.transport.client.TransportAdapter;
import com.sun.cc.transport.client.TransportAdapterException;
import com.sun.cc.transport.client.TransportListener;
import com.sun.cc.transport.client.XMLCommand;
import com.sun.cc.transport.client.XMLMessage;
import com.sun.swup.client.agent.ProcessSwupMsg;
import com.sun.swup.client.agent.SwupAgentData;
import com.sun.swup.client.agent.SwupCommand;
import com.sun.swup.client.agent.UpdateAnalysis;
import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.ExecuteCommand;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.Locale;

public class SwupAgent {
    public static TransportAdapter ta = null;
    public static String inputFile = "/tmp/MySwupAgent.in";
    public static String outputFile = "/tmp/MySwupAgent.out";
    private static SwupAgentData sad = null;
    private static boolean swupAutoAnalysis = false;
    private static boolean debug = false;
    private static CommandResponse cmdresp = null;

    private static void updateLastCheckinTime() {
        Date date = new Date();
        long ms = date.getTime();
        int lastCheckin = (int)(ms / 1000L / 60L) - 15;
        boolean stat = CCRUtils.setCCRValue((String)"cns.swup.lastCheckin", (String)("" + lastCheckin));
        if (debug) {
            if (stat) {
                System.out.println("Updated last checkin time in CCR: " + lastCheckin);
            } else {
                System.out.println("Unable to update last checkin time in CCR: " + lastCheckin);
            }
        }
    }

    private static void executeInventoryAgent() {
        int retstatus = 0;
        String cmd = "/usr/lib/cc-cfw/platform/invagent/bin/cc-invagent";
        ExecuteCommand ec = null;
        ec = new ExecuteCommand(cmd);
        if (debug) {
            System.out.println("in executeInventoryAgent(), IA start cmd:" + cmd);
        }
        ec.setCollectOutput(true);
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        String cmdOutput = ec.getAllOutput();
        if (debug) {
            System.out.println("in executeInventoryAgent(): collected output: \n" + cmdOutput);
        }
        retstatus = ec.getResult();
        if (debug) {
            System.out.println("in executeInventoryAgent(): cmd ret status: " + retstatus);
        }
    }

    public static void main(String[] args) {
        int ii;
        sad = SwupAgentData.getInstance();
        boolean forceAnalysis = false;
        boolean fakeTrans = false;
        for (ii = 0; ii < args.length; ++ii) {
            if (!args[ii].equals("-debug")) continue;
            debug = true;
            SwupAgentData.setDebug(debug);
            if (!debug) break;
            System.out.println("** DEBUG ON **");
            break;
        }
        for (ii = 0; ii < args.length; ++ii) {
            if (args[ii].equals("-autoAnalysis")) {
                String doAutoAnalysis = CCRUtils.getCCRValue((String)"cns.swup.autoAnalysis.enabled");
                if (doAutoAnalysis.equals("true") || doAutoAnalysis.length() == 0) {
                    swupAutoAnalysis = true;
                }
                if (debug) {
                    System.out.println("doAuthAnalysis: " + doAutoAnalysis + "  swupAutoAnalysis: " + swupAutoAnalysis);
                }
                if (!swupAutoAnalysis) {
                    if (debug) {
                        System.out.println("Auto analysis turned off - exiting");
                    }
                    System.exit(0);
                }
            }
            if (args[ii].equals("-forceAnalysis")) {
                forceAnalysis = true;
                if (debug) {
                    System.out.println("forceAnalysis = true");
                }
            }
            if (args[ii].equals("-fakeTrans")) {
                fakeTrans = true;
                if (debug) {
                    System.out.println(">>>>>>>>> fakeTrans = true");
                }
            }
            if (!args[ii].equals("-h")) continue;
            System.out.println("usage: swupas [-debug -autoAnalysis -fakeTrans -h]");
            System.out.println("  -autoAnalysis:  Run in Update Manager auto analysis mode");
            System.out.println("  -forceAnalysis: Do auto analysis even if its not time");
            System.out.println("  -debug:         Display debug output");
            System.out.println("  -fakeTrans:     Run in simulated Transport mode (simulate backend)");
            System.out.println("  -h:             Display this help");
            System.exit(0);
        }
        int sleepCount = 0;
        boolean haveLock = false;
        File lockFile = new File("/tmp/com.sun.swup.client.agent.LOCK");
        while (sleepCount < 10 && !haveLock) {
            block52: {
                if (debug) {
                    System.out.println("Attempt to get exclusive lock: " + (sleepCount + 1));
                }
                try {
                    FileLock flock;
                    if (!lockFile.exists()) {
                        lockFile.createNewFile();
                    }
                    if ((flock = new FileOutputStream(lockFile).getChannel().tryLock()) == null) {
                        if (debug) {
                            System.out.println("Exiting because another instance of swupas is running");
                        }
                        ++sleepCount;
                        break block52;
                    }
                    if (debug) {
                        System.out.println("We have the lock!");
                    }
                    haveLock = true;
                    break;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    ++sleepCount;
                }
            }
            try {
                if (debug) {
                    System.out.println("Sleeping 5 mins...");
                }
                Thread.sleep(300000L);
            }
            catch (InterruptedException ie) {}
        }
        if (!haveLock) {
            if (debug) {
                System.out.println("Still can't get the lock, time to give up. Exiting...");
            }
            System.exit(2);
        }
        if (!swupAutoAnalysis) {
            Locale.setDefault(sad.getLocale());
            try {
                try {
                    if (fakeTrans) {
                        File out = new File(outputFile);
                        File in = new File(inputFile);
                        if (debug) {
                            System.out.println("using stubbed Transport");
                        }
                        ta = new TransportAdapter("SWUP_CLIENT", (TransportListener)new SWUPListener(), in, out);
                    } else {
                        if (debug) {
                            System.out.println("prepare to register with Transport");
                        }
                        ta = new TransportAdapter("SWUP_CLIENT", (TransportListener)new SWUPListener());
                        if (debug) {
                            System.out.println("Registration complete");
                        }
                    }
                }
                catch (TransportAdapterException tae) {
                    if (debug) {
                        System.out.println("Error: unable to register with Transport");
                    }
                    tae.printStackTrace();
                    System.exit(1);
                }
                try {
                    if (!fakeTrans) {
                        if (debug) {
                            System.out.println("Sleeping 90 secs...");
                        }
                        Thread.sleep(90000L);
                    } else {
                        if (debug) {
                            System.out.println("Sleeping 40 secs...");
                        }
                        Thread.sleep(40000L);
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (debug) {
                    System.out.println("OK, WE'RE AWAKE AGAIN!...");
                }
                SwupAgent.updateLastCheckinTime();
                if (debug) {
                    System.out.println("Number of swup server cmds to be executed: " + sad.getCmdVecSize());
                }
                while (sad.getCmdVecSize() > 0) {
                    SwupCommand scmd = sad.getNextCmd();
                    if (scmd != null) {
                        int status = scmd.executeCommand();
                        String transRefID = scmd.getTransportRefID();
                        if (debug) {
                            scmd.dumpResp();
                        }
                        Message msg = new Message(scmd.getRespMsg().getBytes());
                        cmdresp = new CommandResponse(transRefID, CommandResponse.SUCCESS, msg);
                        if (debug) {
                            System.out.println("\nsendResponse trans refID: " + transRefID);
                        }
                        ta.send(cmdresp);
                        cmdresp = null;
                        if (scmd.needFreshAnalysis()) {
                            forceAnalysis = true;
                        }
                        if (sad.getCmdVecSize() > 0 || !forceAnalysis) continue;
                        ta.close();
                        if (!fakeTrans) {
                            SwupAgent.executeInventoryAgent();
                            continue;
                        }
                        if (!debug) continue;
                        System.out.println("stubbed out call to inventory agent");
                        continue;
                    }
                    if (!debug) continue;
                    System.out.println("Swup command was null!");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        UpdateAnalysis ua = new UpdateAnalysis(forceAnalysis);
        ua.analysisCheck();
        ExecuteCommand ec = new ExecuteCommand("/usr/bin/rm -f /tmp/com.sun.swup.client.agent.LOCK");
        try {
            ec.execute();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (debug) {
            System.out.println("Exiting for now...");
        }
        System.exit(0);
    }

    public static final class SWUPListener
    implements TransportListener {
        public void receiveCommand(Command cmd) throws TransportAdapterException {
            String refID = cmd.getRefId();
            if (debug) {
                System.out.println("refid: " + refID);
            }
            if (cmd instanceof XMLCommand) {
                ProcessSwupMsg psm;
                int status;
                String msg = ((XMLCommand)cmd).getXML();
                if (debug) {
                    System.out.println("<--received command (refID='" + refID + "'): ");
                }
                if ((status = (psm = new ProcessSwupMsg()).processMsg(msg, refID)) == -1) {
                    throw new TransportAdapterException();
                }
                System.out.println("received XML command: " + ((XMLCommand)cmd).getXML() + "\n");
            } else {
                if (cmd instanceof StringCommand) {
                    if (debug) {
                        System.out.println("received String command: " + ((StringCommand)cmd).getString() + "\n");
                    }
                    throw new TransportAdapterException("SWUP_CLIENT received unexpected StringCommand, refID: " + refID);
                }
                if (cmd instanceof Command) {
                    if (debug) {
                        System.out.println("received 'raw' command: " + cmd.getBytes() + "\n");
                    }
                    throw new TransportAdapterException("SWUP_CLIENT received unexpected Command, refID: " + refID);
                }
            }
        }

        public void receiveMessage(Message msg) throws TransportAdapterException {
            if (msg instanceof XMLMessage) {
                if (debug) {
                    System.out.println("received XML message: " + ((XMLMessage)msg).getXML() + "\n");
                }
            } else if (msg instanceof StringMessage) {
                if (debug) {
                    System.out.println("received String message: " + ((StringMessage)msg).getString() + "\n");
                }
            } else if (msg instanceof Message && debug) {
                System.out.println("received 'raw' message: " + msg.getBytes() + "\n");
            }
            throw new TransportAdapterException("SWUP_CLIENT received unexpected Message");
        }
    }
}

