/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cc.transport.agent.inventory;

import com.sun.cc.transport.client.Command;
import com.sun.cc.transport.client.CommandResponse;
import com.sun.cc.transport.client.Message;
import com.sun.cc.transport.client.StringMessage;
import com.sun.cc.transport.client.TransportAdapter;
import com.sun.cc.transport.client.TransportAdapterException;
import com.sun.cc.transport.client.TransportListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InventoryAgent {
    public static final String agentName = "IM-CC_ENG-inv";
    public static TransportAdapter adapter = null;
    private static Logger logger = Logger.getLogger("com.sun.cc.transport.agent.inventory.InventoryAgent");
    private static final String hostKey = "monitored-host";
    private static final String pkgKey = "installed-packages";
    private static final String patchKey = "installed-patches";
    private static final String hwKey = "hardware-info";
    private static final String patchProAnalysisKey = "patchpro_analysis";
    private static final String patchProInstalledPatchListKey = "patchpro_installed_patch_list";
    private static final String CKSUM_DATA_FILENAME = "/var/tmp/inv_cksum";
    private static final String HOST_DATA_FILENAME = "/var/tmp/inv_static";
    private static final String PACKAGE_DATA_FILENAME = "/var/tmp/inv_pkginfo";
    private static final String PATCH_DATA_FILENAME = "/var/tmp/inv_patchinfo";
    private static final String HARDWARE_DATA_FILENAME = "/var/tmp/inv_hwinfo";
    private static final String PATCHPRO_ANALYSIS_DATA_FILENAME = "/var/tmp/inv_patchpro_analysis";
    private static final String PATCHPRO_INSTALLED_PATCH_LIST_FILENAME = "/var/tmp/inv_patchpro_installed_patch_list";
    private static Integer assetSync = new Integer(0);
    private static String assetBlobsRequested = null;
    private static String lastRefId = null;

    private static String readFile(String file, boolean discardTrailingNewline) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        while (line != null) {
            sb.append(line);
            line = br.readLine();
            sb.append("\n");
        }
        if (discardTrailingNewline && sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getChecksumMessage() throws IOException, FileNotFoundException {
        StringBuffer sb = new StringBuffer("checksums");
        String line = InventoryAgent.readFile(CKSUM_DATA_FILENAME, true);
        sb.append("<").append(line.length()).append(">");
        sb.append(line);
        sb.append("<").append(hostKey.length()).append(">");
        sb.append(hostKey);
        sb.append("<").append(pkgKey.length()).append(">");
        sb.append(pkgKey);
        sb.append("<").append(patchKey.length()).append(">");
        sb.append(patchKey);
        sb.append("<").append(hwKey.length()).append(">");
        sb.append(hwKey);
        sb.append("<").append(patchProAnalysisKey.length()).append(">");
        sb.append(patchProAnalysisKey);
        sb.append("<").append(patchProInstalledPatchListKey.length()).append(">");
        sb.append(patchProInstalledPatchListKey);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String getBlobMessage() throws TransportAdapterException, IOException, FileNotFoundException {
        StringBuffer sb = new StringBuffer("blobdata");
        String line = InventoryAgent.readFile(CKSUM_DATA_FILENAME, true);
        sb.append("<").append(line.length()).append(">");
        sb.append(line);
        String allkeys = "monitored-host:installed-packages:installed-patches:hardware-info:patchpro_analysis:patchpro_installed_patch_list";
        sb.append("<").append(allkeys.length()).append(">");
        sb.append(allkeys);
        Integer n = assetSync;
        synchronized (n) {
            String[] blobs = assetBlobsRequested.split(",");
            for (int i = 1; i < blobs.length; ++i) {
                void var6_6;
                String fname;
                if (hostKey.equals(blobs[i])) {
                    fname = HOST_DATA_FILENAME;
                } else if (pkgKey.equals(blobs[i])) {
                    fname = PACKAGE_DATA_FILENAME;
                } else if (patchKey.equals(blobs[i])) {
                    fname = PATCH_DATA_FILENAME;
                } else if (hwKey.equals(blobs[i])) {
                    fname = HARDWARE_DATA_FILENAME;
                } else if (patchProAnalysisKey.equals(blobs[i])) {
                    fname = PATCHPRO_ANALYSIS_DATA_FILENAME;
                } else if (patchProInstalledPatchListKey.equals(blobs[i])) {
                    fname = PATCHPRO_INSTALLED_PATCH_LIST_FILENAME;
                } else {
                    String err = "unknown blob requested: " + blobs[i];
                    logger.log(Level.SEVERE, err);
                    throw new TransportAdapterException(err);
                }
                sb.append("<").append(blobs[i].length()).append(">");
                sb.append(blobs[i]);
                String data = InventoryAgent.readFile((String)var6_6, false);
                sb.append("<").append(data.length()).append(">");
                sb.append(data);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendAssetMessage(boolean cksumOnly) throws TransportAdapterException, IOException, FileNotFoundException {
        Integer n;
        try {
            try {
                if (cksumOnly) {
                    logger.log(Level.FINE, "Sending checksum message");
                    adapter.send((Message)new StringMessage(InventoryAgent.getChecksumMessage()));
                }
                logger.log(Level.FINE, "Sending blobdata message");
                adapter.send(new CommandResponse(lastRefId, CommandResponse.SUCCESS, (Message)new StringMessage(InventoryAgent.getBlobMessage())));
            }
            catch (TransportAdapterException tax) {
                logger.log(Level.WARNING, "Transport Error: " + tax.getMessage());
                Object var3_2 = null;
                if (cksumOnly) return;
                Integer n3 = assetSync;
                synchronized (n3) {
                    assetBlobsRequested = null;
                    lastRefId = null;
                    return;
                }
            }
            catch (FileNotFoundException fnfx) {
                logger.log(Level.WARNING, "Missing/Unknown file: " + fnfx.getMessage());
                Object var3_3 = null;
                if (cksumOnly) return;
                Integer n4 = assetSync;
                synchronized (n4) {
                    assetBlobsRequested = null;
                    lastRefId = null;
                    return;
                }
            }
            catch (IOException iox) {
                logger.log(Level.WARNING, "IO Exception: " + iox.getMessage());
                Object var3_4 = null;
                if (cksumOnly) return;
                Integer n5 = assetSync;
                synchronized (n5) {
                    assetBlobsRequested = null;
                    lastRefId = null;
                    return;
                }
            }
            Object var3_1 = null;
            if (cksumOnly) return;
            n = assetSync;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (cksumOnly) throw throwable;
            Integer n2 = assetSync;
            synchronized (n2) {
                assetBlobsRequested = null;
                lastRefId = null;
                throw throwable;
            }
        }
        synchronized (n) {
            assetBlobsRequested = null;
            lastRefId = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            boolean CHECKSUMS = true;
            boolean BLOBS = false;
            adapter = new TransportAdapter(agentName, (TransportListener)new MyListener());
            InventoryAgent.sendAssetMessage(CHECKSUMS);
            int pause = 30;
            for (int wait = 600; wait > 0; wait -= pause) {
                Integer n = assetSync;
                synchronized (n) {
                    if (assetBlobsRequested != null) {
                        InventoryAgent.sendAssetMessage(BLOBS);
                        wait = 0;
                    }
                }
                try {
                    logger.log(Level.FINER, "Sleeping " + pause + " secs");
                    Thread.sleep(pause * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static final class MyListener
    implements TransportListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveCommand(Command cmd) throws TransportAdapterException {
            String str = new String(cmd.getBytes());
            if (str == null || str.length() == 0) {
                String err = "Received empty message: " + cmd.getRefId();
                logger.log(Level.WARNING, err);
                throw new TransportAdapterException(err);
            }
            logger.log(Level.FINE, "received: " + str);
            String[] tokens = str.split(":");
            if (tokens.length != 2) {
                String err = "Received malformed message: " + str;
                logger.log(Level.WARNING, err);
                throw new TransportAdapterException(err);
            }
            String[] actions = tokens[0].split("=");
            String[] params = tokens[1].split("=");
            if (actions.length != 2 || !actions[0].toUpperCase().equals("ACTION") || !actions[1].toUpperCase().equals("SEND_DATA")) {
                String err = "Received malformed message: " + str;
                logger.log(Level.WARNING, err);
                throw new TransportAdapterException(err);
            }
            if (params.length < 2 || !params[0].toUpperCase().equals("PARAMS") || !params[1].toUpperCase().startsWith("BLOBS")) {
                String err = "Received malformed message: " + str;
                logger.log(Level.WARNING, err);
                throw new TransportAdapterException(err);
            }
            Integer n = assetSync;
            synchronized (n) {
                logger.log(Level.FINER, "Asset blobs req: " + params[1]);
                assetBlobsRequested = params[1];
                lastRefId = cmd.getRefId();
            }
        }

        public void receiveMessage(Message msg) throws TransportAdapterException {
            logger.log(Level.FINE, "received message: " + new String(msg.getBytes()));
        }
    }
}

