/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.wrapper;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.CSMAuthenticator;
import com.sun.cns.authentication.CSMCaller;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.Status;
import com.sun.swup.client.common.StatusParser;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.engine.solaris.CancelAction;
import com.sun.swup.client.interfaces.Cancellable;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.ProgressManager;
import com.sun.swup.client.wrapper.PatchProPreferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;

public class PatchProWrapper
implements CSMCaller {
    public static final String PATCH_SOURCE = "patchpro.patch.source";
    public static final String PATCHSET = "patchpro.patchset";
    public static final String SUN_USER = "patchpro.sun.user";
    public static final String SUN_PASSWD = "patchpro.sun.passwd";
    public static final String PROXY_HOST = "patchpro.proxy.host";
    public static final String PROXY_PORT = "patchpro.proxy.port";
    public static final String PROXY_USER = "patchpro.proxy.user";
    public static final String PROXY_PASSWD = "patchpro.proxy.passwd";
    public static final String DOWNLOAD_DIRECTORY = "patchpro.download.directory";
    public static final String BACKOUT_DIRECTORY = "patchpro.backout.directory";
    public static final String INSTALL_TYPES = "patchpro.install.types";
    private static PatchProWrapper patchProWrapper;
    private CSMAuthenticator authenticator = CSMAuthenticator.getInstance();
    private final String smpatch = "/usr/sbin/smpatch";
    private String lines;
    private String statusLines;

    private PatchProWrapper() {
        this.authenticator.setCallback((CSMCaller)this, "STATUS");
    }

    public static PatchProWrapper getInstance() {
        if (patchProWrapper == null) {
            patchProWrapper = new PatchProWrapper();
        }
        return patchProWrapper;
    }

    public void receiveOutput(String output) {
        String status = output.substring(6, output.length()).trim();
        if (status.startsWith("PROGRESS")) {
            int percent;
            String msg1 = " ";
            String msg2 = " ";
            try {
                percent = Integer.parseInt(status.substring(status.indexOf(" ") + 1, status.indexOf("\"") - 1));
                msg1 = status.substring(status.indexOf(34) + 1, status.indexOf(34, status.indexOf(34) + 1));
                msg2 = status.substring(status.lastIndexOf(34, status.lastIndexOf(34) - 1) + 1, status.lastIndexOf(34));
                if (msg1.equals(msg2)) {
                    msg2 = " ";
                }
            }
            catch (NumberFormatException nfe) {
                return;
            }
            catch (StringIndexOutOfBoundsException sibe) {
                return;
            }
            ProgressManager.getInstance().updateProgress(percent, msg1, msg2);
        } else {
            if (UMData.getDebug()) {
                System.out.println("Status: " + output);
            }
            this.statusLines = this.statusLines + output + "\n";
        }
    }

    public void analyze(String fullName) throws CMDExecutionException, NotAuthenticatedException {
        this.statusLines = "";
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("analyze");
        args.add("-@");
        args.add("-C");
        args.add("patchpro.internal.statustags=true");
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        if (UMData.getCurrentPatchset() != null) {
            args.add("-C");
            args.add("patchpro.patchset=" + UMData.getCurrentPatchset());
        }
        Vector<String> args2 = new Vector<String>();
        args2.add("sh");
        args2.add("-c");
        args2.add("umask 022; /usr/bin/cp /dev/stdin " + fullName);
        try {
            this.authenticator.runCMD("/usr/bin/sh", args2, this.authenticator.runCMD("/usr/sbin/smpatch", args));
        }
        catch (CMDExecutionException cee) {
            Status theStatus = StatusParser.parseAnalyzeMessages((String)this.statusLines);
            if (theStatus.getUMStatus() == -1) {
                throw cee;
            }
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        Status theStatus = StatusParser.parseAnalyzeMessages((String)this.statusLines);
        if (theStatus.getUMStatus() != 0) {
            throw new CMDExecutionException(theStatus.getUMStatus(), theStatus.getCompletionMessage());
        }
    }

    public String getReadme(String patch) throws CMDExecutionException, NotAuthenticatedException {
        String output;
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("getdocument");
        args.add("ReadMe/" + patch);
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        return output;
    }

    public String list() throws CMDExecutionException, NotAuthenticatedException {
        String output;
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("list");
        args.add("-@");
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        return output;
    }

    public void update(Update[] updates) throws CMDExecutionException, NotAuthenticatedException {
        this.statusLines = "";
        String[] patches = null;
        if (updates != null && updates.length != 0) {
            patches = new String[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                patches[i] = updates[i].getUpdateID();
            }
        } else {
            return;
        }
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("update");
        for (int i = 0; i < patches.length; ++i) {
            args.add("-i");
            args.add(patches[i]);
        }
        args.add("-C");
        args.add("patchpro.internal.statustags=true");
        args.add("-C");
        args.add("patchpro.install.types=standard");
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        if (UMData.getCurrentPatchset() != null) {
            args.add("-C");
            args.add("patchpro.patchset=" + UMData.getCurrentPatchset());
        }
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            Status[] theStatuses = StatusParser.parseMessages((String[])patches, (String)this.statusLines);
            boolean throwIt = true;
            for (int i = 0; i < theStatuses.length; ++i) {
                if (theStatuses[i].getUMStatus() == -1) continue;
                throwIt = false;
                break;
            }
            if (throwIt) {
                throw we;
            }
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        Status[] theStatuses = StatusParser.parseMessages((String[])patches, (String)this.statusLines);
        for (int i = 0; i < theStatuses.length; ++i) {
            for (int k = 0; k < updates.length; ++k) {
                if (!updates[k].getUpdateID().startsWith(theStatuses[i].getUpdateID())) continue;
                updates[k].setUpdateOperateStatus(theStatuses[i].getUMStatus());
                updates[k].setUpdateOperateMessage(theStatuses[i].getCompletionMessage());
            }
        }
    }

    public void add(String[] patches) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("add");
        for (int i = 0; i < patches.length; ++i) {
            args.add("-i");
            args.add(patches[i]);
        }
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void add(String patch) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("add");
        args.add("-i");
        args.add(patch);
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void download(String[] patches) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("download");
        for (int i = 0; i < patches.length; ++i) {
            args.add("-i");
            args.add(patches[i]);
        }
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void download(String patch) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("download");
        args.add("-i");
        args.add(patch);
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void remove(Update[] updates) throws CMDExecutionException, NotAuthenticatedException {
        this.statusLines = "";
        String[] patches = null;
        if (updates != null && updates.length != 0) {
            patches = new String[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                patches[i] = updates[i].getUpdateID();
            }
        } else {
            return;
        }
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("remove");
        for (int i = 0; i < patches.length; ++i) {
            args.add("-i");
            args.add(patches[i]);
        }
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        args.add("-C");
        args.add("patchpro.internal.statustags=true");
        if (UMData.getCurrentPatchset() != null) {
            args.add("-C");
            args.add("patchpro.patchset=" + UMData.getCurrentPatchset());
        }
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            Status[] theStatuses = StatusParser.parseMessages((String[])patches, (String)this.statusLines);
            boolean throwIt = true;
            for (int i = 0; i < theStatuses.length; ++i) {
                if (theStatuses[i].getUMStatus() == -1) continue;
                throwIt = false;
                break;
            }
            if (throwIt) {
                throw we;
            }
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        Status[] theStatuses = StatusParser.parseMessages((String[])patches, (String)this.statusLines);
        for (int i = 0; i < theStatuses.length; ++i) {
            for (int k = 0; k < updates.length; ++k) {
                if (!updates[k].getUpdateID().startsWith(theStatuses[i].getUpdateID())) continue;
                updates[k].setUpdateOperateStatus(theStatuses[i].getUMStatus());
                updates[k].setUpdateOperateMessage(theStatuses[i].getCompletionMessage());
            }
        }
    }

    public void remove(String patch) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("remove");
        args.add("-i");
        args.add(patch);
        args.add("-C");
        args.add("patchpro.cancel.enable=true");
        args.add("-C");
        args.add("patchpro.internal.statustags=true");
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public String getCollectionFile(String name) throws CMDExecutionException, NotAuthenticatedException {
        String output;
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("getdocument");
        if (name == null) {
            args.add("collection/default");
        } else {
            args.add("collection/" + name);
        }
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        return output;
    }

    public String getCategoryFile(String name) throws CMDExecutionException, NotAuthenticatedException {
        String output;
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("getdocument");
        if (name == null) {
            args.add("category/default");
        } else {
            args.add("category/" + name);
        }
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
        return output;
    }

    public String get(String parameter) throws CMDExecutionException {
        String output = "";
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("get");
        args.add(parameter);
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            // empty catch block
        }
        return output;
    }

    public Vector get(PatchProPreferences prefs) throws CMDExecutionException {
        Vector<String> result = new Vector<String>();
        Vector toGet = prefs.getPreferencesToGet();
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("get");
        for (int i = 0; i < toGet.size(); ++i) {
            args.add((String)toGet.elementAt(i));
        }
        try {
            String output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
            BufferedReader in = new BufferedReader(new StringReader(output));
            for (int k = 0; k < toGet.size(); ++k) {
                String line = in.readLine();
                if (line == null) {
                    result.addElement("");
                    continue;
                }
                result.addElement(line);
            }
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    public String get() throws CMDExecutionException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("get");
        String output = "";
        try {
            output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException notAuthenticatedException) {
            // empty catch block
        }
        return output;
    }

    public void set(String parameter, String value) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("set");
        args.add(parameter + "=" + value);
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void set(PatchProPreferences prefs) throws CMDExecutionException, NotAuthenticatedException {
        Vector toSet = prefs.getPreferencesToSet();
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("set");
        for (int i = 0; i < toSet.size(); ++i) {
            args.add(((String[])toSet.elementAt(i))[0] + "=" + ((String[])toSet.elementAt(i))[1]);
        }
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void unset(String parameter) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("unset");
        args.add(parameter);
        try {
            this.authenticator.runCMD("/usr/sbin/smpatch", args);
        }
        catch (CMDExecutionException we) {
            throw we;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public void delete(String fullName) throws CMDExecutionException, NotAuthenticatedException {
        Vector<String> args = new Vector<String>();
        args.add("rm");
        args.add("-rf");
        args.add(fullName);
        try {
            this.authenticator.runCMD("/usr/bin/rm", args);
        }
        catch (CMDExecutionException cee) {
            throw cee;
        }
        catch (NotAuthenticatedException nae) {
            throw nae;
        }
    }

    public Cancellable getCancelAction() {
        CancelAction cancel = new CancelAction(this.authenticator);
        return cancel;
    }

    public String getExpandedRemoveOrder(Update[] updates) throws CMDExecutionException, NotAuthenticatedException {
        String[] patches;
        if (updates != null && updates.length != 0) {
            patches = new String[updates.length];
            for (int i = 0; i < updates.length; ++i) {
                patches[i] = updates[i].getUpdateID();
            }
        } else {
            return "";
        }
        Vector<String> args = new Vector<String>();
        args.add("smpatch");
        args.add("remove");
        args.add("-q");
        for (int i = 0; i < patches.length; ++i) {
            args.add("-i");
            args.add(patches[i]);
        }
        String output = this.authenticator.runCMD("/usr/sbin/smpatch", args);
        return output;
    }
}

