/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class WarningPanel
extends InsetPanel {
    private WeakReference warningDialog;
    private JLabel alertTitleLabel;
    private JLabel alertMessageLabel;
    private JButton okButton;
    private JPanel buttonPanel;
    private ImageIcon alertImageIcon;
    private String alertTitle;
    private String alertMessage;
    private String alertTitleHTML;
    private String alertMessageHTML;

    WarningPanel(WarningDialog warningDialog, String alertTitle, String alertMessage) {
        this.setWarningDialog(warningDialog);
        this.alertTitle = alertTitle;
        this.alertMessage = alertMessage;
        this.createComponents();
        this.createLayout();
    }

    private void createComponents() {
        this.alertMessageHTML = this.convertMessageToHTML(this.alertMessage);
        if (this.alertTitle != null && this.alertTitle.length() > 0) {
            this.alertTitleLabel = new JLabel(this.alertTitle);
            this.alertTitleLabel.setFont(this.alertTitleLabel.getFont().deriveFont(1));
            this.alertTitleLabel.setHorizontalAlignment(2);
            this.alertTitleLabel.setAlignmentX(0.0f);
        }
        this.alertMessageLabel = new JLabel(this.alertMessageHTML, 2);
        this.alertImageIcon = Environment.getImageIcon((String)"warning_medium.gif");
        this.buttonPanel = new InsetPanel();
        this.okButton = new JButton(this.getWarningDialog().getActionSet().getAction("ok"));
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        Insets insets = new Insets(6, 6, 6, 6);
        this.setInsets(insets);
        InsetPanel iconPanel = new InsetPanel(insets);
        JLabel imgLabel = new JLabel(this.alertImageIcon, 0);
        iconPanel.add((Component)imgLabel, "Center");
        InsetPanel iconMsgPanel = new InsetPanel(new BorderLayout());
        InsetPanel msgPanel = new InsetPanel(new BorderLayout());
        InsetPanel msgSubPanel = new InsetPanel(new BorderLayout());
        if (this.alertTitleLabel != null) {
            msgPanel.add((Component)this.alertTitleLabel, "North");
            msgSubPanel.setInsets(new Insets(6, 0, 0, 0));
        }
        msgSubPanel.add((Component)this.alertMessageLabel, "Center");
        msgPanel.add((Component)msgSubPanel, "Center");
        iconMsgPanel.add((Component)iconPanel, "West");
        iconMsgPanel.add((Component)msgPanel, "Center");
        this.add((Component)iconMsgPanel, "Center");
        InsetPanel buttonPanel = new InsetPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        this.add((Component)buttonPanel, "South");
        this.validate();
    }

    private void setWarningDialog(WarningDialog warningDialog) {
        this.warningDialog = new WeakReference<WarningDialog>(warningDialog);
    }

    private WarningDialog getWarningDialog() {
        return (WarningDialog)this.warningDialog.get();
    }

    private String convertMessageToHTML(String message) {
        if (message == null) {
            message = "";
        }
        if (message.length() == 0) {
            StringBuffer stringBuffer = new StringBuffer().append("<html><font size=-2");
            this.getWarningDialog();
            String result = stringBuffer.append(WarningDialog.I18N.getString("unknown-error")).append("</font>").toString();
            return result;
        }
        String result = "<html><font size=-2>";
        String[] lines = message.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            result = result + lines[i] + "<br>";
        }
        result = result + "</font>";
        return result;
    }
}

