/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.cns.authentication.CMDExecutionException;
import com.sun.cns.authentication.NotAuthenticatedException;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.interfaces.Uninstaller;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AuthenticationManager;
import com.sun.swup.client.ui.DataController;
import com.sun.swup.client.ui.InstalledTable;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.UninstallPanel;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.Worker;
import com.sun.swup.client.ui.foundation.WorkerEvent;
import com.sun.swup.client.ui.foundation.WorkerListener;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.GenericDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

class UninstallDialog
extends GenericDialog {
    static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$UninstallDialog == null ? (class$com$sun$swup$client$ui$UninstallDialog = UninstallDialog.class$("com.sun.swup.client.ui.UninstallDialog")) : class$com$sun$swup$client$ui$UninstallDialog, "resources/strings/uninstall");
    private UninstallPanel uninstallPanel;
    private UninstallWorker worker;
    private boolean bAuthenticationNeeded;
    static /* synthetic */ Class class$com$sun$swup$client$ui$UninstallDialog;

    UninstallDialog(Frame owner) {
        super(owner);
        this.setTitle(I18N.getString("title"));
        this.setResizable(false);
        this.setModal(true);
        this.getAccessibleContext().setAccessibleName(I18N.getString("title"));
        this.getAccessibleContext().setAccessibleDescription(I18N.getString("uninstall-dialog-description"));
        this.setActionSet(new GenericActionSet());
        this.getActionSet().putAction("cancel", new CancelAction());
        this.getActionSet().getAction("cancel").setEnabled(true);
        this.createComponents();
        this.createLayout();
        this.pack();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = Environment.getInteger((String)"preferred-dialog-width");
        return d;
    }

    boolean isAuthenticationNeeded() {
        return this.bAuthenticationNeeded;
    }

    void beginUninstall() {
        BeginUninstallAction action = new BeginUninstallAction();
        ActionEvent e = new ActionEvent(this, 1001, null);
        action.actionPerformed(e);
    }

    UninstallPanel getUninstallPanel() {
        return this.uninstallPanel;
    }

    void refreshAvailableUpdates() {
    }

    void refreshInstalledUpdates() {
        InstalledTable table = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
        InstalledTableModel model = (InstalledTableModel)table.getModel();
        Update[] checkedUpdates = model.getCheckedUpdates();
        UpdateDelegate ud = Application.getInstance().getUpdateFrame().getDelegate();
        ud.setUninstallSummaryUpdates(checkedUpdates);
        ArrayList<Update> uninstalledUpdateList = new ArrayList<Update>();
        for (int i = 0; i < checkedUpdates.length; ++i) {
            int status = checkedUpdates[i].getUpdateOperateStatus();
            if (UMData.getDebug()) {
                System.out.println("Patch id:" + checkedUpdates[i].getName() + " ,Status: " + status);
            }
            if (status != 0) continue;
            uninstalledUpdateList.add(checkedUpdates[i]);
        }
        Update[] uninstalledUpdates = null;
        if (uninstalledUpdateList.size() > 0) {
            uninstalledUpdates = new Update[uninstalledUpdateList.size()];
            for (int j = 0; j < uninstalledUpdateList.size(); ++j) {
                uninstalledUpdates[j] = (Update)uninstalledUpdateList.get(j);
            }
            table.removeUninstalledUpdates(uninstalledUpdates);
            this.removeUninstalledDependency(uninstalledUpdates);
            model.uncheckAll();
        }
        if (uninstalledUpdates != null) {
            for (int k = 0; k < uninstalledUpdates.length; ++k) {
                uninstalledUpdates[k].resetUpdateStatus();
            }
        }
        model.uncheckAll();
    }

    private void removeUninstalledDependency(Update[] uninstalledUpdates) {
        InstalledTable table = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
        InstalledTableModel model = (InstalledTableModel)table.getModel();
        Update[] installedUpdates = model.getUpdates();
        for (int i = 0; i < installedUpdates.length; ++i) {
            for (int j = 0; j < uninstalledUpdates.length; ++j) {
                List dUpdates = installedUpdates[i].getRemoveDependencyList();
                for (int k = 0; dUpdates != null && k < dUpdates.size(); ++k) {
                    Update update = (Update)dUpdates.get(k);
                    if (!((Object)uninstalledUpdates[j]).equals(update)) continue;
                    installedUpdates[i].removeRemoveDependency(update);
                }
            }
        }
    }

    private void createComponents() {
        this.uninstallPanel = new UninstallPanel(this);
    }

    private void createLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.uninstallPanel, "Center");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UninstallWorker
    extends Worker
    implements WorkerListener {
        private Update[] aUpdate;

        UninstallWorker() {
            this.addWorkerListener(this);
        }

        public void workStarted(WorkerEvent e) {
        }

        public void workFinished(WorkerEvent e) {
            if (UninstallDialog.this.bAuthenticationNeeded) {
                UninstallDialog.this.setVisible(false);
                UninstallDialog.this.dispose();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ UninstallWorker this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        AuthenticationManager.getInstance().setAction(UninstallWorker.access$200(this.this$1).new BeginUninstallAction());
                        AuthenticationManager.getInstance().authenticate();
                    }
                });
            }
        }

        public void workInterrupted(WorkerEvent e) {
            UninstallDialog.this.getActionSet().getAction("cancel").setEnabled(false);
            UninstallDialog.this.getActionSet().removeAction("cancel");
            UninstallDialog.this.getUninstallPanel().setCancelFlag(true);
            DataController.getInstance().getUninstaller().cancelUninstall();
            Application.getInstance().getUpdateFrame().createCancelDialogContentPanel(UninstallDialog.this);
        }

        void work(Update[] aUpdate) {
            this.aUpdate = aUpdate;
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ UninstallWorker this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    UninstallWorker.access$300(this.this$1, 0, this);
                }
            });
            this.start();
        }

        public Object construct() {
            Object obj = new Object();
            Uninstaller uninstaller = DataController.getInstance().getUninstaller();
            try {
                uninstaller.getMessenger().setPropertyChangeListener(UninstallDialog.this.getUninstallPanel().getPropertyChangeListener());
                uninstaller.beginUninstall(this.aUpdate);
            }
            catch (NotAuthenticatedException e) {
                UninstallDialog.this.bAuthenticationNeeded = true;
            }
            catch (Throwable throwable) {
                uninstaller.getMessenger().uninstallFinished();
                Application.getInstance().getUpdateFrame().showWarningDialog(throwable, UninstallDialog.this);
                return obj;
            }
            return obj;
        }

        public void finished() {
            this.fireWorkerEvent(1, this);
        }

        static /* synthetic */ UninstallDialog access$200(UninstallWorker x0) {
            return x0.UninstallDialog.this;
        }

        static /* synthetic */ void access$300(UninstallWorker x0, int x1, Object x2) {
            x0.fireWorkerEvent(x1, x2);
        }
    }

    class BeginUninstallAction
    extends AbstractAction {
        BeginUninstallAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Update[] expandedUpdates;
            UninstallDialog.this.bAuthenticationNeeded = false;
            Update[] aUpdates = Application.getInstance().getUpdateFrame().getDelegate().getUninstallUpdates();
            InstalledTable iTable = Application.getInstance().getUpdateFrame().getInstalledPanel().getTable();
            InstalledTableModel iTableModel = (InstalledTableModel)iTable.getModel();
            Update[] iUpdates = iTableModel.getUpdates();
            try {
                expandedUpdates = DataController.getInstance().getUninstaller().getExpandedUninstallList(aUpdates, iUpdates);
            }
            catch (CMDExecutionException cee) {
                Application.getInstance().getUpdateFrame().showWarningDialog("", I18N.getString("uninstall-needs-refresh"));
                Application.getInstance().getUpdateFrame().getInstalledPanel().forceRefresh();
                return;
            }
            UninstallDialog.this.worker = new UninstallWorker();
            UninstallDialog.this.worker.work(expandedUpdates);
        }
    }

    class CancelAction
    extends GenericAction {
        CancelAction() {
            super(I18N.getString("cancel"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            String localizedQuestionMsg = UpdateFrame.I18N.getString("cancel-question");
            String localizedTitle = UpdateFrame.I18N.getString("cancel-title");
            int n = Application.getInstance().getUpdateFrame().showConfirmDialog(Application.getInstance().getUpdateFrame().getDelegate().getUninstallDialog(), localizedQuestionMsg, localizedTitle);
            if (n == 0) {
                UninstallDialog.this.worker.interrupt();
            }
        }
    }
}

