/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.AvailableTableModel;
import com.sun.swup.client.ui.DateTableCellRenderer;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.InstalledTableModel;
import com.sun.swup.client.ui.UpdateFrame;
import com.sun.swup.client.ui.foundation.swing.GenericTable;
import com.sun.swup.client.ui.foundation.swing.GenericTableCellRenderer;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumnModel;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class InstalledTable
extends GenericTable {
    private WeakReference updateFrame;
    private JPanel checkPanel;
    private TableCellRenderer noCheckboxCellRenderer = new NoCheckboxCellRenderer();

    InstalledTable(UpdateFrame updateFrame, JPanel checkPanel) {
        this.setUpdateFrame(updateFrame);
        this.checkPanel = checkPanel;
        this.setName("installed-table");
        this.setSelectionMode(0);
        GenericTableColumnModel columnModel = new GenericTableColumnModel(this.getName());
        columnModel.addColumn(" ", -1, 40);
        columnModel.addColumn(UpdateFrame.I18N.getString("installed-table-name"), 2, 100);
        columnModel.addColumn(UpdateFrame.I18N.getString("installed-table-synopsis"), 2);
        columnModel.addColumn(UpdateFrame.I18N.getString("installed-table-date"), 2, 100);
        columnModel.getColumn(0).setResizable(false);
        columnModel.getColumn(3).setCellRenderer(new DateTableCellRenderer());
        Application.getInstance().getStateManager().restoreTableColumnWidths(columnModel);
        columnModel.addColumnModelListener(Application.getInstance().getStateManager());
        this.setColumnModel(columnModel);
        InstalledTableModel model = new InstalledTableModel();
        model.setColumnCount(columnModel.getColumnCount());
        this.setModel(model);
        SortedTableHeader sortedTableHeader = new SortedTableHeader(columnModel);
        this.setTableHeader(sortedTableHeader);
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreSortedTableColumn(sortedTableHeader, 3, -1);
        model.sortColumn(sortedTableHeader.getSortColumn(), sortedTableHeader.getSortDirection());
    }

    void autocheckDependencies(Dependency[] aDependency) {
        for (int i = 0; i < aDependency.length; ++i) {
            Dependency dependency = aDependency[i];
            for (int k = 0; k < this.getModel().getRowCount(); ++k) {
                String sName = (String)this.getModel().getValueAt(k, 1);
                for (int l = 0; l < dependency.getDependantsCount(); ++l) {
                    Update aUpdate = dependency.getDependant(l);
                    if (!sName.equals(aUpdate.getName())) continue;
                    this.getModel().setValueAt(new Boolean(true), k, 0);
                }
            }
        }
    }

    public TableCellRenderer getCellRenderer(int iRow, int iColumn) {
        InstalledTableModel model = (InstalledTableModel)this.getModel();
        Update update = model.getUpdateAt(iRow);
        if (iColumn == 0 && !update.isRemovable().booleanValue()) {
            return this.noCheckboxCellRenderer;
        }
        return super.getCellRenderer(iRow, iColumn);
    }

    public boolean isCellEditable(int iRow, int iColumn) {
        InstalledTableModel model = (InstalledTableModel)this.getModel();
        Update update = model.getUpdateAt(iRow);
        if (iColumn == 0) {
            if (!update.isRemovable().booleanValue()) {
                return false;
            }
            return super.isCellEditable(iRow, iColumn);
        }
        return super.isCellEditable(iRow, iColumn);
    }

    void removeUpdates(Update[] aUpdate) {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        AvailableTableModel model = (AvailableTableModel)this.getModel();
        model.removeUpdates(aUpdate);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    void removeUninstalledUpdates(Update[] updates) {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        InstalledTableModel model = (InstalledTableModel)this.getModel();
        model.removeUpdates(updates);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    void removeCheckedUpdates() {
        SortedTableHeader header = (SortedTableHeader)this.getTableHeader();
        InstalledTableModel model = (InstalledTableModel)this.getModel();
        Update[] checkedUpdates = model.getCheckedUpdates();
        model.removeUpdates(checkedUpdates);
        model.sortColumn(header.getSortColumn(), header.getSortDirection());
        model.fireTableDataChanged();
    }

    private void setUpdateFrame(UpdateFrame updateFrame) {
        this.updateFrame = new WeakReference<UpdateFrame>(updateFrame);
    }

    private UpdateFrame getUpdateFrame() {
        return (UpdateFrame)this.updateFrame.get();
    }

    class NoCheckboxCellRenderer
    extends GenericTableCellRenderer {
        NoCheckboxCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object oValue, boolean bSelected, boolean bHasFocus, int iRow, int iColumn) {
            oValue = new String("    -    ");
            return super.getTableCellRendererComponent(table, oValue, bSelected, bHasFocus, iRow, iColumn);
        }
    }
}

