/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.GenericEditorPane;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.Utility;
import java.awt.Font;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class HistoryEditorPane
extends GenericEditorPane {
    private Update update;

    HistoryEditorPane() {
        this.setEditable(false);
        this.setFont(Utility.getReducedFont(this, "small-font-reduction"));
        HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
        this.modifyStyleSheet(htmlEditorKit.getStyleSheet());
        this.setEditorKit(htmlEditorKit);
        this.addHyperlinkListener(new UpdatesHyperlinkListener());
        this.populate();
    }

    void setUpdate(Update update) {
        this.update = update;
        this.populate();
    }

    private void modifyStyleSheet(StyleSheet styleSheet) {
        Font font = this.getFont();
        String sFontFamily = font.getFamily();
        int iFontSize = font.getSize();
        styleSheet.addRule("body {font-family:" + sFontFamily + ";font-size:" + iFontSize + "pt;}");
    }

    private void populate() {
        if (this.update == null) {
            this.setText("");
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<body>");
            sb.append(UpdateUtility.getUpdateStatusMessage(this.update.getUpdateStatus(), this.update));
            sb.append("</body>");
            sb.append("</html>");
            this.setText(sb.toString());
            this.setCaretPosition(0);
        }
    }

    class UpdatesHyperlinkListener
    implements HyperlinkListener {
        UpdatesHyperlinkListener() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Utility.openURL(e.getURL().toString());
            }
        }
    }
}

