/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.interfaces.Update;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.DependenciesPanel;
import com.sun.swup.client.ui.Dependency;
import com.sun.swup.client.ui.UpdateDelegate;
import com.sun.swup.client.ui.UpdateUtility;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.GenericDialog;
import com.sun.swup.client.ui.foundation.swing.StateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;

class DependenciesDialog
extends GenericDialog {
    static I18NHelper I18N = new I18NHelper(class$com$sun$swup$client$ui$DependenciesDialog == null ? (class$com$sun$swup$client$ui$DependenciesDialog = DependenciesDialog.class$("com.sun.swup.client.ui.DependenciesDialog")) : class$com$sun$swup$client$ui$DependenciesDialog, "resources/strings/dependencies");
    private DependenciesPanel dependenciesPanel;
    private Dependency[] aDependency;
    private int dependencyType;
    private int dependenciesCount;
    static /* synthetic */ Class class$com$sun$swup$client$ui$DependenciesDialog;

    DependenciesDialog(Frame owner) {
        super(owner);
        this.setName("dependencies");
        this.dependencyType = Application.getInstance().getUpdateFrame().getDelegate().getDependencyType();
        if (this.dependencyType == 1) {
            this.setTitle(I18N.getString("title"));
            this.getAccessibleContext().setAccessibleName(I18N.getString("title"));
            this.getAccessibleContext().setAccessibleDescription(I18N.getString("install-description"));
        } else {
            this.setTitle(I18N.getString("confirm-uninstall-title"));
            this.getAccessibleContext().setAccessibleName(I18N.getString("confirm-uninstall-title"));
            this.getAccessibleContext().setAccessibleDescription(I18N.getString("uninstall-description"));
        }
        this.setResizable(true);
        this.setModal(true);
        this.setActionSet(new GenericActionSet());
        this.getActionSet().putAction("ok", new OKAction());
        this.getActionSet().putAction("cancel", new CancelAction());
        StateManager stateManager = Application.getInstance().getStateManager();
        stateManager.restoreWindowSize(this, new Dimension(550, 350));
        this.prepareDependencies();
        this.createComponents();
        this.createLayout();
        this.addComponentListener(Application.getInstance().getStateManager());
        this.populateDependencies();
    }

    DependenciesPanel getDependenciesPanel() {
        return this.dependenciesPanel;
    }

    private void createComponents() {
        this.dependenciesPanel = new DependenciesPanel(this);
    }

    private void createLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dependenciesPanel, "Center");
    }

    private void populateDependencies() {
        this.getDependenciesPanel().setDependencies(this.aDependency);
        this.getDependenciesPanel().getEditorPane().populate();
    }

    private void prepareDependencies() {
        UpdateDelegate updateDelegate = Application.getInstance().getUpdateFrame().getDelegate();
        if (this.dependencyType == 1) {
            Update[] aUpdate = updateDelegate.getInstallUpdates();
            this.aDependency = UpdateUtility.getDependentUpdates(aUpdate, 1);
            updateDelegate.setInstallDependencies(this.aDependency);
        } else {
            Update[] aUpdate = updateDelegate.getUninstallUpdates();
            this.aDependency = UpdateUtility.getDependentUpdates(aUpdate, 2);
            updateDelegate.setUninstallDependencies(this.aDependency);
        }
        this.dependenciesCount = this.aDependency != null ? this.aDependency.length : 0;
    }

    int getDependenciesCount() {
        return this.dependenciesCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CancelAction
    extends GenericAction {
        CancelAction() {
            super(I18N.getString("cancel"), true);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            DependenciesDialog.this.setVisible(false);
            DependenciesDialog.this.dispose();
        }
    }

    class OKAction
    extends GenericAction {
        OKAction() {
            super(I18N.getString("continue"), true);
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            int dependencyType = Application.getInstance().getUpdateFrame().getDelegate().getDependencyType();
            if (dependencyType == 1) {
                Application.getInstance().getUpdateFrame().getAvailablePanel().getTable().autocheckDependencies(DependenciesDialog.this.aDependency);
            } else {
                Application.getInstance().getUpdateFrame().getInstalledPanel().getTable().autocheckDependencies(DependenciesDialog.this.aDependency);
            }
            DependenciesDialog.this.setVisible(false);
            DependenciesDialog.this.dispose();
            Application.getInstance().getUpdateFrame().getDelegate().setDependenciesResolved(true);
            if (dependencyType == 1) {
                Application.getInstance().getUpdateFrame().getDelegate().install();
            } else {
                Application.getInstance().getUpdateFrame().getDelegate().uninstall();
            }
        }
    }
}

