/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui;

import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.UMData;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.PreferencesFrame;
import com.sun.swup.client.ui.PreferencesManager;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.Utility;
import com.sun.swup.client.ui.foundation.swing.GenericAction;
import com.sun.swup.client.ui.foundation.swing.GenericActionSet;
import com.sun.swup.client.ui.foundation.swing.InsetPanel;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class ButtonPanel
extends InsetPanel {
    private static final boolean USE_ADVANCED_PREFERENCES = false;
    private WeakReference preferencesFrame;
    private ArrayList buttonArrayList;
    public JButton okButton;
    private JButton cancelButton;
    private JButton applyButton;

    ButtonPanel(PreferencesFrame preferencesFrame) {
        this.setPreferencesFrame(preferencesFrame);
        this.getPreferencesFrame().getActionSet().putAction("ok", new OKAction());
        this.getPreferencesFrame().getActionSet().putAction("cancel", new CancelAction());
        this.getPreferencesFrame().getActionSet().putAction("apply", new ApplyAction());
        this.getPreferencesFrame().getActionSet().getAction("ok").setEnabled(true);
        this.getPreferencesFrame().getActionSet().getAction("cancel").setEnabled(true);
        this.getPreferencesFrame().getActionSet().getAction("apply").setEnabled(true);
        this.createComponents();
        this.createLayout();
    }

    private void createComponents() {
        this.buttonArrayList = new ArrayList();
        GenericActionSet actionSet = this.getPreferencesFrame().getActionSet();
        this.okButton = this.registerButton(new JButton(actionSet.getAction("ok")));
        this.okButton.setMnemonic(PreferencesFrame.I18N.getString("ok.mnemonic").charAt(0));
        this.okButton.setDefaultCapable(true);
        this.getPreferencesFrame().getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = this.registerButton(new JButton(actionSet.getAction("cancel")));
        this.cancelButton.setMnemonic(PreferencesFrame.I18N.getString("cancel.mnemonic").charAt(0));
        this.applyButton = this.registerButton(new JButton(actionSet.getAction("apply")));
        this.applyButton.setMnemonic(PreferencesFrame.I18N.getString("apply.mnemonic").charAt(0));
        this.disableApplyButton();
    }

    private JButton registerButton(JButton button) {
        this.buttonArrayList.add(button);
        return button;
    }

    private void createLayout() {
        this.syncButtonWidths();
        this.setInsets(new Insets(6, 6, 6, 6));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.okButton);
        this.add(Box.createRigidArea(new Dimension(5, 4)));
        this.add(this.cancelButton);
        this.add(Box.createRigidArea(new Dimension(5, 4)));
        this.add(this.applyButton);
        this.add(Box.createVerticalGlue());
    }

    private void syncButtonWidths() {
        int i;
        int iWidth = 0;
        for (i = 0; i < this.buttonArrayList.size(); ++i) {
            JComponent component;
            Object object = this.buttonArrayList.get(i);
            if (!(object instanceof JComponent) || !((component = (JComponent)object).getPreferredSize().getWidth() > (double)iWidth)) continue;
            iWidth = (int)component.getPreferredSize().getWidth();
        }
        for (i = 0; i < this.buttonArrayList.size(); ++i) {
            JComponent component = (JComponent)this.buttonArrayList.get(i);
            component.setPreferredSize(new Dimension(iWidth, (int)component.getPreferredSize().getHeight()));
            component.setMinimumSize(new Dimension(iWidth, (int)component.getPreferredSize().getHeight()));
            component.setMaximumSize(new Dimension(iWidth, (int)component.getPreferredSize().getHeight()));
            component.setAlignmentX(0.5f);
        }
        this.buttonArrayList.clear();
        this.buttonArrayList = null;
    }

    private void setPreferencesFrame(PreferencesFrame preferencesFrame) {
        this.preferencesFrame = new WeakReference<PreferencesFrame>(preferencesFrame);
    }

    private PreferencesFrame getPreferencesFrame() {
        return (PreferencesFrame)this.preferencesFrame.get();
    }

    public void enableApplyButton() {
        this.applyButton.setEnabled(true);
    }

    public void disableApplyButton() {
        this.applyButton.setEnabled(false);
    }

    private void registerSystem() {
        switch (UMData.getLpsToSunBR()) {
            case 2: {
                if (UMData.getSystemRegistrationReqd()) {
                    Application.getInstance().displayRegistration(100);
                    break;
                }
                CCRUtils.setCCRValueAuthenticated((String)"cns.swup.regRequired", (String)"true");
                break;
            }
            case 1: {
                CCRUtils.setCCRValueAuthenticated((String)"cns.swup.regRequired", (String)"false");
                break;
            }
        }
        UMData.setLpsToSunBR((int)-1);
    }

    class CancelAction
    extends GenericAction {
        CancelAction() {
            super(PreferencesFrame.I18N.getString("cancel"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            if (PreferencesManager.getInstance().checkForChange()) {
                Object[] options = new Object[]{PreferencesFrame.I18N.getString("yes"), PreferencesFrame.I18N.getString("no"), PreferencesFrame.I18N.getString("cancel")};
                int n = JOptionPane.showOptionDialog(ButtonPanel.this.getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.confirm.msg"), PreferencesFrame.I18N.getString("prefs.confirm.title"), 1, -1, null, options, options[2]);
                switch (n) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        ButtonPanel.this.getPreferencesFrame().setVisible(false);
                        ButtonPanel.this.getPreferencesFrame().dispose();
                        Application.getInstance().clearPreferencesFrame();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 0: {
                        ButtonPanel.this.okButton.doClick();
                    }
                }
            } else {
                ButtonPanel.this.getPreferencesFrame().setVisible(false);
                ButtonPanel.this.getPreferencesFrame().dispose();
                Application.getInstance().clearPreferencesFrame();
            }
        }
    }

    class ApplyAction
    extends GenericAction {
        ApplyAction() {
            super(PreferencesFrame.I18N.getString("apply"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            if (PreferencesManager.getInstance().checkForChange()) {
                ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getPredefinedCursor(3));
                Vector results = PreferencesManager.getInstance().validateElements();
                if (results.size() > 0) {
                    String errors = "";
                    for (int i = 0; i < results.size(); ++i) {
                        errors = errors + PreferencesFrame.I18N.getString("prefs.validation." + (String)results.elementAt(i)) + "\n";
                    }
                    ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getDefaultCursor());
                    WarningDialog warnDialog = new WarningDialog((Frame)ButtonPanel.this.getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.validation.title"), errors);
                    Utility.centerOverFrame(warnDialog, (JFrame)ButtonPanel.this.getPreferencesFrame());
                    warnDialog.setVisible(true);
                } else {
                    boolean preferencesSetOk = PreferencesManager.getInstance().captureElements();
                    if (preferencesSetOk) {
                        ButtonPanel.this.applyButton.setEnabled(false);
                        ButtonPanel.this.registerSystem();
                    }
                    ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getDefaultCursor());
                    if (!preferencesSetOk) {
                        JOptionPane.showMessageDialog(ButtonPanel.this.getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.write.error"), PreferencesFrame.I18N.getString("prefs.write.title"), 0);
                    }
                }
            }
        }
    }

    class OKAction
    extends GenericAction {
        OKAction() {
            super(PreferencesFrame.I18N.getString("ok"));
        }

        public void actionPerformed(ActionEvent e, boolean bInvokedLater) {
            if (PreferencesManager.getInstance().checkForChange()) {
                ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getPredefinedCursor(3));
                Vector results = PreferencesManager.getInstance().validateElements();
                if (results.size() > 0) {
                    String errors = "";
                    for (int i = 0; i < results.size(); ++i) {
                        errors = errors + PreferencesFrame.I18N.getString("prefs.validation." + (String)results.elementAt(i)) + "\n";
                    }
                    ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getDefaultCursor());
                    WarningDialog warnDialog = new WarningDialog((Frame)ButtonPanel.this.getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.validation.title"), errors);
                    Utility.centerOverFrame(warnDialog, (JFrame)ButtonPanel.this.getPreferencesFrame());
                    warnDialog.setVisible(true);
                } else {
                    boolean preferencesSetOk = PreferencesManager.getInstance().captureElements();
                    ButtonPanel.this.getPreferencesFrame().setCursor(Cursor.getDefaultCursor());
                    if (preferencesSetOk) {
                        ButtonPanel.this.getPreferencesFrame().setVisible(false);
                        ButtonPanel.this.getPreferencesFrame().dispose();
                        Application.getInstance().clearPreferencesFrame();
                        ButtonPanel.this.registerSystem();
                    } else {
                        JOptionPane.showMessageDialog(ButtonPanel.this.getPreferencesFrame(), PreferencesFrame.I18N.getString("prefs.write.error"), PreferencesFrame.I18N.getString("prefs.write.title"), 0);
                    }
                }
            } else {
                ButtonPanel.this.getPreferencesFrame().setVisible(false);
                ButtonPanel.this.getPreferencesFrame().dispose();
                Application.getInstance().clearPreferencesFrame();
            }
        }
    }
}

