<?xml version="1.0"?>
<!DOCTYPE wml PUBLIC "-//WAPFORUM//DTD WML 1.1//EN" "http://www.wapforum.o
rg/DTD/wml_1.1.xml">

<%@ include file="layoutSetup.jsp" %>

<dt:obtainContainer container="$wireless"> 

<%-- The presentation of layout edit page --%>
<wml>

  <jx:choose>
  <jx:when test="$hasMovableChannels == true">

  <card id="Layout" title="Arrange Channels">

    <do type="prev" label="Back">
      <prev/>
    </do>

    <p align="left" mode="nowrap">
      <jx:forEach var="channel" items="$orderedChannelList">
        <dtcpc:obtainChannelFromContainer channel="$channel">
          <anchor title="Move"><dt:getTitle/>
            <go href="#Move">
              <setvar name="movingChannel" value="<dt:getName/>"/>
            </go>
          </anchor><br/>
        </dtcpc:obtainChannelFromContainer>
      </jx:forEach>
      <anchor title="Home">Portal Home
        <go href="<dtpc:getDesktopURL/>"/>
      </anchor><br/>
    </p>
  </card>

  <card id="Move">
    <do type="prev" label="Back">
      <prev/>
    </do>

    <%-- set next url --%> 
    <%
        String qstr = "action=edit&provider=WirelessJSPLayoutChannel&container="+container;
        pageContext.setAttribute("nexturl", cpc.getDesktopURL(request, qstr, true));
    %>



    <p align="left" mode="nowrap">
      <anchor title="Move Up">Move Up
        <go method="post" href="<%=desktopURL%>">
          <postfield name="action" value="process"/>
          <postfield name="provider" value="WirelessJSPLayoutChannel"/>
          <postfield name="container" value="<%=container%>"/>
          <postfield name="moveUp" value="$(movingChannel)"/>
          <postfield name="nextURL" value="<%=pageContext.getAttribute("nexturl").toString()%>"/>
        </go>
      </anchor>
      <br/>
      <anchor title="Move Down">Move Down
        <go method="post" href="<%=desktopURL%>">
          <postfield name="action" value="process"/>
          <postfield name="provider" value="WirelessJSPLayoutChannel"/>
          <postfield name="container" value="<%=container%>"/>
          <postfield name="moveDown" value="$(movingChannel)"/>
          <postfield name="nextURL" value="<%=pageContext.getAttribute("nexturl").toString()%>"/>
        </go>
      </anchor>
    </p>
  </card>
  </jx:when>
  <jx:otherwise>
    <card id="LayoutEmpty" title="Arrange Channels">
    <do type="prev" label="Back">
      <prev/>
    </do>
    <p align="left" mode="nowrap">
    <b>No channels to move. Layout can not be changed</b>
    </p>
    <p>
    <anchor title="Home">Home
        <go href="<dtpc:getDesktopURL/>" method="get"/>
    </anchor>
   </p>
    </card>
   </jx:otherwise>
   </jx:choose>
    
</wml>

</dt:obtainContainer>
