<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>

<%@ page import="com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider,
                 com.sun.portal.providers.ProviderException,
                 com.sun.portal.providers.context.ContainerProviderContext,
                 com.sun.portal.providers.context.ProviderContextException,
                 java.util.Map,
                 java.util.HashMap,
                 java.util.Iterator,
                 java.util.List,
                 com.sun.portal.wireless.providers.containers.DesktopDispatcherProvider,
                 java.util.ResourceBundle,
                 com.sun.portal.providers.containers.ContainerProvider,
                 com.sun.portal.wireless.providers.containers.template.WirelessContainerProviderAdapter,
                 com.sun.portal.wireless.providers.containers.jsp.WirelessJSPContainerProviderAdapter,
                 com.sun.portal.wireless.providers.containers.WirelessContainerProvider"
%>

<%-- Setup the required params and objects --%>
<%
  // Get the client that we will be operating on
  String clientParam = request.getParameter("client");

  JSPSingleContainerProvider scp = (JSPSingleContainerProvider)pageContext.getAttribute("JSPProvider");
  String parentContainer = scp.getProviderContext().getDefaultChannelName();
  String parentContainerProvider = scp.getProviderContext().getProviderName(parentContainer);
  pageContext.setAttribute("pc", parentContainer);
  pageContext.setAttribute("pcp", parentContainerProvider);

  ContainerProviderContext context = scp.getContainerProviderContext();

  ResourceBundle bundle = null;
  try {
      bundle = scp.getResourceBundle("DeviceNames");
  } catch (ProviderException e) {
      scp.getProviderContext().debugError("layoutSetup.jsp: ", e);
  }

  List selectedChannelList = null;
  String containerName = null;
  WirelessContainerProvider clientContainer;

  containerName = DesktopDispatcherProvider.getClientContainerName(context, clientParam);
  clientContainer = (WirelessContainerProvider)context.getProvider(request, null, containerName);

    if (clientContainer != null) {
        pageContext.setAttribute("clientContainer", clientContainer);
        selectedChannelList = clientContainer.getOrderedSelectedChannels(request, true);
    }

    String listSize = null;
  if ((selectedChannelList != null) && (selectedChannelList.size() > 0)) {
	listSize =  String.valueOf(selectedChannelList.size());
	pageContext.setAttribute("selectedChannels", selectedChannelList);
	pageContext.setAttribute("hasMovableChannels", new Boolean("true"));
  } else {
    pageContext.setAttribute("selectedChannels", "");
	pageContext.setAttribute("hasMovableChannels", new Boolean("false"));
  }


    // Get the isMinimizable flag
    boolean isMinimizable = context.getBooleanProperty(containerName, "defaultChannelIsMinimizable", false) &&
                            context.getBooleanProperty(containerName, "defaultChannelIsMaximizable", false);
    boolean channelsAreMinimized = false;

    if (isMinimizable) {

      // Get the minimized flag
      channelsAreMinimized = context.getBooleanProperty(containerName, "defaultChannelIsMinimized");

    }

  String clientName = null;

    if (clientParam != null) {
        try {
            clientName = bundle.getString(clientParam);
        } catch (Exception e) {
            clientName = clientParam;
        }
    }

%>
