<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>
<%@ page session="false" %>
<%@ include file="contentSetup.jsp" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktopContainerProviderContext.tld" prefix="dtcpc" %>
<%@ taglib uri="/tld/desktopTheme.tld" prefix="dttheme" %>
<%@ taglib uri="/tld/desktopSingle.tld" prefix="dtsingle" %>
<%@ taglib uri="/tld/jx.tld" prefix="jx" %>

<%-- contentedit.jsp --%>

<%-- The presentation of content edit page --%>

<dt:obtainContainer container="$JSPProvider">
<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceHeader.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultHeader.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>
<center>
  <form action="<dtpc:getDesktopURL/>" method=POST enctype="application/x-www-form-urlencoded">
    <input type=hidden name="action" size=-1 value="process">
    <input type=hidden name="provider" size=-1 value="<dt:getName/>">
    <input type=hidden name="container" size=-1 value=<%=containerName%>>
    <br>
    <table border="1" cellpadding="0" cellspacing="0" width="100%">
      <tr>
        <td align="center">
          <center>
            <table border="0" cellpadding="2" cellspacing="0" width="100%">
	      <tr>
                <td align="top" colspan="2" bgcolor=<dttheme:getAttribute name="titleBarColor"/>>
                  <font size="+2" color=<dttheme:getAttribute name="bgColor"/> face=<dttheme:getAttribute name="fontFace"/>>
                    <b><%=clientName%> Channels</b>
                  </font>
                </td>
              </tr>
              <tr>
                <td colspan="2" bgcolor=<dttheme:getAttribute name="borderColor"/>>
                  <font size="+0" face=<dttheme:getAttribute name="fontFace"/>>
                    Select the Channels you would like displayed on your mobile device.
                  </font>
                </td>
              </tr>
              <tr>
</dt:obtainContainer>
                <td align="top">
				<% ContainerProvider c = (ContainerProvider) pageContext.getAttribute("clientContainer");
				if((c != null) && (c instanceof WirelessJSPContainerProviderAdapter)){
				  %>
                <dt:obtainContainer container="$clientContainer">
                  <jx:forEach var="channel" items="$availableChannels">
                    <jx:set var="checked" value=""/>
                    <% if(((List) pageContext.getAttribute("selectedChannels")).
                           contains(pageContext.getAttribute("channel"))) {
                    %>
                       <jx:set var="checked" value="checked"/>
                    <% } %>
                    <dtcpc:obtainChannelFromContainer channel="$channel">
                      <input type="checkbox" name="content" id="<dt:getName/>" value="<dt:getName/>" <%=pageContext.getAttribute("checked")%>><b><label for="<dt:getName/>"><dt:getTitle/></label></b><br>
                      <dt:getDescription/><p>
                    </dtcpc:obtainChannelFromContainer>
                  </jx:forEach>
                </dt:obtainContainer>
				  <%
				}%>
				<%-- Have to do the following scriptlet code as the 
				     obtainContainer tag doesnt work if the container is 
					 TemplateDesktop Container.
			 	--%>
				<%
				if(c instanceof WirelessContainerProviderAdapter){ %>
                  <jx:forEach var="channel" items="$availableChannels">
					<%   
					String title = context.getStringProperty((String)pageContext.getAttribute("channel"), "title");
					String description = context.getStringProperty((String)pageContext.getAttribute("channel"), "description");
                    if(((List) pageContext.getAttribute("selectedChannels")).
                           contains(pageContext.getAttribute("channel"))) {
                    %>
                        <input type="checkbox" name="content" id="<%=pageContext.getAttribute("channel")%>" value="<%=pageContext.getAttribute("channel")%>" checked><b><label for="<%=pageContext.getAttribute("channel")%>"><%=title%></label></b><br>
                    <%} else {%>
                        <input type="checkbox" name="content" id="<%=pageContext.getAttribute("channel")%>" value="<%=pageContext.getAttribute("channel")%>"><b><label for="<%=pageContext.getAttribute("channel")%>"><%=title%></label></b><br>
                    <%}%>
                  	<%=description%><p>
                  </jx:forEach>
				<% } %>
                </td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
            </table>
          </center>
        </td>
      </tr>
    </table>
    <br>
<dt:obtainContainer container="$JSPProvider">
    <font size=+0 face=<dttheme:getAttribute name="fontFace"/>>
      <input type="submit" name="Submit" value="Finished" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
	  <%
        Map map = new HashMap();
        map.put("action", "edit");
        map.put("provider", "WirelessJSPClientConfigContainer");
        pageContext.setAttribute("desktop_qmap", map);

      %>
      <input type="button" onclick="location='<dtpc:getDesktopURL querymap="$desktop_qmap" escape="true"/>'" value="Cancel" class="button" style='background-color:<dttheme:getAttribute name="titleBarColor" default="#333366"/>;color:<dttheme:getAttribute name="titleFontColor" default="#FFFFFF"/>'>
    </font>
    <br>
  </form>
  <p>
</center>
</body>
</html>


<jx:choose>
  <jx:when test="$pc == 'FrameTabContainer'">
    <jsp:include page="framePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTabContainerProvider'">
    <jsp:include page="tabPreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPTableContainerProvider'">
    <jsp:include page="tablePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:when test="$pcp == 'JSPSingleContainerProvider'">
    <jsp:include page="singlePreferenceMenubar.jsp" flush="true"/>
  </jx:when>
  <jx:otherwise>
    <jsp:include page="defaultMenubar.jsp" flush="true"/>
  </jx:otherwise>
</jx:choose>

<%@ include file="footer.html" %>

</dt:obtainContainer>
