<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>

<%@ page session="false" %>

<%-- contentdoedit.jsp --%>

<%@ page import="com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider,
                 com.sun.portal.providers.ProviderException,
                 com.sun.portal.providers.context.ContainerProviderContext,
				 java.util.*,
                 com.sun.portal.wireless.providers.containers.WirelessContainerProvider"
%>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>

<%
    JSPSingleContainerProvider scp = (JSPSingleContainerProvider)pageContext.getAttribute("JSPProvider");

    // read container name passed from client config provider
    String containerName = request.getParameter("container");
    if (containerName == null) {
        throw new ProviderException("contentdoedit.jsp: " +
                "container parameter missing.");
    }
    ContainerProviderContext context = scp.getContainerProviderContext();
    WirelessContainerProvider clientContainer;
    clientContainer = (WirelessContainerProvider)context
            .getProvider(request, null, containerName);

    if (clientContainer != null) {

        boolean defaultIsRemovable =
                context.getBooleanProperty(containerName,
                        "defaultChannelIsRemovable",
                        false);

        boolean isRemovableFlag = false;
        Map isRemovableChannels = context.getCollectionProperty(containerName,
                "channelsIsRemovable");
        ArrayList newList  = new ArrayList();

        List selectedChannels = clientContainer.getOrderedSelectedChannels(request);
        List availableChannels = clientContainer.getAvailableChannels(request);
        int numavailableChannels = availableChannels.size();

        String[] selected = null;

        String content = request.getParameter("content");

        if ((content != null) && (!content.equals(""))) {

            selected = request.getParameterValues("content");

            for (int j=0; j<selected.length; j++) {
                newList.add(selected[j]);
            }
        }

        for (int i=0; i < numavailableChannels; i++) {

            //First get the channel from available list
            String channel = (String) availableChannels.get(i);

            //Check if its removable
            Object isRemovableValue = isRemovableChannels.get(channel);

            if (isRemovableValue != null) {
                isRemovableFlag = ((Boolean) isRemovableValue).booleanValue();

            } else {
                isRemovableFlag = defaultIsRemovable;
            }

            //if the channel is not removable move on
            if (!isRemovableFlag) {
                continue;
            }

            // If it is indeed a removable channel
            if ((!newList.contains(channel)) && (selectedChannels.contains(channel))) {
                // channel has been unselected so remove it
                selectedChannels.remove(channel);

            } else if ((newList.contains(channel)) && (!selectedChannels.contains(channel))) {
                // channel is newly selected so add it
                selectedChannels.add(channel);
            }
        }

        //store the selection
        clientContainer.setSelectedChannels(selectedChannels);

    }

    Map map = new HashMap();
    map.put("action", "edit");
    map.put("provider", "WirelessJSPClientConfigContainer");
    pageContext.setAttribute("desktop_map", map);
%>

<dt:obtainContainer container="$JSPProvider">
<dtpc:getDesktopURL id="url" querymap="$desktop_map"/>
<%
  response.sendRedirect((String)pageContext.getAttribute("url"));
%>
</dt:obtainContainer>

