<%--
    PROPRIETARY/CONFIDENTIAL. Use of this product is subject to license terms.
    Copyright 2003 Sun Microsystems, Inc. All rights reserved.
--%>

<%-- layoutedit.jsp --%>

<%@ include file="layoutSetup.jsp" %>

<dt:obtainContainer container="$wireless"> 

    <%-- The presentation of desktop layout edit page --%>

    <%-- 
    NOTE: 
        We need to add an arbitrary querystring parameter to desktop URL, 
        to workaround a defect in Treo browser's URL caching policy where
        it caches the POST url and does not do a GET afterwards on the same
        URL
    --%>
  
  <AmlDocument>
    <jx:choose>
    <jx:when test="$hasMovableChannels == true" >
        <AmlPage  id="layout" bold="true" title="Channel Layout Selection" menu_pos="bottom">

            <AmlForm url="<dtpc:getDesktopURL/>" method="post" submit_label="Move Up">

                <AmlChoice value="" name="moveUp" mode="single" wml_select_label="Move Up" scroll_size="<%=listSize%>">
                    <jx:forEach var="channel" items="$orderedChannelList">
                        <dtcpc:obtainChannelFromContainer channel="$channel">
                            <AmlOption value="<dt:getName/>" text="<dt:getTitle/>"/>
                        </dtcpc:obtainChannelFromContainer>
                    </jx:forEach>
                </AmlChoice>

                <AmlInput name="action" view="hidden" value="process"/>
                <AmlInput name="provider" view="hidden" value="JSPRenderingLayoutChannel"/>
                <AmlInput name="container" view="hidden" value="<%=container%>"/>

            </AmlForm>

            <AmlControlMenu url="<dtpc:getDesktopURL querystring="a=1" />" label="Home"/>
        </AmlPage>
    </jx:when>
    <jx:otherwise>
        <AmlPage id="empty_layout" bold="true" title="Channel Layout Selection" menu_pos="bottom">
            <AmlBr/>
            <AmlText bold="true" text="No channels to move. Layout can not be changed"/>
            <AmlBr/>
            <AmlControlMenu url="<dtpc:getDesktopURL querystring="a=1" />" label="Home"/>
        </AmlPage>
    </jx:otherwise>
    </jx:choose>
  </AmlDocument>
</dt:obtainContainer>
