<%@ page session="false" %><%
%><%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%
%><util:nocache/><util:content type="text/plain" /><%
%><?xml version="1.0"?>
<util:include file="docTypeDeclaration.jsp" comp="common"/>
      
<%@ page import="java.util.*" %>
<%@ page import="com.iplanet.sso.SSOToken" %>
<%@ page import="com.iplanet.sso.SSOTokenManager" %>
<%@ page import="com.iplanet.sso.SSOException" %>
<%@ page import="com.iplanet.am.util.Debug" %>

<%-- 
  PROPRIETARY/CONFIDENTIAL. Use of this product is subject to license terms. 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved. 
--%>

<vxml version="2.0">
  <form id="loadApp">
    <var name="p_root"/>
    <var name="p_persona"/>
<%
  Debug debug = Debug.getInstance("Voicelet");
  SSOToken token = null;

  try {
    token = SSOTokenManager.getInstance().createSSOToken(request);
  } catch (SSOException se) {
    debug.error("Cannot get SSOToken", se);
  }

  if (token != null) {
    String key = "LoadedVoicelets";

    String component = request.getParameter("comp");

    // this can be either "load" or "unload" only
    String action = request.getParameter("action");

    // for load actions we need to do whole set of different things
    boolean action_is_load = "load".equals(action);
    
    // SSOToken only stores a String and nothing else ;-(
    String loaded_voicelets_as_string = null;

    try {
      loaded_voicelets_as_string = (String) token.getProperty(key);
    } catch (SSOException se) {
    }

    Set loadedVoicelets = null;

    // Try to convert this string into a HashSet
    if (loaded_voicelets_as_string != null) {
      StringTokenizer tokenizer = new StringTokenizer(loaded_voicelets_as_string);

      int count = tokenizer.countTokens();
      if (count > 0) {
        loadedVoicelets = new HashSet(count);
      
        for (int i = 0; i < count; i++) {
          loadedVoicelets.add(tokenizer.nextToken());
        }
      }
    }

    if ((action_is_load) && (component != null)) {
      if ((loadedVoicelets == null) || (! loadedVoicelets.contains(component))) {
        if (loadedVoicelets == null) {
          loaded_voicelets_as_string = component;
        } else {
          loadedVoicelets.add(component);
  
          StringBuffer buffer = new StringBuffer(128);
  
          Iterator iterator = loadedVoicelets.iterator();
          while (iterator.hasNext()) {
            String loaded_component = (String) iterator.next();
            if (loaded_component != null) {
              buffer.append(loaded_component);
              if (iterator.hasNext()) {
                buffer.append(' ');
              }
            }
          }

          loaded_voicelets_as_string = buffer.toString();
        }
  
        // store this list back in the token
        try {
          token.setProperty(key, loaded_voicelets_as_string);
        } catch (SSOException se) {
        }

        String name_of_load_jsp = component + "Load.jsp";
%>
    <subdialog name="load" src="<util:url file="<%= name_of_load_jsp %>" comp="<%= component %>"/>">
      <param name="p_root"    expr="p_root"/>
      <param name="p_persona" expr="p_persona"/>
    </subdialog>
<%
      }

      String name_of_app_jsp  = component + "App.jsp";
%>
    <subdialog name="app" src="<util:url file="<%= name_of_app_jsp %>" comp="<%= component %>"/>">
      <param name="p_root"    expr="p_root"/>
      <param name="p_persona" expr="p_persona"/>
    </subdialog>
<%
    }
%>    
    <block>
      <goto next="#dispatchDone"/>
    </block>
  </form>

  <form id="unloadApp">
    <var name="p_root"/>
    <var name="p_persona"/>
<%
    if ((! action_is_load) && (loadedVoicelets != null) && (! loadedVoicelets.isEmpty())) {
      
      Iterator iterator = loadedVoicelets.iterator();
      while (iterator.hasNext()) {
        
        String unload_component = (String) iterator.next();
        if (unload_component != null) {
          String name_of_unload_jsp = unload_component + "Unload.jsp";
%>
    <subdialog name="unload_<%= unload_component %>" src="<util:url file="<%= name_of_unload_jsp %>" comp="<%= unload_component %>"/>">
      <param name="p_root"    expr="p_root"/>
      <param name="p_persona" expr="p_persona"/>
    </subdialog>
<%
        }
      }

      try {
        // store the empty list now
        token.setProperty(key, "");
      } catch (SSOException se) {
        // do nothing
      }
    }
  }
%>
    <block>
      <goto next="#dispatchDone"/>
    </block>
  </form>

  <form id="dispatchDone">
    <block>
      <return/>
    </block>
  </form>  
</vxml>
