<%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%
%><util:nocache/><util:content type="text/plain" /><%
%><?xml version="1.0"?>
<util:include file="docTypeDeclaration.jsp" comp="common"/>

<%@ page session="false" %>

<%
  // get the request parameter - the number to be spoken
  String number_as_string = request.getParameter("speakNum");
	  
  int number = 0;
  try {
    Integer anInt = new Integer(number_as_string);
    number = anInt.intValue();
  } catch (NumberFormatException e) {
    Float aFloat = new Float(number_as_string);
    number = aFloat.intValue();
  }
%>

<%--
  This subdialog will speak a number.
    
  The jsp input parameter (speakNum) is passed in with the request. The other
  <subdialog> parameters (prompt_path, num) are passed in through the usual
  vxml mechanism.
--%>

<vxml version="2.0">
  <%-- document variables --%>
  <var name="num" expr="<%= number %>" />
  
  <%-- subdialog entry point --%>

  <form id="main">

    <%-- subdialog variables --%>
    <var name="prompt_path" />

    <block>
      <%-- since we deal only with positive numbers, check for anything less than 0 --%>
      <if cond="num &lt; 1" >
      	<prompt>
          <audio expr="prompt_path + 'no.wav'" />
      	</prompt>
      	<return/>
      </if>

      <%-- if we're here then the number was greater than zero --%>
      <prompt>
<%
  int value = number;

  int BILLION  = 1000000000;
  int MILLION  = 1000000;
  int THOUSAND = 1000;
  int HUNDRED  = 100;

  boolean say_and = false;
		
  // If the number more than a billion
  if (value >= BILLION) {		    
    int billions = value/BILLION;
    value -= billions*BILLION;
%>
	<audio expr="prompt_path + '<%= billions %>'+'.wav'"/>
	<audio expr="prompt_path + 'billion.wav'"/>
<%
    say_and = true;
  }

  if (value >= MILLION) {
    int millions = value/MILLION;
    value -= millions*MILLION;

    if ((say_and) && (value == 0)) {
%>
	<audio expr="prompt_path + 'and.wav'"/>
<%
    }

    if (millions >= HUNDRED) {
      int hundreds_of_millions = millions/HUNDRED;
      millions -= hundreds_of_millions*HUNDRED;		      
%>		    
	<audio expr="prompt_path + '<%= hundreds_of_millions %>'+'.wav'"/>
	<audio expr="prompt_path + 'hundred.wav'"/>
<%
    }

    if (millions > 0) {			  
%>		    
	<audio expr="prompt_path + '<%= millions %>'+'.wav'"/>
<%
    }
%>		    
	<audio expr="prompt_path + 'million.wav'"/>
<%
    say_and = true;
  }
		  
  if (value >= THOUSAND) {
    int thousands = value/THOUSAND;
    value -= thousands*THOUSAND;

    if ((say_and) && (value == 0)) {
%>
	<audio expr="prompt_path + 'and.wav'"/>
<%
    }

    if (thousands >= HUNDRED) {
      int hundreds_of_thousands = thousands/HUNDRED;
      thousands -= hundreds_of_thousands*HUNDRED;		      
%>		    
	<audio expr="prompt_path + '<%= hundreds_of_thousands %>'+'.wav'"/>
	<audio expr="prompt_path + 'hundred.wav'"/>
<%
    }

    if (thousands > 0) {			  
%>		    
	<audio expr="prompt_path + '<%= thousands %>'+'.wav'"/>
<%
    }
%>		    
	<audio expr="prompt_path + 'thousand.wav'"/>
<%
    say_and = true;
  }

  if (value >= HUNDRED) {
    int hundreds = value/HUNDRED;
    value -= hundreds*HUNDRED;

    if ((say_and) && (value == 0)) {
%>
	<audio expr="prompt_path + 'and.wav'"/>
<%
    }
%>		    
	<audio expr="prompt_path + '<%= hundreds %>'+'.wav'"/>
	<audio expr="prompt_path + 'hundred.wav'"/>
<%
    say_and = true;
  }

  if ((say_and) && (value > 0)) { 
%>
	<audio expr="prompt_path + 'and.wav'"/>
<%
  }

  if (! ((say_and) && (value == 0))) {
%>				  
	<audio expr="prompt_path + '<%= value %>'+'.wav'"/>
<%
  }
%>
      </prompt>

      <goto next="#dialogdone"/>			
    </block>
  </form>

  <%-- return from subdialog --%>
  <form id="dialogdone">
    <block>
      <return/>
    </block>
  </form>
</vxml>
