<%-- 
  Copyright 2003 Sun Microsystems, Inc. All rights reserved 
  Use is subject to license terms. 
--%><%
%><%@ page errorPage="/jsp/default/errorpage.jsp" %><%
%><%@ page session="false" %><%
%><%@ page import="com.sun.comclient.calendar.RecurrencePattern" %><%

%><%@ taglib uri="/WEB-INF/wireless_cal.tld" prefix="cal" %><%
%><%@ taglib uri="/WEB-INF/wireless_util.tld" prefix="util" %><%
%><%@ taglib uri="/WEB-INF/wireless_socs.tld" prefix="socs" %><%

%><util:content/><%

%><util:catalog resource="cal" id="i18n" /><%
%><cal:context/><%

%><%--
	Get current view date from parameter and do a fetch. This is a workaround
        to synchronize task list when user selects browser "Back" button to 
        navigate.
--%><%

%><cal:datetime id="view"><%
%><cal:dateformat name="view" format="yyyyMMdd" parse="$(d)"/><%
%></cal:datetime><%

%><cal:fetch day="view"/><%


%><%-- 
 	Get task by tid argument and display task details:
	<card>
	<p>
	11:00 <br/>
	Title: Meeting<br/>
	Location: X File<br/>
	Staff Meeting<br/>
--%><%
    %><util:edit id="edit1"><%
      %><%-- No more than 25 characters for summary --%><%
      %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspSummaryLength:25/"/><%
      %><util:set property="escape" value="true"/><%
    %></util:edit><%

    %><util:edit id="edit2"><%
      %><%-- No more than 300 characters for description --%><%
      %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspDescLength:300/"/><%
      %><util:set property="escape" value="true"/><%
    %></util:edit><%

    %><%-- set character entity escaping and truncation to 25 characters --%><%
    %><%-- truncation is for location --%><%
    %><util:edit id="edit3"><%
      %><util:set property="truncation" value="$/SunMobileAppCalendarService:sunMobileAppCalendarJspLocationLength:25/"/><%
      %><util:set property="escape" value="true"/><%
    %></util:edit><%

%><%-- view task details --%>
<AmlDocument> 
<AmlPage id="task" menu_pos="bottom" bold="true" title="<util:msg name="i18n" key="changetask"/>"><%

  %><cal:task id="task" index="$(tid)"><%

  %><%-- summary --%><%
  %><AmlText text="<util:msg name="i18n" key="subj"/>: <cal:get property="summary" edit="edit1"/>"/><%
  %><AmlBr/><%

  %><%-- due date and time --%><%
    %><util:if property="due"><%
        %><cal:get id="duedate" property="dueDate"/><%
        %><AmlText text="<util:msg name="i18n" key="dueOn"/>"/> <%
        %> <AmlText text=": <cal:dateformat name="duedate" format="$[i18n:parsedatefmt]"/>"/><%
        %><AmlBr/><%

        %><util:if property="allDay"><%
            %><AmlText text="<util:msg name="i18n" key="dueAt"/>"/> <%
            %><AmlText text=": <util:msg name="i18n" key="alldaytask"/>"/><%
        %></util:if><%
        %><util:ifnot property="allDay"><%
            %><AmlText text="<util:msg name="i18n" key="dueAt"/>"/> <%
            %><AmlText text=": <cal:dateformat name="duedate" format="$[i18n:timefmt]"/>"/><%
        %></util:ifnot><%
        %><AmlBr/><%
    %></util:if><%

%><%-- details --%><%

    %><AmlText text="<util:msg name="i18n" key="details"/>: <cal:get property="description" edit="edit2"/>"/><%
    %><AmlBr/><%
    %><AmlText text="<util:msg name="i18n" key="location"/>: <cal:get property="location" edit="edit3"/>"/><%
    %><AmlBr/><%

%><%-- Status --%><%
    %><util:if property="completed"><%
       %><AmlText text="<util:msg name="i18n" key="stat"/>: <util:msg name="i18n" key="cmp"/>"/><%
    %></util:if><%
    %><util:ifnot property="completed"><%
       %><AmlText text="<util:msg name="i18n" key="stat"/>: <util:msg name="i18n" key="incmp"/>"/><%
    %></util:ifnot>

<%-- Not a repeating task?  --%><%

    %><util:ifnot property="recurrence"><%

    	%><cal:context><%
        %><util:if property="userTheOwner" > <%

            %><AmlGroup halign="left"><%

                %><%-- change task --%><%
                %><AmlLink><%
                    %><AmlURL action="<util:url file="taskSess.jsp" comp="cal"/>"><%
                        %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                        %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                    %></AmlURL><%
                    %><AmlText text="<util:msg name="i18n" key="changetask"/>" /><%
                %></AmlLink><AmlBr/><%

                %><%-- delete task --%><%
                    %><AmlLink><%
                        %><AmlURL action="<util:url file="deleteTask.jsp" comp="cal"/>"><%
                            %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                            %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                         %></AmlURL><%
                         %><AmlText text="<util:msg name="i18n" key="delete"/>" /><%
                    %></AmlLink><AmlBr/><%
            %></AmlGroup><%
        %></util:if> <%
	    %></cal:context><%
    %></util:ifnot><%

    %><%-- 
        Is repeating task? 
        Go to Delete or Change card and present the selection UI:
        This one only 
        This and future ones
      --%><%
     %><util:if property="recurrence"><%
        %><cal:context><%
            %><util:if property="userTheOwner"><%

            %><AmlGroup halign="left"><%
                %><AmlText text="<util:msg name="i18n" key="repeatTask"/>" /><%
                %><AmlBr/><%
                %><AmlLink url="#mod" text="<util:msg name="i18n" key="changetask"/>" /><%
                %><AmlBr/><%
                %><AmlLink url="#del" text="<util:msg name="i18n" key="deletetask"/>" /><%
                %><AmlBr/><%
            %></AmlGroup><%
        %></util:if><%
        %></cal:context><%
     %></util:if>
 <AmlControlMenu><%
	 %><AmlURL action="<util:url file="dayview.jsp" comp="cal"/>"><%
            %><AmlParam name="d" value="<util:get eval="$(d)"/>"/><%
        %></AmlURL><%
        %><AmlText text="<util:msg name="i18n" key="calhm"/>"/><%
  %></AmlControlMenu>

</AmlPage>

<util:if property="recurrence">
    <AmlPage id="del" title="<%= i18n.getMsg("delete") %>"><%
            %><AmlLink><%
                %><AmlURL action="<util:url file="deleteTask.jsp" comp="cal"/>" ><%
                    %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                    %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                    %><AmlParam name="mod" value="<%= RecurrencePattern.THIS_INSTANCE %>" /><%
                %></AmlURL><%
                %><AmlText text="<util:msg name="i18n" key="thisone"/>"/><%
            %></AmlLink><AmlBr/><%

            %><AmlLink><%
                %><AmlURL action="<util:url file="deleteTask.jsp" comp="cal"/>" ><%
                    %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                    %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                    %><AmlParam name="mod" value="<%= RecurrencePattern.THIS_AND_FUTURE %>" /><%
                %></AmlURL><%
                %><AmlText text="<util:msg name="i18n" key="thisandfuture"/>"/><%
            %></AmlLink><AmlBr/>
    </AmlPage>

    <AmlPage id="mod" title="<%= i18n.getMsg("changetask") %>"><%
            %><AmlLink><%
                %><AmlURL action="<util:url file="taskSess.jsp" comp="cal"/>" ><%
                    %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                    %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                    %><AmlParam name="mod" value="<%= RecurrencePattern.THIS_INSTANCE %>" /><%
                %></AmlURL><%
                %><AmlText text="<util:msg name="i18n" key="thisone"/>"/><%
            %></AmlLink><AmlBr/><%

            %><AmlLink><%
                %><AmlURL action="<util:url file="taskSess.jsp" comp="cal"/>" ><%
                    %><AmlParam name="d" value="<util:get eval="$(d)"/>" /><%
                    %><AmlParam name="tid" value="<util:get eval="$(tid)"/>" /><%
                    %><AmlParam name="mod" value="<%= RecurrencePattern.THIS_AND_FUTURE %>" /><%
                %></AmlURL><%
                %><AmlText text="<util:msg name="i18n" key="thisandfuture"/>"/><%
            %></AmlLink><AmlBr/>
    </AmlPage>

</util:if>
</cal:task>
</AmlDocument>
