#!/usr/bin/perl
#
# Import script for an S1PS 6.2 migration from 3.01B and later
#

@robotdbs = ("enumerate.db", "enumerate_bak.db", "vid.db", "url-visited.db" );
undef $OldInstance, $BaseDir, $NewInstance;
while (1) {
    undef $tmp;
    $tmp = shift @ARGV;
    if (!$tmp) {
	usage() if (!$BaseDir or !$OldInstance or !$NewInstance);
	last;
    }
    
    usage() if ($tmp eq "--help");
    version() if ($tmp eq "--version");
    if ($tmp eq "-i" or $tmp eq "-I") {
	$OldInstance = shift @ARGV;
	usage if (!$OldInstance);
    }
    elsif ($tmp eq "-p" or $tmp eq "-P") {
	$BaseDir = shift @ARGV;
	usage if (!$BaseDir);
    }
    elsif ($tmp eq "-o" or $tmp eq "-O") {
	$NewInstance = shift @ARGV;
	usage if (!$NewInstance);
    }
    else {
	usage();
    }
}
#$OldInstance = shift @ARGV;
#$NewInstance = shift @ARGV;
#$BaseDir = shift @ARGV;
#usage() if (!$BaseDir or !$OldInstance or !$NewInstance);

    $hn = `hostname`;
    chomp($hn);
    $dn = `domainname`;
    chomp($dn);
    $WebHost = "$hn.$dn"; 

# Checking OS
if ($^O eq "MSWin32") {
    $cwd = `cd`;
    $cp_sep = ";";
}
else {
    $cwd =`pwd`;
    $cp_sep = ":";
}
chomp($cwd);
if ($NewInstance) {
    $NewCSRoot = $NewInstance;
}
else {
    $NewCSRoot = $cwd;
}

# the is_ias flag is obsolated
$is_ias = "n";
if ( -e "$BaseDir/ias/user/java/jre/bin/java") {
    $is_ias = "y";
}

if ( ! -e "$BaseDir/SUNWps/lib/searchserver.jar") {
    print "It is not a valid Sun ONE PS install root: $BaseDir\n";
    return 0;
}

$cs_bin = "$BaseDir/SUNWps/lib/";

$OldInstance =~ s!/$!!o;
$NewCSRoot =~ s!/$!!o;
$BaseDir =~ s!/$!!o;
import_instance($OldInstance);
exit(0);

sub import_instance {
    my($OldNickDir) = @_;

#check whether ready to migrate 
    
    my($infofn);
    $infofn  = "$OldNickDir/tmp/migration60.info";
    if (! -e "$infofn") {
	print "Invalid import source directory\n";
	return 0;
    }
    if (! -e "$NewCSRoot/config/search.conf") {
	print "Invalid destination directory\n";
	return 0;
    }
    if (-e "$OldNickDir/logs/pid" || -e "$OldNickDir/logs/robot.pid") {
	print "Please stop the source server and robot first.\n";
	return 0;
    }
    if (-e "$NewCSRoot/logs/robot.pid") {
	print "Please stop the target robot first.\n";
	return 0;
    }
    if ($is_ias ne "y") {
	$new_nick = $NewCSRoot;
	$new_nick =~ s!^.*https-([^\/]*).*$!https-$1!;
	if (-e "$BaseDir/SUNWam/servers/$new_nick/logs/pid") {
	    print "Please stop the target server first.\n";
	    return 0;
	}
    }

    undef $doit, $isIPS, $oldroot, $port, $user, $shost, $nick, $docroot;
    undef $charset, $version;
    open(CONF_OLD, $infofn) or die "Migration information missing";
    while(<CONF_OLD>) {
	    $version = $1 if m/^OldVersion=(\S+)/i;
	    $doit = $1 if m/^DoMigrate=(\S+)/i;
	    $oldroot = $1 if m/^OldServerRoot=(\S+)/i;
	    $port = $1 if m/^NewServerPort=(\d+)/i;
	    $user = $1 if m/^NewServerUser=(\S+)/i;
	    $shost = $1 if m/^NewServerHost=(\S+)/i;
	    $nick = $1 if m/^NewServerID=(\S+)/i;
	    $charset = $1 if m/^OldCharSet=(\S+)/i;
    }
    close(CONF_OLD);
    return 0 if ($doit eq "0");
   
    $port = "301csp1" if (!$version);
    $port = "80" if (!$port);
    $shost = $WebHost if (!$shost);
    if (!$nick) {
	$nick = $WebHost;
    }
    $charset = "iso-8859-1" if (!$charset);


        if ($version eq "301c") { # 301b not migrated
            $robotdir="$OldInstance/robot";
            for ($i = 0; $i < scalar(@robotdbs) ; $i++) {
                if ( -e "$robotdir/$robotdbs[$i]" ) {
                    upgrade_db("$robotdir/$robotdbs[$i]");
                }
            }
        }

        if (-e "$OldInstance/tmp/migration.ldif") { # now import it
            # no! too many steps might go wrong
            # need user run it manually
            
            #$ldcmd = "pkginfo -l SUNWamsvc | grep BASEDIR";
            #$tmp = `$cmd`;
            #$tmp =~ m/   BASEDIR:  (\S+)/i and $ambase = $1;
            #$ldcmd = "$ambase/SUNWam/bin/ldapmodify";
            #$ldcmd .= " $OldInstance/tmp/PKMigrate.ldif";
            #$nr = system($cmd);
            #return $nr if ($nr != 0);
        }


    my($BD, $cmd, $nr, $jarpath); 
    $nr = 0;
    $NS = "\"$NewServerRoot\"";
    
# Now migrate data
    
    $BD = "\"$BaseDir\"";
    $cmd = "env LD_LIBRARY_PATH=$BD/SUNWps/lib ";
    if ( !$ENV{'JAVA_HOME'} ) {
	if ($is_ias == "y") {
	    if (! -e "$BaseDir/ias/user/java/jre/bin/java") {
		$cmd .= "java";
	    }
	    else {
		$cmd .= "$BD/ias/user/java/jre/bin/java";
	    }
	}
	else {
	   $cmd .= "$NS/bin/https/jre/bin/java";
	}
    }
    else {
	$cmd .= "\"$ENV{'JAVA_HOME'}/bin/java\"";
    }
    undef $oldnick;
    $temp = $OldInstance;
    if ($version eq "301b") {
        $temp =~ m/compass-(\S+)/i and $oldnick = $1;
    }
    else {
        $temp =~ m/https-(\S+)/i and $oldnick = $1;
    }
    
    $jarpath = "$BD/SUNWps/lib";

    # discussion migration if it is pro 

    if (-e "$OldInstance/config/gv_tax.conf") {
        $cmd .= " -classpath $jarpath/searchserver.jar:$jarpath/db.jar:$jarpath/nova.jar";
        $cmd .= " com/sun/portal/search/rdmgr/DiscussionMigrate ";	
        $cmd .= " \"$OldInstance\"/tmp/migration60.soif";
        $cmd .= " \"$OldInstance\"/tmp/discussion62.soif";
        $cmd .= " \"$OldInstance\"/tmp/migration62.soif";
        $nr = system($cmd);
        return $nr if ($nr != 0);
    }

    # instance migration
    $cmd .= " -classpath $jarpath/searchserver.jar:$jarpath/db.jar:$jarpath/nova.jar";
    $cmd .= " com/sun/portal/search/rdmgr/SearchMigrate ";	
    $cmd .= " \"$oldroot\" \"$OldInstance\" $is_ias $BD";
    $cmd .= " $oldnick \"$NewCSRoot\"";
# for nomral migration, the new csid is always get from the setup ps
    $cmd .= " \"x-catalog://$shost:$port/$nick\" $charset $version";
    
    $nr = system($cmd);
    return $nr if ($nr != 0);
}

sub upgrade_db {
    my($dbfile) = @_; 
    my($nr);
    print "Upgrading $dbfile...\n";
    $nr = system("env LD_LIBRARY_PATH=\"$BaseDir/SUNWps/lib\" $cs_bin/db_upgrade $dbfile");
    if ($nr !=0) {
	print "Error($nr)\n";
    }
    else {
	print "Done\n";
    }
    return $nr;
}

sub usage {
    print "This script is used to upload Compass Server 3.01B and later data to Sun ONE PS 6.2\n";
    print "Usage: import.pl -o Target_Instance -i Source_Instance -p PS_Install\n";
    print "OPTIONS\n";
    print "  -o <directory> where <directory> is the new PS instance Search root\n";
    print "  -i <directory> where <directory> is the path to the old instance\n";
    print "  -p <directory> where <directory> is the PS install directory\n";
    exit(1);
}

sub version {
    print "Name: Sun ONE PS import utility for Compass Server\n";
    print "Version: 6.2\n";
    print "Product: Sun ONE Portal Server\n";
    exit(1);
}

