/**
 * Copyright  2002 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.portal.sample.j2ee.count.ejb;

import java.util.*; 
import java.io.*; 

/**
 * A simple stateless bean for the count application. This bean implements one
 * business method as declared by the remote interface.
 */
public class CountEJB implements javax.ejb.SessionBean { 

    private  javax.ejb.SessionContext m_ctx = null; 
    private  int count = 0;
   
    /**
     * Sets the session context. Required by EJB spec.
     * @param ctx A SessionContext object.
     */
    public void setSessionContext(javax.ejb.SessionContext ctx) { 
        m_ctx = ctx; 
    } 

    /**
     * Creates a bean. Required by EJB spec.
     * @exception throws CreateException.
     */
    public void ejbCreate() throws java.rmi.RemoteException, javax.ejb.CreateException { 
        System.out.println("ejbCreate() on obj " + this); 
    } 

    /**
     * Removes the bean. Required by EJB spec.
     */
    public void ejbRemove() { 
        System.out.println("ejbRemove() on obj " + this); 
    } 

    /**
     * Loads the state of the bean from secondary storage. Required by EJB spec.
     */
    public void ejbActivate() { 
        System.out.println("ejbActivate() on obj " + this); 
    } 

    /**
     * Serializes the state of the bean to secondary storage. Required by EJB spec.
     */
    public void ejbPassivate() { 
        System.out.println("ejbPassivate() on obj " + this); 
    } 

    /**
     * Required by EJB spec.
     */
    public void Count() { 
    } 


    /**
     * Increment and returns the value of a counter.
     * @return returns the value of the counter as an integer .
     * @exception throws a RemoteException.
     */
    public int getCount() throws java.rmi.RemoteException { 
        return ++count; 
    } 
} 
