<%--
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>

<%@ page session="false" %>

<%-- layoutdoedit.jsp --%>

<%@ page import="com.sun.portal.providers.containers.jsp.single.JSPSingleContainerProvider,
                 com.sun.portal.providers.ProviderException,
                 com.sun.portal.providers.context.ContainerProviderContext,
                 com.sun.portal.providers.context.ProviderContextException,
                 java.util.*"
%>
<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>

<%
  JSPSingleContainerProvider scp = (JSPSingleContainerProvider)pageContext.getAttribute("JSPProvider");

  // read container name passed from client config provider
  String containerParam = request.getParameter("container");
  if (containerParam == null) {
    throw new ProviderException("layoutdoedit.jsp: container parameter missing.");
  }
  ContainerProviderContext context = scp.getContainerProviderContext();
  Map channelsRow = null;
  String defaultChannelRow = null;
  try {

    channelsRow = context.getCollectionProperty(containerParam, "channelsRow");
    defaultChannelRow = context.getStringProperty(containerParam, "defaultChannelRow");
  } catch (ProviderContextException e) {
    throw new ProviderException("layoutdoedit.jsp: ", e);
  }

  // If order is non-null, the providers are in a list
  String[] order = request.getParameterValues("order");

  if (order != null) {
    // this is for html client only
    for (int i = 0; i < order.length; i++) {
      channelsRow.put(order[i], String.valueOf(i + 1));
    }

    if (context.isDebugMessageEnabled()) {
      context.debugMessage("layoutdoedit.jsp: channelsRow=" + channelsRow);
    }
  }

  try {
    context.setCollectionProperty(containerParam, "channelsRow", channelsRow);
  } catch (ProviderContextException e) {
    throw new ProviderException("layoutdoedit.jsp: ", e);
  }

  try {
      if (context.existsBooleanProperty(containerParam, "defaultChannelIsMinimized")) {
          String loadChannels = request.getParameter("loadChannels");
          if (loadChannels != null) {
              context.setBooleanProperty(containerParam, "defaultChannelIsMinimized", false);
          } else {
              context.setBooleanProperty(containerParam, "defaultChannelIsMinimized", true);
          }
      }
  } catch (ProviderContextException pce) {
      throw new ProviderException("layoutdoedit.jsp: ", pce);
  }

  Map map = new HashMap();
  map.put("action", "edit");
  map.put("provider", "WirelessJSPClientConfigContainer");
  pageContext.setAttribute("desktop_map", map);
%>

<dt:obtainContainer container="$JSPProvider">
<dtpc:getDesktopURL id="url" querymap="$desktop_map"/>
<%
  response.sendRedirect((String)pageContext.getAttribute("url"));
%>
</dt:obtainContainer>

