<%--   
 Copyright 2003 Sun Microsystems, Inc. All rights reserved
 Use is subject to license terms.
--%>
<%@ page session="false" %>

<%@ taglib uri="/tld/desktopProviderContext.tld" prefix="dtpc" %>
<%@ taglib uri="/tld/desktopContainerProviderContext.tld" prefix="dtcpc" %>
<%@ taglib uri="/tld/desktop.tld" prefix="dt" %>
<%@ taglib uri="/tld/jx.tld" prefix="jx" %>

<%@ page import="java.util.List"%>
<%@ page import="java.util.Set"%>
<%@ page import="java.lang.String"%>
<%@ page import="java.lang.Boolean"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="java.util.ArrayList"%>

<%@ page import="com.sun.portal.wireless.providers.containers.jsp.list.JSPNativeContainerProvider"%>

<% 
  // Get the container  
  JSPNativeContainerProvider wcp = (JSPNativeContainerProvider)pageContext.getAttribute("JSPProvider");

  // Get the minimized flag and store it
  boolean channelsAreMinimized = wcp.getBooleanProperty("defaultChannelIsMinimized", true);
  pageContext.setAttribute("channelsAreMinimized", new Boolean(channelsAreMinimized));

  // Get the maximized channel
  String maximizedChannel = wcp.getMaximizedChannel(request);
  boolean hasMaximizedChannel = (maximizedChannel != null);
  pageContext.setAttribute("hasMaximizedChannel", new Boolean(hasMaximizedChannel));

  if (hasMaximizedChannel) {
      pageContext.setAttribute("maximizedChannel", maximizedChannel);
  }

  String imageName = "";
  Set ccppAccepts =
          wcp.getProviderContext().getClientTypeProperties(
                  wcp.getProviderContext().getClientType(),
                    "CcppAccept");

    if ((ccppAccepts != null) &&
            (ccppAccepts.contains("image/gif") || ccppAccepts.contains("*/*"))) {
      imageName = "logo.gif";
  } else if ((ccppAccepts != null) && ccppAccepts.contains("image/vnd.wap.wbmp")) {
      imageName = "logo.wbmp";
  }

  // Counter for iteration
  int     count      = 0;

  // Desktop channel list
  List orderedChannelList = null;

  // If inlined, we will do chunking, replacing the orderedChannelList
  if (!channelsAreMinimized) {
    // Get the paged content map
    Map chunkedContentMap = wcp.getChunkedContentMap(request, response);

    // Which page do we need to display?
    String pageNumStr = request.getParameter("Page");
    
    if ( pageNumStr == null ) {
      pageNumStr = "1";
    }
    
    try {
      Integer pageIdx = new Integer(pageNumStr);

      // Lookup the page
      ArrayList channelList = (ArrayList)chunkedContentMap.get(pageIdx);
      orderedChannelList    = channelList;
  
      // Store it
      if(channelList != null){
    	  pageContext.setAttribute("orderedChannelList", channelList);
	  pageContext.setAttribute("channelsEmpty", new Boolean("false"));
      } else {
	  pageContext.setAttribute("orderedChannelList", "");
	  pageContext.setAttribute("channelsEmpty", new Boolean("true"));
      } 
      pageContext.setAttribute("pageIdx", pageIdx);
      pageContext.setAttribute("maxPage", new Integer(chunkedContentMap.size()));
    } catch (NullPointerException npe) {
      wcp.getProviderContext().debugError("dtSetup.jsp : Error trying to render desktop", npe);
    } catch (NumberFormatException nfe) {
      wcp.getProviderContext().debugError("dtSetup.jsp : Error trying to render desktop", nfe);
    } catch (ClassCastException cce) {
      wcp.getProviderContext().debugError("dtSetup.jsp : Error trying to render desktop", cce);
    }
  } else {
    // Get the ordered channel list and store it
    orderedChannelList = wcp.getOrderedSelectedChannels(request);
    if(orderedChannelList != null){
        pageContext.setAttribute("orderedChannelList", orderedChannelList);
        pageContext.setAttribute("channelsEmpty", new Boolean("false"));
    } else {
        pageContext.setAttribute("orderedChannelList", "");
        pageContext.setAttribute("channelsEmpty", new Boolean("true"));
    } 
  }
%>

