/*
 *  Copyright (c) 2000 Sun Microsystems.  All rights reserved.
 *  All rights reserved.
 * 
 *  Use of this software is governed by the terms of the license agreement 
 *  for the Sun ONE Compass Server between the parties.
 */


/* ------------------------------------------------------------------------ */


/*
 *  Sun ONE Compass Server -- RobotAPI (based in part on NSAPI)
 *
 *  The RobotAPI can be used to extend or customize the functionality
 *  of the Compass Robot through the use of NSAPI-like extension 
 *  libraries which consist of 'RobotAPIFn' functions that are 
 *  referenced from within the Robot's filter.conf configuration file.
 *
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#ifndef _COMPASS_ROBOTAPI_H_
#define _COMPASS_ROBOTAPI_H_

#include "csmem.h"
#include "base/systems.h"		/* NSAPI_PUBLIC */
#include "libcs/pblock.h"		/* for pblock structure */
#include "soif.h"			/* for SOIF */
#include "libcs/cs.h"			/* for CSIO, CSHashTable, etc. */

/* Basic data types */
typedef struct robot_cscount_s CSCount;
typedef struct robot_csresource_s CSResource;
typedef struct robot_csfilter_s CSFilter;
typedef struct robot_cs_directive_s cs_directive;
typedef struct robot_cs_directive_table_s cs_directive_table;
typedef struct robot_csdirectives_s CSDirectives;
typedef int (*RobotAPIFn)(libcs_pblock *, CSFilter *, CSResource *);

/* Basic structures */
struct robot_csresource_s {	/* CSResource */
    char *url;			/* URL of the object */
    libcs_pblock *sources;	/* Sources of information */
    libcs_pblock *vars;		/* working variables */
    CSIO *data;			/* Access to the data */
    SOIF *rd;			/* Resulting resource description */
    int depth;			/* Depth of the object from root */
    int rdepth;			/* Real Depth of the object from start_point */
    int skip_retrieval;		/* Should the Robot skip retrieval? */
    void *fe_data;		/* arbitrary data for front-end */
    void *hidden;		/* access to internals */
    int (*spawn)(void *self, char *url); /* to spawn new object */
    char *why_filter_out;	/* reason why filtered */
};
/* Use the following macros */
#define CSResource_Spawn(_x, _url)	(*(_x)->spawn)((_x), (_url))
#define CSResource_GetURL(_x)		(_x)->url
#define CSResource_GetSource(_x, _n) \
    (((_n) && !strcmp((_n), "url")) ? CSResource_GetURL(_x) : libcs_pblock_findval((_n),(_x)->vars))
#define CSResource_SetRejectReason(_x,_s) (_x)->why_filter_out = (_s)
#define CSResource_GetRejectReason(_x)	(_x)->why_filter_out

/* Directive table for control of execution */
struct robot_cs_directive_s {
    libcs_pblock *param;
    libcs_pblock *client;
};

struct robot_cs_directive_table_s {
    int ni;
    cs_directive *inst;
};

struct robot_csdirectives_s {
    libcs_pblock *name;
    int nd;
    cs_directive_table *dt;
};

struct robot_cscount_s {
    int count;
    int max;
};

#define VISITED_HOST	0
#define VISITED_MD5	1


#include "cscinfo.h"			/* For CSCinfo structure */
#include "filterrules.h"		/* For FR_Manager */

struct robot_csfilter_s {	/* CSFilter */
    char *name;		/* Name of the filter */
    CSDirectives *dirs;	/* Directives and order of execution */
    CSCinfo *cdb;		/* content-type database */
    CSCount hosts;		/* Number of hosts visited */
    CSCount objects;	/* Number of objects visited */
    FR_Manager *mgr;	/* Filter Rules Manager */

    int nvisited;		/* number of slots in visited */
    CSHashTable **visited;	/* hash tables to track where we've been */
    void **fe_data;		/* arbitrary data for front-end */
    int nfe_data;		/* number of slots in fe_data */

    void *hidden;		/* access to internals */
};

/*
 * The REQ_ return codes. These codes are used to determine what the server
 * should do after a particular module completes its task.
 *
 * Func type functions return these as do many internal functions.
 */

/* The function performed its task, proceed with the request */
#undef  REQ_PROCEED
#define REQ_PROCEED (0)
/* The entire request should be aborted: An error occurred */
#undef  REQ_ABORTED
#define REQ_ABORTED (-1)
/* The function performed no task, but proceed anyway. */
#undef  REQ_NOACTION
#define REQ_NOACTION (-2)
/* Tear down the session and exit */
#undef  REQ_EXIT
#define REQ_EXIT (-3)
/* Restart the entire request-response process */
#undef  REQ_RESTART
#define REQ_RESTART (-4)

int register_cname2alias(char *cname, char *alias);
int register_cname2alias_rules(char *mappings);

/* To spawn a new url without context. referer can be NULL */
NSAPI_PUBLIC int ndsapi_spawn_url(char *referer, char *url, int depth, int rdepth, int priority, char * charset, int charset_status);

/*
 * format() returns NULL if the input is NULL
 * or if there is not enough memory (never for inplace).
 */
#define FMT_INPLACE			1
#define FMT_STRIP_LEADING_WHITE		2
#define FMT_STRIP_TRAILING_WHITE	4
#define FMT_TOLOWER			8
#define FMT_STRIP_EMBEDDED_NEWLINE	16
#define FMT_STRIP_EMBEDDED_TAB		32
#define FMT_STRIP_SURROUNDING_WHITE FMT_STRIP_LEADING_WHITE \
	| FMT_STRIP_TRAILING_WHITE

NSAPI_PUBLIC char *cs_format(char *str, int fmt);

NSAPI_PUBLIC char  cs_tolower(int s);
NSAPI_PUBLIC int   cs_isspace(int c);
NSAPI_PUBLIC char *get_url_protocol(char *url);
NSAPI_PUBLIC char *get_url_host_port(char *url);
NSAPI_PUBLIC int   protocol_http_https(char *url);

/* following require IBM ICU libraries */
/* convert and replace str to utf8 */
NSAPI_PUBLIC char *cs_to_utf8(char *charset, char* str, char * url);
/* convert to utf8 in a new copy */
NSAPI_PUBLIC int cs_dup_utf8(char *charset, char* str, int len, char** dest, char * url);

/* case insensitive version of strstr */
NSAPI_PUBLIC char *strcasestr(const char *s1, const char *s2);

#endif	/* _COMPASS_ROBOTAPI_H_ */
