/*
 *  Copyright (c) 2000 Sun Microsystems.  All rights reserved.
 *  All rights reserved.
 * 
 *  Use of this software is governed by the terms of the license agreement 
 *  for the Sun ONE Compass Server between the parties.
 */


/* ------------------------------------------------------------------------ */


/*
 *  logging facilities -- 
 *	cslog(mod, level, ("blah %s %d", a, b));	--- normal
 *	cslog_error(mod, level, ("blah %s %d", a, b));	--- error statement
 *	cslog_debug(mod, level, ("blah %s %d", a, b));	--- debug statement
 * Copyright 2003 Sun Microsystems, Inc. All
 * rights reserved. Use of this product is subject
 * to license terms. Federal Acquisitions:
 * Commercial Software -- Government Users
 * Subject to Standard License Terms and
 * Conditions.
 *
 * Sun, Sun Microsystems, the Sun logo, and Sun ONE
 * are trademarks or registered trademarks of Sun Microsystems,
 * Inc. in the United States and other countries.
 */
#ifndef _LIBCS_LOG_H_
#define _LIBCS_LOG_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef enum cslogtype {
	CSLOG_NORMAL = 0,
	CSLOG_DEBUG,
	CSLOG_WARN,
	CSLOG_ERROR,
	CSLOG_MINI
} CSLOGTYPE;

NSAPI_PUBLIC void cslog_init(int, char *);
NSAPI_PUBLIC void cslog_terminate(void);
NSAPI_PUBLIC void _cslog_do_print(char *fmt, ...);
NSAPI_PUBLIC void _cslog_set_params(CSLOGTYPE, char *, int);
NSAPI_PUBLIC char *cslog_linestr(char *);
NSAPI_PUBLIC void cslog_set_level(int level);
NSAPI_PUBLIC void cslog_set_rotate_size(long size);
NSAPI_PUBLIC void cslog_rotate_now(int JustDoIt);

extern int _cslog_level;	/* global read-only variable */
extern int _cslog_module;	/* global read-only variable */

/*
 *  This log format is compatible with the PR_LOG(module, level, args)
 *  interface as of 3/13/96 in NSPR.
 *  Currently, the m variable isn't used...
 */

#define cslog_check(_m,_l) \
	(((_l) <= _cslog_level) /*&& ((_m) == _cslog_module)*/ )

#define CSLOG(_t,_m,_l,_x) \
	do { \
		if (cslog_check(_m,_l)) { \
			_cslog_set_params(_t, __FILE__, __LINE__); \
			_cslog_do_print _x; \
		} \
	} while (0)

#if defined(PUMPKIN_HOUR) || defined(DEBUG)
#define cslog_debug(_m,_l,_x) \
	CSLOG(CSLOG_DEBUG,_m,_l,_x)
#else
#define cslog_debug(_m,_l,_x)
#endif

#define cslog_error(_m,_l,_x) \
	CSLOG(CSLOG_ERROR,_m,_l,_x)

#define cslog_warn(_m,_l,_x) \
	CSLOG(CSLOG_WARN,_m,_l,_x)

#define cslog(_m,_l,_x) \
	CSLOG(CSLOG_NORMAL,_m,_l,_x)

#define _cslog_str(p)	\
    (((p) == NULL) ? "(null)" : ((*(p) == '\0') ? "(empty)" : (p)))

#define CSLOG_TIMEFMT "[%d/%b/%Y:%H:%M:%S]"

#ifdef __cplusplus
};
#endif

#endif
